package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class IssuerSpecBuilder extends IssuerSpecFluent<IssuerSpecBuilder> implements VisitableBuilder<IssuerSpec,IssuerSpecBuilder>{
  public IssuerSpecBuilder() {
    this(new IssuerSpec());
  }
  
  public IssuerSpecBuilder(IssuerSpecFluent<?> fluent) {
    this(fluent, new IssuerSpec());
  }
  
  public IssuerSpecBuilder(IssuerSpecFluent<?> fluent,IssuerSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public IssuerSpecBuilder(IssuerSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  IssuerSpecFluent<?> fluent;
  
  public IssuerSpec build() {
    IssuerSpec buildable = new IssuerSpec(fluent.buildAcme(),fluent.buildCa(),fluent.buildSelfSigned(),fluent.buildVault(),fluent.buildVenafi());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}