/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.acme.v1alpha2;

import io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeSolver;
import io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeSolverBuilder;
import io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeSolverFluent;
import io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEExternalAccountBinding;
import io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEExternalAccountBindingBuilder;
import io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEExternalAccountBindingFluent;
import io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEIssuer;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ACMEIssuerFluent<A extends ACMEIssuerFluent<A>>
extends BaseFluent<A> {
    private Boolean disableAccountKeyGeneration;
    private String email;
    private Boolean enableDurationFeature;
    private ACMEExternalAccountBindingBuilder externalAccountBinding;
    private String preferredChain;
    private SecretKeySelectorBuilder privateKeySecretRef;
    private String server;
    private Boolean skipTLSVerify;
    private ArrayList<ACMEChallengeSolverBuilder> solvers = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ACMEIssuerFluent() {
    }

    public ACMEIssuerFluent(ACMEIssuer instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ACMEIssuer instance) {
        ACMEIssuer aCMEIssuer = instance = instance != null ? instance : new ACMEIssuer();
        if (instance != null) {
            this.withDisableAccountKeyGeneration(instance.getDisableAccountKeyGeneration());
            this.withEmail(instance.getEmail());
            this.withEnableDurationFeature(instance.getEnableDurationFeature());
            this.withExternalAccountBinding(instance.getExternalAccountBinding());
            this.withPreferredChain(instance.getPreferredChain());
            this.withPrivateKeySecretRef(instance.getPrivateKeySecretRef());
            this.withServer(instance.getServer());
            this.withSkipTLSVerify(instance.getSkipTLSVerify());
            this.withSolvers(instance.getSolvers());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Boolean getDisableAccountKeyGeneration() {
        return this.disableAccountKeyGeneration;
    }

    public A withDisableAccountKeyGeneration(Boolean disableAccountKeyGeneration) {
        this.disableAccountKeyGeneration = disableAccountKeyGeneration;
        return (A)((Object)this);
    }

    public boolean hasDisableAccountKeyGeneration() {
        return this.disableAccountKeyGeneration != null;
    }

    public String getEmail() {
        return this.email;
    }

    public A withEmail(String email) {
        this.email = email;
        return (A)((Object)this);
    }

    public boolean hasEmail() {
        return this.email != null;
    }

    public Boolean getEnableDurationFeature() {
        return this.enableDurationFeature;
    }

    public A withEnableDurationFeature(Boolean enableDurationFeature) {
        this.enableDurationFeature = enableDurationFeature;
        return (A)((Object)this);
    }

    public boolean hasEnableDurationFeature() {
        return this.enableDurationFeature != null;
    }

    public ACMEExternalAccountBinding buildExternalAccountBinding() {
        return this.externalAccountBinding != null ? this.externalAccountBinding.build() : null;
    }

    public A withExternalAccountBinding(ACMEExternalAccountBinding externalAccountBinding) {
        this._visitables.remove((Object)"externalAccountBinding");
        if (externalAccountBinding != null) {
            this.externalAccountBinding = new ACMEExternalAccountBindingBuilder(externalAccountBinding);
            this._visitables.get((Object)"externalAccountBinding").add(this.externalAccountBinding);
        } else {
            this.externalAccountBinding = null;
            this._visitables.get((Object)"externalAccountBinding").remove((Object)this.externalAccountBinding);
        }
        return (A)((Object)this);
    }

    public boolean hasExternalAccountBinding() {
        return this.externalAccountBinding != null;
    }

    public ExternalAccountBindingNested<A> withNewExternalAccountBinding() {
        return new ExternalAccountBindingNested(null);
    }

    public ExternalAccountBindingNested<A> withNewExternalAccountBindingLike(ACMEExternalAccountBinding item) {
        return new ExternalAccountBindingNested(item);
    }

    public ExternalAccountBindingNested<A> editExternalAccountBinding() {
        return this.withNewExternalAccountBindingLike(Optional.ofNullable(this.buildExternalAccountBinding()).orElse(null));
    }

    public ExternalAccountBindingNested<A> editOrNewExternalAccountBinding() {
        return this.withNewExternalAccountBindingLike(Optional.ofNullable(this.buildExternalAccountBinding()).orElse(new ACMEExternalAccountBindingBuilder().build()));
    }

    public ExternalAccountBindingNested<A> editOrNewExternalAccountBindingLike(ACMEExternalAccountBinding item) {
        return this.withNewExternalAccountBindingLike(Optional.ofNullable(this.buildExternalAccountBinding()).orElse(item));
    }

    public String getPreferredChain() {
        return this.preferredChain;
    }

    public A withPreferredChain(String preferredChain) {
        this.preferredChain = preferredChain;
        return (A)((Object)this);
    }

    public boolean hasPreferredChain() {
        return this.preferredChain != null;
    }

    public SecretKeySelector buildPrivateKeySecretRef() {
        return this.privateKeySecretRef != null ? this.privateKeySecretRef.build() : null;
    }

    public A withPrivateKeySecretRef(SecretKeySelector privateKeySecretRef) {
        this._visitables.remove((Object)"privateKeySecretRef");
        if (privateKeySecretRef != null) {
            this.privateKeySecretRef = new SecretKeySelectorBuilder(privateKeySecretRef);
            this._visitables.get((Object)"privateKeySecretRef").add(this.privateKeySecretRef);
        } else {
            this.privateKeySecretRef = null;
            this._visitables.get((Object)"privateKeySecretRef").remove((Object)this.privateKeySecretRef);
        }
        return (A)((Object)this);
    }

    public boolean hasPrivateKeySecretRef() {
        return this.privateKeySecretRef != null;
    }

    public A withNewPrivateKeySecretRef(String key, String name) {
        return this.withPrivateKeySecretRef(new SecretKeySelector(key, name));
    }

    public PrivateKeySecretRefNested<A> withNewPrivateKeySecretRef() {
        return new PrivateKeySecretRefNested(null);
    }

    public PrivateKeySecretRefNested<A> withNewPrivateKeySecretRefLike(SecretKeySelector item) {
        return new PrivateKeySecretRefNested(item);
    }

    public PrivateKeySecretRefNested<A> editPrivateKeySecretRef() {
        return this.withNewPrivateKeySecretRefLike(Optional.ofNullable(this.buildPrivateKeySecretRef()).orElse(null));
    }

    public PrivateKeySecretRefNested<A> editOrNewPrivateKeySecretRef() {
        return this.withNewPrivateKeySecretRefLike(Optional.ofNullable(this.buildPrivateKeySecretRef()).orElse(new SecretKeySelectorBuilder().build()));
    }

    public PrivateKeySecretRefNested<A> editOrNewPrivateKeySecretRefLike(SecretKeySelector item) {
        return this.withNewPrivateKeySecretRefLike(Optional.ofNullable(this.buildPrivateKeySecretRef()).orElse(item));
    }

    public String getServer() {
        return this.server;
    }

    public A withServer(String server) {
        this.server = server;
        return (A)((Object)this);
    }

    public boolean hasServer() {
        return this.server != null;
    }

    public Boolean getSkipTLSVerify() {
        return this.skipTLSVerify;
    }

    public A withSkipTLSVerify(Boolean skipTLSVerify) {
        this.skipTLSVerify = skipTLSVerify;
        return (A)((Object)this);
    }

    public boolean hasSkipTLSVerify() {
        return this.skipTLSVerify != null;
    }

    public A addToSolvers(int index, ACMEChallengeSolver item) {
        if (this.solvers == null) {
            this.solvers = new ArrayList();
        }
        ACMEChallengeSolverBuilder builder = new ACMEChallengeSolverBuilder(item);
        if (index < 0 || index >= this.solvers.size()) {
            this._visitables.get((Object)"solvers").add(builder);
            this.solvers.add(builder);
        } else {
            this._visitables.get((Object)"solvers").add(index, builder);
            this.solvers.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSolvers(int index, ACMEChallengeSolver item) {
        if (this.solvers == null) {
            this.solvers = new ArrayList();
        }
        ACMEChallengeSolverBuilder builder = new ACMEChallengeSolverBuilder(item);
        if (index < 0 || index >= this.solvers.size()) {
            this._visitables.get((Object)"solvers").add(builder);
            this.solvers.add(builder);
        } else {
            this._visitables.get((Object)"solvers").set(index, builder);
            this.solvers.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSolvers(ACMEChallengeSolver ... items) {
        if (this.solvers == null) {
            this.solvers = new ArrayList();
        }
        for (ACMEChallengeSolver item : items) {
            ACMEChallengeSolverBuilder builder = new ACMEChallengeSolverBuilder(item);
            this._visitables.get((Object)"solvers").add(builder);
            this.solvers.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToSolvers(Collection<ACMEChallengeSolver> items) {
        if (this.solvers == null) {
            this.solvers = new ArrayList();
        }
        for (ACMEChallengeSolver item : items) {
            ACMEChallengeSolverBuilder builder = new ACMEChallengeSolverBuilder(item);
            this._visitables.get((Object)"solvers").add(builder);
            this.solvers.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSolvers(ACMEChallengeSolver ... items) {
        if (this.solvers == null) {
            return (A)((Object)this);
        }
        for (ACMEChallengeSolver item : items) {
            ACMEChallengeSolverBuilder builder = new ACMEChallengeSolverBuilder(item);
            this._visitables.get((Object)"solvers").remove((Object)builder);
            this.solvers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSolvers(Collection<ACMEChallengeSolver> items) {
        if (this.solvers == null) {
            return (A)((Object)this);
        }
        for (ACMEChallengeSolver item : items) {
            ACMEChallengeSolverBuilder builder = new ACMEChallengeSolverBuilder(item);
            this._visitables.get((Object)"solvers").remove((Object)builder);
            this.solvers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSolvers(Predicate<ACMEChallengeSolverBuilder> predicate) {
        if (this.solvers == null) {
            return (A)((Object)this);
        }
        Iterator<ACMEChallengeSolverBuilder> each = this.solvers.iterator();
        List visitables = this._visitables.get((Object)"solvers");
        while (each.hasNext()) {
            ACMEChallengeSolverBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ACMEChallengeSolver> buildSolvers() {
        return this.solvers != null ? ACMEIssuerFluent.build(this.solvers) : null;
    }

    public ACMEChallengeSolver buildSolver(int index) {
        return this.solvers.get(index).build();
    }

    public ACMEChallengeSolver buildFirstSolver() {
        return this.solvers.get(0).build();
    }

    public ACMEChallengeSolver buildLastSolver() {
        return this.solvers.get(this.solvers.size() - 1).build();
    }

    public ACMEChallengeSolver buildMatchingSolver(Predicate<ACMEChallengeSolverBuilder> predicate) {
        for (ACMEChallengeSolverBuilder item : this.solvers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSolver(Predicate<ACMEChallengeSolverBuilder> predicate) {
        for (ACMEChallengeSolverBuilder item : this.solvers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSolvers(List<ACMEChallengeSolver> solvers) {
        if (this.solvers != null) {
            this._visitables.get((Object)"solvers").clear();
        }
        if (solvers != null) {
            this.solvers = new ArrayList();
            for (ACMEChallengeSolver item : solvers) {
                this.addToSolvers(item);
            }
        } else {
            this.solvers = null;
        }
        return (A)((Object)this);
    }

    public A withSolvers(ACMEChallengeSolver ... solvers) {
        if (this.solvers != null) {
            this.solvers.clear();
            this._visitables.remove((Object)"solvers");
        }
        if (solvers != null) {
            for (ACMEChallengeSolver item : solvers) {
                this.addToSolvers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSolvers() {
        return this.solvers != null && !this.solvers.isEmpty();
    }

    public SolversNested<A> addNewSolver() {
        return new SolversNested(-1, null);
    }

    public SolversNested<A> addNewSolverLike(ACMEChallengeSolver item) {
        return new SolversNested(-1, item);
    }

    public SolversNested<A> setNewSolverLike(int index, ACMEChallengeSolver item) {
        return new SolversNested(index, item);
    }

    public SolversNested<A> editSolver(int index) {
        if (this.solvers.size() <= index) {
            throw new RuntimeException("Can't edit solvers. Index exceeds size.");
        }
        return this.setNewSolverLike(index, this.buildSolver(index));
    }

    public SolversNested<A> editFirstSolver() {
        if (this.solvers.size() == 0) {
            throw new RuntimeException("Can't edit first solvers. The list is empty.");
        }
        return this.setNewSolverLike(0, this.buildSolver(0));
    }

    public SolversNested<A> editLastSolver() {
        int index = this.solvers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last solvers. The list is empty.");
        }
        return this.setNewSolverLike(index, this.buildSolver(index));
    }

    public SolversNested<A> editMatchingSolver(Predicate<ACMEChallengeSolverBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.solvers.size(); ++i) {
            if (!predicate.test(this.solvers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching solvers. No match found.");
        }
        return this.setNewSolverLike(index, this.buildSolver(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ACMEIssuerFluent that = (ACMEIssuerFluent)((Object)o);
        if (!Objects.equals(this.disableAccountKeyGeneration, that.disableAccountKeyGeneration)) {
            return false;
        }
        if (!Objects.equals(this.email, that.email)) {
            return false;
        }
        if (!Objects.equals(this.enableDurationFeature, that.enableDurationFeature)) {
            return false;
        }
        if (!Objects.equals((Object)this.externalAccountBinding, (Object)that.externalAccountBinding)) {
            return false;
        }
        if (!Objects.equals(this.preferredChain, that.preferredChain)) {
            return false;
        }
        if (!Objects.equals((Object)this.privateKeySecretRef, (Object)that.privateKeySecretRef)) {
            return false;
        }
        if (!Objects.equals(this.server, that.server)) {
            return false;
        }
        if (!Objects.equals(this.skipTLSVerify, that.skipTLSVerify)) {
            return false;
        }
        if (!Objects.equals(this.solvers, that.solvers)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.disableAccountKeyGeneration, this.email, this.enableDurationFeature, this.externalAccountBinding, this.preferredChain, this.privateKeySecretRef, this.server, this.skipTLSVerify, this.solvers, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.disableAccountKeyGeneration != null) {
            sb.append("disableAccountKeyGeneration:");
            sb.append(this.disableAccountKeyGeneration + ",");
        }
        if (this.email != null) {
            sb.append("email:");
            sb.append(this.email + ",");
        }
        if (this.enableDurationFeature != null) {
            sb.append("enableDurationFeature:");
            sb.append(this.enableDurationFeature + ",");
        }
        if (this.externalAccountBinding != null) {
            sb.append("externalAccountBinding:");
            sb.append((Object)((Object)this.externalAccountBinding) + ",");
        }
        if (this.preferredChain != null) {
            sb.append("preferredChain:");
            sb.append(this.preferredChain + ",");
        }
        if (this.privateKeySecretRef != null) {
            sb.append("privateKeySecretRef:");
            sb.append((Object)((Object)this.privateKeySecretRef) + ",");
        }
        if (this.server != null) {
            sb.append("server:");
            sb.append(this.server + ",");
        }
        if (this.skipTLSVerify != null) {
            sb.append("skipTLSVerify:");
            sb.append(this.skipTLSVerify + ",");
        }
        if (this.solvers != null && !this.solvers.isEmpty()) {
            sb.append("solvers:");
            sb.append(this.solvers + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withDisableAccountKeyGeneration() {
        return this.withDisableAccountKeyGeneration(true);
    }

    public A withEnableDurationFeature() {
        return this.withEnableDurationFeature(true);
    }

    public A withSkipTLSVerify() {
        return this.withSkipTLSVerify(true);
    }

    public class SolversNested<N>
    extends ACMEChallengeSolverFluent<SolversNested<N>>
    implements Nested<N> {
        ACMEChallengeSolverBuilder builder;
        int index;

        SolversNested(int index, ACMEChallengeSolver item) {
            this.index = index;
            this.builder = new ACMEChallengeSolverBuilder(this, item);
        }

        public N and() {
            return (N)ACMEIssuerFluent.this.setToSolvers(this.index, this.builder.build());
        }

        public N endSolver() {
            return this.and();
        }
    }

    public class PrivateKeySecretRefNested<N>
    extends SecretKeySelectorFluent<PrivateKeySecretRefNested<N>>
    implements Nested<N> {
        SecretKeySelectorBuilder builder;

        PrivateKeySecretRefNested(SecretKeySelector item) {
            this.builder = new SecretKeySelectorBuilder(this, item);
        }

        public N and() {
            return (N)ACMEIssuerFluent.this.withPrivateKeySecretRef(this.builder.build());
        }

        public N endPrivateKeySecretRef() {
            return this.and();
        }
    }

    public class ExternalAccountBindingNested<N>
    extends ACMEExternalAccountBindingFluent<ExternalAccountBindingNested<N>>
    implements Nested<N> {
        ACMEExternalAccountBindingBuilder builder;

        ExternalAccountBindingNested(ACMEExternalAccountBinding item) {
            this.builder = new ACMEExternalAccountBindingBuilder(this, item);
        }

        public N and() {
            return (N)ACMEIssuerFluent.this.withExternalAccountBinding(this.builder.build());
        }

        public N endExternalAccountBinding() {
            return this.and();
        }
    }
}

