/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.certmanager.api.model.v1alpha3.X509Subject;
import io.fabric8.certmanager.api.model.v1alpha3.X509SubjectFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class X509SubjectFluentImpl<A extends X509SubjectFluent<A>>
extends BaseFluent<A>
implements X509SubjectFluent<A> {
    private List<String> countries;
    private List<String> localities;
    private List<String> organizationalUnits;
    private List<String> organizations;
    private List<String> postalCodes;
    private List<String> provinces;
    private String serialNumber;
    private List<String> streetAddresses;

    public X509SubjectFluentImpl() {
    }

    public X509SubjectFluentImpl(X509Subject instance) {
        this.withCountries(instance.getCountries());
        this.withLocalities(instance.getLocalities());
        this.withOrganizationalUnits(instance.getOrganizationalUnits());
        this.withOrganizations(instance.getOrganizations());
        this.withPostalCodes(instance.getPostalCodes());
        this.withProvinces(instance.getProvinces());
        this.withSerialNumber(instance.getSerialNumber());
        this.withStreetAddresses(instance.getStreetAddresses());
    }

    @Override
    public A addToCountries(Integer index, String item) {
        if (this.countries == null) {
            this.countries = new ArrayList<String>();
        }
        this.countries.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCountries(Integer index, String item) {
        if (this.countries == null) {
            this.countries = new ArrayList<String>();
        }
        this.countries.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCountries(String ... items) {
        if (this.countries == null) {
            this.countries = new ArrayList<String>();
        }
        for (String item : items) {
            this.countries.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCountries(Collection<String> items) {
        if (this.countries == null) {
            this.countries = new ArrayList<String>();
        }
        for (String item : items) {
            this.countries.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCountries(String ... items) {
        for (String item : items) {
            if (this.countries == null) continue;
            this.countries.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCountries(Collection<String> items) {
        for (String item : items) {
            if (this.countries == null) continue;
            this.countries.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCountries() {
        return this.countries;
    }

    @Override
    public String getCountry(Integer index) {
        return this.countries.get(index);
    }

    @Override
    public String getFirstCountry() {
        return this.countries.get(0);
    }

    @Override
    public String getLastCountry() {
        return this.countries.get(this.countries.size() - 1);
    }

    @Override
    public String getMatchingCountry(Predicate<String> predicate) {
        for (String item : this.countries) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCountry(Predicate<String> predicate) {
        for (String item : this.countries) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCountries(List<String> countries) {
        if (countries != null) {
            this.countries = new ArrayList<String>();
            for (String item : countries) {
                this.addToCountries(item);
            }
        } else {
            this.countries = null;
        }
        return (A)this;
    }

    @Override
    public A withCountries(String ... countries) {
        if (this.countries != null) {
            this.countries.clear();
        }
        if (countries != null) {
            for (String item : countries) {
                this.addToCountries(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCountries() {
        return this.countries != null && !this.countries.isEmpty();
    }

    @Override
    public A addNewCountry(String arg0) {
        return this.addToCountries(new String(arg0));
    }

    @Override
    public A addToLocalities(Integer index, String item) {
        if (this.localities == null) {
            this.localities = new ArrayList<String>();
        }
        this.localities.add(index, item);
        return (A)this;
    }

    @Override
    public A setToLocalities(Integer index, String item) {
        if (this.localities == null) {
            this.localities = new ArrayList<String>();
        }
        this.localities.set(index, item);
        return (A)this;
    }

    @Override
    public A addToLocalities(String ... items) {
        if (this.localities == null) {
            this.localities = new ArrayList<String>();
        }
        for (String item : items) {
            this.localities.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToLocalities(Collection<String> items) {
        if (this.localities == null) {
            this.localities = new ArrayList<String>();
        }
        for (String item : items) {
            this.localities.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromLocalities(String ... items) {
        for (String item : items) {
            if (this.localities == null) continue;
            this.localities.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromLocalities(Collection<String> items) {
        for (String item : items) {
            if (this.localities == null) continue;
            this.localities.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getLocalities() {
        return this.localities;
    }

    @Override
    public String getLocality(Integer index) {
        return this.localities.get(index);
    }

    @Override
    public String getFirstLocality() {
        return this.localities.get(0);
    }

    @Override
    public String getLastLocality() {
        return this.localities.get(this.localities.size() - 1);
    }

    @Override
    public String getMatchingLocality(Predicate<String> predicate) {
        for (String item : this.localities) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingLocality(Predicate<String> predicate) {
        for (String item : this.localities) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withLocalities(List<String> localities) {
        if (localities != null) {
            this.localities = new ArrayList<String>();
            for (String item : localities) {
                this.addToLocalities(item);
            }
        } else {
            this.localities = null;
        }
        return (A)this;
    }

    @Override
    public A withLocalities(String ... localities) {
        if (this.localities != null) {
            this.localities.clear();
        }
        if (localities != null) {
            for (String item : localities) {
                this.addToLocalities(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasLocalities() {
        return this.localities != null && !this.localities.isEmpty();
    }

    @Override
    public A addNewLocality(String arg0) {
        return this.addToLocalities(new String(arg0));
    }

    @Override
    public A addToOrganizationalUnits(Integer index, String item) {
        if (this.organizationalUnits == null) {
            this.organizationalUnits = new ArrayList<String>();
        }
        this.organizationalUnits.add(index, item);
        return (A)this;
    }

    @Override
    public A setToOrganizationalUnits(Integer index, String item) {
        if (this.organizationalUnits == null) {
            this.organizationalUnits = new ArrayList<String>();
        }
        this.organizationalUnits.set(index, item);
        return (A)this;
    }

    @Override
    public A addToOrganizationalUnits(String ... items) {
        if (this.organizationalUnits == null) {
            this.organizationalUnits = new ArrayList<String>();
        }
        for (String item : items) {
            this.organizationalUnits.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToOrganizationalUnits(Collection<String> items) {
        if (this.organizationalUnits == null) {
            this.organizationalUnits = new ArrayList<String>();
        }
        for (String item : items) {
            this.organizationalUnits.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromOrganizationalUnits(String ... items) {
        for (String item : items) {
            if (this.organizationalUnits == null) continue;
            this.organizationalUnits.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromOrganizationalUnits(Collection<String> items) {
        for (String item : items) {
            if (this.organizationalUnits == null) continue;
            this.organizationalUnits.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getOrganizationalUnits() {
        return this.organizationalUnits;
    }

    @Override
    public String getOrganizationalUnit(Integer index) {
        return this.organizationalUnits.get(index);
    }

    @Override
    public String getFirstOrganizationalUnit() {
        return this.organizationalUnits.get(0);
    }

    @Override
    public String getLastOrganizationalUnit() {
        return this.organizationalUnits.get(this.organizationalUnits.size() - 1);
    }

    @Override
    public String getMatchingOrganizationalUnit(Predicate<String> predicate) {
        for (String item : this.organizationalUnits) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingOrganizationalUnit(Predicate<String> predicate) {
        for (String item : this.organizationalUnits) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withOrganizationalUnits(List<String> organizationalUnits) {
        if (organizationalUnits != null) {
            this.organizationalUnits = new ArrayList<String>();
            for (String item : organizationalUnits) {
                this.addToOrganizationalUnits(item);
            }
        } else {
            this.organizationalUnits = null;
        }
        return (A)this;
    }

    @Override
    public A withOrganizationalUnits(String ... organizationalUnits) {
        if (this.organizationalUnits != null) {
            this.organizationalUnits.clear();
        }
        if (organizationalUnits != null) {
            for (String item : organizationalUnits) {
                this.addToOrganizationalUnits(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasOrganizationalUnits() {
        return this.organizationalUnits != null && !this.organizationalUnits.isEmpty();
    }

    @Override
    public A addNewOrganizationalUnit(String arg0) {
        return this.addToOrganizationalUnits(new String(arg0));
    }

    @Override
    public A addToOrganizations(Integer index, String item) {
        if (this.organizations == null) {
            this.organizations = new ArrayList<String>();
        }
        this.organizations.add(index, item);
        return (A)this;
    }

    @Override
    public A setToOrganizations(Integer index, String item) {
        if (this.organizations == null) {
            this.organizations = new ArrayList<String>();
        }
        this.organizations.set(index, item);
        return (A)this;
    }

    @Override
    public A addToOrganizations(String ... items) {
        if (this.organizations == null) {
            this.organizations = new ArrayList<String>();
        }
        for (String item : items) {
            this.organizations.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToOrganizations(Collection<String> items) {
        if (this.organizations == null) {
            this.organizations = new ArrayList<String>();
        }
        for (String item : items) {
            this.organizations.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromOrganizations(String ... items) {
        for (String item : items) {
            if (this.organizations == null) continue;
            this.organizations.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromOrganizations(Collection<String> items) {
        for (String item : items) {
            if (this.organizations == null) continue;
            this.organizations.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getOrganizations() {
        return this.organizations;
    }

    @Override
    public String getOrganization(Integer index) {
        return this.organizations.get(index);
    }

    @Override
    public String getFirstOrganization() {
        return this.organizations.get(0);
    }

    @Override
    public String getLastOrganization() {
        return this.organizations.get(this.organizations.size() - 1);
    }

    @Override
    public String getMatchingOrganization(Predicate<String> predicate) {
        for (String item : this.organizations) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingOrganization(Predicate<String> predicate) {
        for (String item : this.organizations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withOrganizations(List<String> organizations) {
        if (organizations != null) {
            this.organizations = new ArrayList<String>();
            for (String item : organizations) {
                this.addToOrganizations(item);
            }
        } else {
            this.organizations = null;
        }
        return (A)this;
    }

    @Override
    public A withOrganizations(String ... organizations) {
        if (this.organizations != null) {
            this.organizations.clear();
        }
        if (organizations != null) {
            for (String item : organizations) {
                this.addToOrganizations(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasOrganizations() {
        return this.organizations != null && !this.organizations.isEmpty();
    }

    @Override
    public A addNewOrganization(String arg0) {
        return this.addToOrganizations(new String(arg0));
    }

    @Override
    public A addToPostalCodes(Integer index, String item) {
        if (this.postalCodes == null) {
            this.postalCodes = new ArrayList<String>();
        }
        this.postalCodes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPostalCodes(Integer index, String item) {
        if (this.postalCodes == null) {
            this.postalCodes = new ArrayList<String>();
        }
        this.postalCodes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPostalCodes(String ... items) {
        if (this.postalCodes == null) {
            this.postalCodes = new ArrayList<String>();
        }
        for (String item : items) {
            this.postalCodes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPostalCodes(Collection<String> items) {
        if (this.postalCodes == null) {
            this.postalCodes = new ArrayList<String>();
        }
        for (String item : items) {
            this.postalCodes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPostalCodes(String ... items) {
        for (String item : items) {
            if (this.postalCodes == null) continue;
            this.postalCodes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPostalCodes(Collection<String> items) {
        for (String item : items) {
            if (this.postalCodes == null) continue;
            this.postalCodes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getPostalCodes() {
        return this.postalCodes;
    }

    @Override
    public String getPostalCode(Integer index) {
        return this.postalCodes.get(index);
    }

    @Override
    public String getFirstPostalCode() {
        return this.postalCodes.get(0);
    }

    @Override
    public String getLastPostalCode() {
        return this.postalCodes.get(this.postalCodes.size() - 1);
    }

    @Override
    public String getMatchingPostalCode(Predicate<String> predicate) {
        for (String item : this.postalCodes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPostalCode(Predicate<String> predicate) {
        for (String item : this.postalCodes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPostalCodes(List<String> postalCodes) {
        if (postalCodes != null) {
            this.postalCodes = new ArrayList<String>();
            for (String item : postalCodes) {
                this.addToPostalCodes(item);
            }
        } else {
            this.postalCodes = null;
        }
        return (A)this;
    }

    @Override
    public A withPostalCodes(String ... postalCodes) {
        if (this.postalCodes != null) {
            this.postalCodes.clear();
        }
        if (postalCodes != null) {
            for (String item : postalCodes) {
                this.addToPostalCodes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPostalCodes() {
        return this.postalCodes != null && !this.postalCodes.isEmpty();
    }

    @Override
    public A addNewPostalCode(String arg0) {
        return this.addToPostalCodes(new String(arg0));
    }

    @Override
    public A addToProvinces(Integer index, String item) {
        if (this.provinces == null) {
            this.provinces = new ArrayList<String>();
        }
        this.provinces.add(index, item);
        return (A)this;
    }

    @Override
    public A setToProvinces(Integer index, String item) {
        if (this.provinces == null) {
            this.provinces = new ArrayList<String>();
        }
        this.provinces.set(index, item);
        return (A)this;
    }

    @Override
    public A addToProvinces(String ... items) {
        if (this.provinces == null) {
            this.provinces = new ArrayList<String>();
        }
        for (String item : items) {
            this.provinces.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToProvinces(Collection<String> items) {
        if (this.provinces == null) {
            this.provinces = new ArrayList<String>();
        }
        for (String item : items) {
            this.provinces.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromProvinces(String ... items) {
        for (String item : items) {
            if (this.provinces == null) continue;
            this.provinces.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromProvinces(Collection<String> items) {
        for (String item : items) {
            if (this.provinces == null) continue;
            this.provinces.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getProvinces() {
        return this.provinces;
    }

    @Override
    public String getProvince(Integer index) {
        return this.provinces.get(index);
    }

    @Override
    public String getFirstProvince() {
        return this.provinces.get(0);
    }

    @Override
    public String getLastProvince() {
        return this.provinces.get(this.provinces.size() - 1);
    }

    @Override
    public String getMatchingProvince(Predicate<String> predicate) {
        for (String item : this.provinces) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingProvince(Predicate<String> predicate) {
        for (String item : this.provinces) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withProvinces(List<String> provinces) {
        if (provinces != null) {
            this.provinces = new ArrayList<String>();
            for (String item : provinces) {
                this.addToProvinces(item);
            }
        } else {
            this.provinces = null;
        }
        return (A)this;
    }

    @Override
    public A withProvinces(String ... provinces) {
        if (this.provinces != null) {
            this.provinces.clear();
        }
        if (provinces != null) {
            for (String item : provinces) {
                this.addToProvinces(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasProvinces() {
        return this.provinces != null && !this.provinces.isEmpty();
    }

    @Override
    public A addNewProvince(String arg0) {
        return this.addToProvinces(new String(arg0));
    }

    @Override
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public A withSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return (A)this;
    }

    @Override
    public Boolean hasSerialNumber() {
        return this.serialNumber != null;
    }

    @Override
    @Deprecated
    public A withNewSerialNumber(String arg0) {
        return this.withSerialNumber(new String(arg0));
    }

    @Override
    public A addToStreetAddresses(Integer index, String item) {
        if (this.streetAddresses == null) {
            this.streetAddresses = new ArrayList<String>();
        }
        this.streetAddresses.add(index, item);
        return (A)this;
    }

    @Override
    public A setToStreetAddresses(Integer index, String item) {
        if (this.streetAddresses == null) {
            this.streetAddresses = new ArrayList<String>();
        }
        this.streetAddresses.set(index, item);
        return (A)this;
    }

    @Override
    public A addToStreetAddresses(String ... items) {
        if (this.streetAddresses == null) {
            this.streetAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.streetAddresses.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToStreetAddresses(Collection<String> items) {
        if (this.streetAddresses == null) {
            this.streetAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.streetAddresses.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromStreetAddresses(String ... items) {
        for (String item : items) {
            if (this.streetAddresses == null) continue;
            this.streetAddresses.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromStreetAddresses(Collection<String> items) {
        for (String item : items) {
            if (this.streetAddresses == null) continue;
            this.streetAddresses.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getStreetAddresses() {
        return this.streetAddresses;
    }

    @Override
    public String getStreetAddress(Integer index) {
        return this.streetAddresses.get(index);
    }

    @Override
    public String getFirstStreetAddress() {
        return this.streetAddresses.get(0);
    }

    @Override
    public String getLastStreetAddress() {
        return this.streetAddresses.get(this.streetAddresses.size() - 1);
    }

    @Override
    public String getMatchingStreetAddress(Predicate<String> predicate) {
        for (String item : this.streetAddresses) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingStreetAddress(Predicate<String> predicate) {
        for (String item : this.streetAddresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withStreetAddresses(List<String> streetAddresses) {
        if (streetAddresses != null) {
            this.streetAddresses = new ArrayList<String>();
            for (String item : streetAddresses) {
                this.addToStreetAddresses(item);
            }
        } else {
            this.streetAddresses = null;
        }
        return (A)this;
    }

    @Override
    public A withStreetAddresses(String ... streetAddresses) {
        if (this.streetAddresses != null) {
            this.streetAddresses.clear();
        }
        if (streetAddresses != null) {
            for (String item : streetAddresses) {
                this.addToStreetAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasStreetAddresses() {
        return this.streetAddresses != null && !this.streetAddresses.isEmpty();
    }

    @Override
    public A addNewStreetAddress(String arg0) {
        return this.addToStreetAddresses(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        X509SubjectFluentImpl that = (X509SubjectFluentImpl)o;
        if (this.countries != null ? !this.countries.equals(that.countries) : that.countries != null) {
            return false;
        }
        if (this.localities != null ? !this.localities.equals(that.localities) : that.localities != null) {
            return false;
        }
        if (this.organizationalUnits != null ? !this.organizationalUnits.equals(that.organizationalUnits) : that.organizationalUnits != null) {
            return false;
        }
        if (this.organizations != null ? !this.organizations.equals(that.organizations) : that.organizations != null) {
            return false;
        }
        if (this.postalCodes != null ? !this.postalCodes.equals(that.postalCodes) : that.postalCodes != null) {
            return false;
        }
        if (this.provinces != null ? !this.provinces.equals(that.provinces) : that.provinces != null) {
            return false;
        }
        if (this.serialNumber != null ? !this.serialNumber.equals(that.serialNumber) : that.serialNumber != null) {
            return false;
        }
        return !(this.streetAddresses != null ? !this.streetAddresses.equals(that.streetAddresses) : that.streetAddresses != null);
    }

    public int hashCode() {
        return Objects.hash(this.countries, this.localities, this.organizationalUnits, this.organizations, this.postalCodes, this.provinces, this.serialNumber, this.streetAddresses, super.hashCode());
    }
}

