/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.certmanager.api.model.meta.v1.ObjectReference;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluent;
import io.fabric8.certmanager.api.model.v1alpha3.CertificateRequestSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class CertificateRequestSpecFluent<A extends CertificateRequestSpecFluent<A>>
extends BaseFluent<A> {
    private String csr;
    private Duration duration;
    private Map<String, List<String>> extra;
    private List<String> groups = new ArrayList<String>();
    private Boolean isCA;
    private ObjectReferenceBuilder issuerRef;
    private String uid;
    private List<String> usages = new ArrayList<String>();
    private String username;
    private Map<String, Object> additionalProperties;

    public CertificateRequestSpecFluent() {
    }

    public CertificateRequestSpecFluent(CertificateRequestSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CertificateRequestSpec instance) {
        CertificateRequestSpec certificateRequestSpec = instance = instance != null ? instance : new CertificateRequestSpec();
        if (instance != null) {
            this.withCsr(instance.getCsr());
            this.withDuration(instance.getDuration());
            this.withExtra(instance.getExtra());
            this.withGroups(instance.getGroups());
            this.withIsCA(instance.getIsCA());
            this.withIssuerRef(instance.getIssuerRef());
            this.withUid(instance.getUid());
            this.withUsages(instance.getUsages());
            this.withUsername(instance.getUsername());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getCsr() {
        return this.csr;
    }

    public A withCsr(String csr) {
        this.csr = csr;
        return (A)((Object)this);
    }

    public boolean hasCsr() {
        return this.csr != null;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public A withDuration(Duration duration) {
        this.duration = duration;
        return (A)((Object)this);
    }

    public boolean hasDuration() {
        return this.duration != null;
    }

    public A addToExtra(String key, List<String> value) {
        if (this.extra == null && key != null && value != null) {
            this.extra = new LinkedHashMap<String, List<String>>();
        }
        if (key != null && value != null) {
            this.extra.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToExtra(Map<String, List<String>> map) {
        if (this.extra == null && map != null) {
            this.extra = new LinkedHashMap<String, List<String>>();
        }
        if (map != null) {
            this.extra.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromExtra(String key) {
        if (this.extra == null) {
            return (A)((Object)this);
        }
        if (key != null && this.extra != null) {
            this.extra.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromExtra(Map<String, List<String>> map) {
        if (this.extra == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.extra == null) continue;
                this.extra.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, List<String>> getExtra() {
        return this.extra;
    }

    public <K, V> A withExtra(Map<String, List<String>> extra) {
        this.extra = extra == null ? null : new LinkedHashMap<String, List<String>>(extra);
        return (A)((Object)this);
    }

    public boolean hasExtra() {
        return this.extra != null;
    }

    public A addToGroups(int index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(index, item);
        return (A)((Object)this);
    }

    public A setToGroups(int index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.set(index, item);
        return (A)((Object)this);
    }

    public A addToGroups(String ... items) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToGroups(Collection<String> items) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromGroups(String ... items) {
        if (this.groups == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.groups.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromGroups(Collection<String> items) {
        if (this.groups == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.groups.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public String getGroup(int index) {
        return this.groups.get(index);
    }

    public String getFirstGroup() {
        return this.groups.get(0);
    }

    public String getLastGroup() {
        return this.groups.get(this.groups.size() - 1);
    }

    public String getMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withGroups(List<String> groups) {
        if (groups != null) {
            this.groups = new ArrayList<String>();
            for (String item : groups) {
                this.addToGroups(item);
            }
        } else {
            this.groups = null;
        }
        return (A)((Object)this);
    }

    public A withGroups(String ... groups) {
        if (this.groups != null) {
            this.groups.clear();
            this._visitables.remove((Object)"groups");
        }
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasGroups() {
        return this.groups != null && !this.groups.isEmpty();
    }

    public Boolean getIsCA() {
        return this.isCA;
    }

    public A withIsCA(Boolean isCA) {
        this.isCA = isCA;
        return (A)((Object)this);
    }

    public boolean hasIsCA() {
        return this.isCA != null;
    }

    public ObjectReference buildIssuerRef() {
        return this.issuerRef != null ? this.issuerRef.build() : null;
    }

    public A withIssuerRef(ObjectReference issuerRef) {
        this._visitables.remove((Object)"issuerRef");
        if (issuerRef != null) {
            this.issuerRef = new ObjectReferenceBuilder(issuerRef);
            this._visitables.get((Object)"issuerRef").add(this.issuerRef);
        } else {
            this.issuerRef = null;
            this._visitables.get((Object)"issuerRef").remove((Object)this.issuerRef);
        }
        return (A)((Object)this);
    }

    public boolean hasIssuerRef() {
        return this.issuerRef != null;
    }

    public A withNewIssuerRef(String group, String kind, String name) {
        return this.withIssuerRef(new ObjectReference(group, kind, name));
    }

    public IssuerRefNested<A> withNewIssuerRef() {
        return new IssuerRefNested(null);
    }

    public IssuerRefNested<A> withNewIssuerRefLike(ObjectReference item) {
        return new IssuerRefNested(item);
    }

    public IssuerRefNested<A> editIssuerRef() {
        return this.withNewIssuerRefLike(Optional.ofNullable(this.buildIssuerRef()).orElse(null));
    }

    public IssuerRefNested<A> editOrNewIssuerRef() {
        return this.withNewIssuerRefLike(Optional.ofNullable(this.buildIssuerRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public IssuerRefNested<A> editOrNewIssuerRefLike(ObjectReference item) {
        return this.withNewIssuerRefLike(Optional.ofNullable(this.buildIssuerRef()).orElse(item));
    }

    public String getUid() {
        return this.uid;
    }

    public A withUid(String uid) {
        this.uid = uid;
        return (A)((Object)this);
    }

    public boolean hasUid() {
        return this.uid != null;
    }

    public A addToUsages(int index, String item) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        this.usages.add(index, item);
        return (A)((Object)this);
    }

    public A setToUsages(int index, String item) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        this.usages.set(index, item);
        return (A)((Object)this);
    }

    public A addToUsages(String ... items) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        for (String item : items) {
            this.usages.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToUsages(Collection<String> items) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        for (String item : items) {
            this.usages.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromUsages(String ... items) {
        if (this.usages == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.usages.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromUsages(Collection<String> items) {
        if (this.usages == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.usages.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getUsages() {
        return this.usages;
    }

    public String getUsage(int index) {
        return this.usages.get(index);
    }

    public String getFirstUsage() {
        return this.usages.get(0);
    }

    public String getLastUsage() {
        return this.usages.get(this.usages.size() - 1);
    }

    public String getMatchingUsage(Predicate<String> predicate) {
        for (String item : this.usages) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingUsage(Predicate<String> predicate) {
        for (String item : this.usages) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withUsages(List<String> usages) {
        if (usages != null) {
            this.usages = new ArrayList<String>();
            for (String item : usages) {
                this.addToUsages(item);
            }
        } else {
            this.usages = null;
        }
        return (A)((Object)this);
    }

    public A withUsages(String ... usages) {
        if (this.usages != null) {
            this.usages.clear();
            this._visitables.remove((Object)"usages");
        }
        if (usages != null) {
            for (String item : usages) {
                this.addToUsages(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasUsages() {
        return this.usages != null && !this.usages.isEmpty();
    }

    public String getUsername() {
        return this.username;
    }

    public A withUsername(String username) {
        this.username = username;
        return (A)((Object)this);
    }

    public boolean hasUsername() {
        return this.username != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CertificateRequestSpecFluent that = (CertificateRequestSpecFluent)((Object)o);
        if (!Objects.equals(this.csr, that.csr)) {
            return false;
        }
        if (!Objects.equals(this.duration, that.duration)) {
            return false;
        }
        if (!Objects.equals(this.extra, that.extra)) {
            return false;
        }
        if (!Objects.equals(this.groups, that.groups)) {
            return false;
        }
        if (!Objects.equals(this.isCA, that.isCA)) {
            return false;
        }
        if (!Objects.equals((Object)this.issuerRef, (Object)that.issuerRef)) {
            return false;
        }
        if (!Objects.equals(this.uid, that.uid)) {
            return false;
        }
        if (!Objects.equals(this.usages, that.usages)) {
            return false;
        }
        if (!Objects.equals(this.username, that.username)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.csr, this.duration, this.extra, this.groups, this.isCA, this.issuerRef, this.uid, this.usages, this.username, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.csr != null) {
            sb.append("csr:");
            sb.append(this.csr + ",");
        }
        if (this.duration != null) {
            sb.append("duration:");
            sb.append(this.duration + ",");
        }
        if (this.extra != null && !this.extra.isEmpty()) {
            sb.append("extra:");
            sb.append(this.extra + ",");
        }
        if (this.groups != null && !this.groups.isEmpty()) {
            sb.append("groups:");
            sb.append(this.groups + ",");
        }
        if (this.isCA != null) {
            sb.append("isCA:");
            sb.append(this.isCA + ",");
        }
        if (this.issuerRef != null) {
            sb.append("issuerRef:");
            sb.append((Object)((Object)this.issuerRef) + ",");
        }
        if (this.uid != null) {
            sb.append("uid:");
            sb.append(this.uid + ",");
        }
        if (this.usages != null && !this.usages.isEmpty()) {
            sb.append("usages:");
            sb.append(this.usages + ",");
        }
        if (this.username != null) {
            sb.append("username:");
            sb.append(this.username + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withIsCA() {
        return this.withIsCA(true);
    }

    public class IssuerRefNested<N>
    extends ObjectReferenceFluent<IssuerRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        IssuerRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        public N and() {
            return (N)CertificateRequestSpecFluent.this.withIssuerRef(this.builder.build());
        }

        public N endIssuerRef() {
            return this.and();
        }
    }
}

