/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.certmanager.api.model.v1alpha3.X509Subject;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class X509SubjectFluent<A extends X509SubjectFluent<A>>
extends BaseFluent<A> {
    private List<String> countries = new ArrayList<String>();
    private List<String> localities = new ArrayList<String>();
    private List<String> organizationalUnits = new ArrayList<String>();
    private List<String> organizations = new ArrayList<String>();
    private List<String> postalCodes = new ArrayList<String>();
    private List<String> provinces = new ArrayList<String>();
    private String serialNumber;
    private List<String> streetAddresses = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public X509SubjectFluent() {
    }

    public X509SubjectFluent(X509Subject instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(X509Subject instance) {
        X509Subject x509Subject = instance = instance != null ? instance : new X509Subject();
        if (instance != null) {
            this.withCountries(instance.getCountries());
            this.withLocalities(instance.getLocalities());
            this.withOrganizationalUnits(instance.getOrganizationalUnits());
            this.withOrganizations(instance.getOrganizations());
            this.withPostalCodes(instance.getPostalCodes());
            this.withProvinces(instance.getProvinces());
            this.withSerialNumber(instance.getSerialNumber());
            this.withStreetAddresses(instance.getStreetAddresses());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToCountries(int index, String item) {
        if (this.countries == null) {
            this.countries = new ArrayList<String>();
        }
        this.countries.add(index, item);
        return (A)((Object)this);
    }

    public A setToCountries(int index, String item) {
        if (this.countries == null) {
            this.countries = new ArrayList<String>();
        }
        this.countries.set(index, item);
        return (A)((Object)this);
    }

    public A addToCountries(String ... items) {
        if (this.countries == null) {
            this.countries = new ArrayList<String>();
        }
        for (String item : items) {
            this.countries.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToCountries(Collection<String> items) {
        if (this.countries == null) {
            this.countries = new ArrayList<String>();
        }
        for (String item : items) {
            this.countries.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromCountries(String ... items) {
        if (this.countries == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.countries.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCountries(Collection<String> items) {
        if (this.countries == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.countries.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getCountries() {
        return this.countries;
    }

    public String getCountry(int index) {
        return this.countries.get(index);
    }

    public String getFirstCountry() {
        return this.countries.get(0);
    }

    public String getLastCountry() {
        return this.countries.get(this.countries.size() - 1);
    }

    public String getMatchingCountry(Predicate<String> predicate) {
        for (String item : this.countries) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCountry(Predicate<String> predicate) {
        for (String item : this.countries) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCountries(List<String> countries) {
        if (countries != null) {
            this.countries = new ArrayList<String>();
            for (String item : countries) {
                this.addToCountries(item);
            }
        } else {
            this.countries = null;
        }
        return (A)((Object)this);
    }

    public A withCountries(String ... countries) {
        if (this.countries != null) {
            this.countries.clear();
            this._visitables.remove((Object)"countries");
        }
        if (countries != null) {
            for (String item : countries) {
                this.addToCountries(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasCountries() {
        return this.countries != null && !this.countries.isEmpty();
    }

    public A addToLocalities(int index, String item) {
        if (this.localities == null) {
            this.localities = new ArrayList<String>();
        }
        this.localities.add(index, item);
        return (A)((Object)this);
    }

    public A setToLocalities(int index, String item) {
        if (this.localities == null) {
            this.localities = new ArrayList<String>();
        }
        this.localities.set(index, item);
        return (A)((Object)this);
    }

    public A addToLocalities(String ... items) {
        if (this.localities == null) {
            this.localities = new ArrayList<String>();
        }
        for (String item : items) {
            this.localities.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToLocalities(Collection<String> items) {
        if (this.localities == null) {
            this.localities = new ArrayList<String>();
        }
        for (String item : items) {
            this.localities.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromLocalities(String ... items) {
        if (this.localities == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.localities.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromLocalities(Collection<String> items) {
        if (this.localities == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.localities.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getLocalities() {
        return this.localities;
    }

    public String getLocality(int index) {
        return this.localities.get(index);
    }

    public String getFirstLocality() {
        return this.localities.get(0);
    }

    public String getLastLocality() {
        return this.localities.get(this.localities.size() - 1);
    }

    public String getMatchingLocality(Predicate<String> predicate) {
        for (String item : this.localities) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingLocality(Predicate<String> predicate) {
        for (String item : this.localities) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withLocalities(List<String> localities) {
        if (localities != null) {
            this.localities = new ArrayList<String>();
            for (String item : localities) {
                this.addToLocalities(item);
            }
        } else {
            this.localities = null;
        }
        return (A)((Object)this);
    }

    public A withLocalities(String ... localities) {
        if (this.localities != null) {
            this.localities.clear();
            this._visitables.remove((Object)"localities");
        }
        if (localities != null) {
            for (String item : localities) {
                this.addToLocalities(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasLocalities() {
        return this.localities != null && !this.localities.isEmpty();
    }

    public A addToOrganizationalUnits(int index, String item) {
        if (this.organizationalUnits == null) {
            this.organizationalUnits = new ArrayList<String>();
        }
        this.organizationalUnits.add(index, item);
        return (A)((Object)this);
    }

    public A setToOrganizationalUnits(int index, String item) {
        if (this.organizationalUnits == null) {
            this.organizationalUnits = new ArrayList<String>();
        }
        this.organizationalUnits.set(index, item);
        return (A)((Object)this);
    }

    public A addToOrganizationalUnits(String ... items) {
        if (this.organizationalUnits == null) {
            this.organizationalUnits = new ArrayList<String>();
        }
        for (String item : items) {
            this.organizationalUnits.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToOrganizationalUnits(Collection<String> items) {
        if (this.organizationalUnits == null) {
            this.organizationalUnits = new ArrayList<String>();
        }
        for (String item : items) {
            this.organizationalUnits.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromOrganizationalUnits(String ... items) {
        if (this.organizationalUnits == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.organizationalUnits.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromOrganizationalUnits(Collection<String> items) {
        if (this.organizationalUnits == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.organizationalUnits.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getOrganizationalUnits() {
        return this.organizationalUnits;
    }

    public String getOrganizationalUnit(int index) {
        return this.organizationalUnits.get(index);
    }

    public String getFirstOrganizationalUnit() {
        return this.organizationalUnits.get(0);
    }

    public String getLastOrganizationalUnit() {
        return this.organizationalUnits.get(this.organizationalUnits.size() - 1);
    }

    public String getMatchingOrganizationalUnit(Predicate<String> predicate) {
        for (String item : this.organizationalUnits) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingOrganizationalUnit(Predicate<String> predicate) {
        for (String item : this.organizationalUnits) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withOrganizationalUnits(List<String> organizationalUnits) {
        if (organizationalUnits != null) {
            this.organizationalUnits = new ArrayList<String>();
            for (String item : organizationalUnits) {
                this.addToOrganizationalUnits(item);
            }
        } else {
            this.organizationalUnits = null;
        }
        return (A)((Object)this);
    }

    public A withOrganizationalUnits(String ... organizationalUnits) {
        if (this.organizationalUnits != null) {
            this.organizationalUnits.clear();
            this._visitables.remove((Object)"organizationalUnits");
        }
        if (organizationalUnits != null) {
            for (String item : organizationalUnits) {
                this.addToOrganizationalUnits(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasOrganizationalUnits() {
        return this.organizationalUnits != null && !this.organizationalUnits.isEmpty();
    }

    public A addToOrganizations(int index, String item) {
        if (this.organizations == null) {
            this.organizations = new ArrayList<String>();
        }
        this.organizations.add(index, item);
        return (A)((Object)this);
    }

    public A setToOrganizations(int index, String item) {
        if (this.organizations == null) {
            this.organizations = new ArrayList<String>();
        }
        this.organizations.set(index, item);
        return (A)((Object)this);
    }

    public A addToOrganizations(String ... items) {
        if (this.organizations == null) {
            this.organizations = new ArrayList<String>();
        }
        for (String item : items) {
            this.organizations.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToOrganizations(Collection<String> items) {
        if (this.organizations == null) {
            this.organizations = new ArrayList<String>();
        }
        for (String item : items) {
            this.organizations.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromOrganizations(String ... items) {
        if (this.organizations == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.organizations.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromOrganizations(Collection<String> items) {
        if (this.organizations == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.organizations.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getOrganizations() {
        return this.organizations;
    }

    public String getOrganization(int index) {
        return this.organizations.get(index);
    }

    public String getFirstOrganization() {
        return this.organizations.get(0);
    }

    public String getLastOrganization() {
        return this.organizations.get(this.organizations.size() - 1);
    }

    public String getMatchingOrganization(Predicate<String> predicate) {
        for (String item : this.organizations) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingOrganization(Predicate<String> predicate) {
        for (String item : this.organizations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withOrganizations(List<String> organizations) {
        if (organizations != null) {
            this.organizations = new ArrayList<String>();
            for (String item : organizations) {
                this.addToOrganizations(item);
            }
        } else {
            this.organizations = null;
        }
        return (A)((Object)this);
    }

    public A withOrganizations(String ... organizations) {
        if (this.organizations != null) {
            this.organizations.clear();
            this._visitables.remove((Object)"organizations");
        }
        if (organizations != null) {
            for (String item : organizations) {
                this.addToOrganizations(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasOrganizations() {
        return this.organizations != null && !this.organizations.isEmpty();
    }

    public A addToPostalCodes(int index, String item) {
        if (this.postalCodes == null) {
            this.postalCodes = new ArrayList<String>();
        }
        this.postalCodes.add(index, item);
        return (A)((Object)this);
    }

    public A setToPostalCodes(int index, String item) {
        if (this.postalCodes == null) {
            this.postalCodes = new ArrayList<String>();
        }
        this.postalCodes.set(index, item);
        return (A)((Object)this);
    }

    public A addToPostalCodes(String ... items) {
        if (this.postalCodes == null) {
            this.postalCodes = new ArrayList<String>();
        }
        for (String item : items) {
            this.postalCodes.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToPostalCodes(Collection<String> items) {
        if (this.postalCodes == null) {
            this.postalCodes = new ArrayList<String>();
        }
        for (String item : items) {
            this.postalCodes.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromPostalCodes(String ... items) {
        if (this.postalCodes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.postalCodes.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPostalCodes(Collection<String> items) {
        if (this.postalCodes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.postalCodes.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getPostalCodes() {
        return this.postalCodes;
    }

    public String getPostalCode(int index) {
        return this.postalCodes.get(index);
    }

    public String getFirstPostalCode() {
        return this.postalCodes.get(0);
    }

    public String getLastPostalCode() {
        return this.postalCodes.get(this.postalCodes.size() - 1);
    }

    public String getMatchingPostalCode(Predicate<String> predicate) {
        for (String item : this.postalCodes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPostalCode(Predicate<String> predicate) {
        for (String item : this.postalCodes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPostalCodes(List<String> postalCodes) {
        if (postalCodes != null) {
            this.postalCodes = new ArrayList<String>();
            for (String item : postalCodes) {
                this.addToPostalCodes(item);
            }
        } else {
            this.postalCodes = null;
        }
        return (A)((Object)this);
    }

    public A withPostalCodes(String ... postalCodes) {
        if (this.postalCodes != null) {
            this.postalCodes.clear();
            this._visitables.remove((Object)"postalCodes");
        }
        if (postalCodes != null) {
            for (String item : postalCodes) {
                this.addToPostalCodes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPostalCodes() {
        return this.postalCodes != null && !this.postalCodes.isEmpty();
    }

    public A addToProvinces(int index, String item) {
        if (this.provinces == null) {
            this.provinces = new ArrayList<String>();
        }
        this.provinces.add(index, item);
        return (A)((Object)this);
    }

    public A setToProvinces(int index, String item) {
        if (this.provinces == null) {
            this.provinces = new ArrayList<String>();
        }
        this.provinces.set(index, item);
        return (A)((Object)this);
    }

    public A addToProvinces(String ... items) {
        if (this.provinces == null) {
            this.provinces = new ArrayList<String>();
        }
        for (String item : items) {
            this.provinces.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToProvinces(Collection<String> items) {
        if (this.provinces == null) {
            this.provinces = new ArrayList<String>();
        }
        for (String item : items) {
            this.provinces.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromProvinces(String ... items) {
        if (this.provinces == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.provinces.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromProvinces(Collection<String> items) {
        if (this.provinces == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.provinces.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getProvinces() {
        return this.provinces;
    }

    public String getProvince(int index) {
        return this.provinces.get(index);
    }

    public String getFirstProvince() {
        return this.provinces.get(0);
    }

    public String getLastProvince() {
        return this.provinces.get(this.provinces.size() - 1);
    }

    public String getMatchingProvince(Predicate<String> predicate) {
        for (String item : this.provinces) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingProvince(Predicate<String> predicate) {
        for (String item : this.provinces) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withProvinces(List<String> provinces) {
        if (provinces != null) {
            this.provinces = new ArrayList<String>();
            for (String item : provinces) {
                this.addToProvinces(item);
            }
        } else {
            this.provinces = null;
        }
        return (A)((Object)this);
    }

    public A withProvinces(String ... provinces) {
        if (this.provinces != null) {
            this.provinces.clear();
            this._visitables.remove((Object)"provinces");
        }
        if (provinces != null) {
            for (String item : provinces) {
                this.addToProvinces(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasProvinces() {
        return this.provinces != null && !this.provinces.isEmpty();
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public A withSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return (A)((Object)this);
    }

    public boolean hasSerialNumber() {
        return this.serialNumber != null;
    }

    public A addToStreetAddresses(int index, String item) {
        if (this.streetAddresses == null) {
            this.streetAddresses = new ArrayList<String>();
        }
        this.streetAddresses.add(index, item);
        return (A)((Object)this);
    }

    public A setToStreetAddresses(int index, String item) {
        if (this.streetAddresses == null) {
            this.streetAddresses = new ArrayList<String>();
        }
        this.streetAddresses.set(index, item);
        return (A)((Object)this);
    }

    public A addToStreetAddresses(String ... items) {
        if (this.streetAddresses == null) {
            this.streetAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.streetAddresses.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToStreetAddresses(Collection<String> items) {
        if (this.streetAddresses == null) {
            this.streetAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.streetAddresses.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromStreetAddresses(String ... items) {
        if (this.streetAddresses == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.streetAddresses.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromStreetAddresses(Collection<String> items) {
        if (this.streetAddresses == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.streetAddresses.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getStreetAddresses() {
        return this.streetAddresses;
    }

    public String getStreetAddress(int index) {
        return this.streetAddresses.get(index);
    }

    public String getFirstStreetAddress() {
        return this.streetAddresses.get(0);
    }

    public String getLastStreetAddress() {
        return this.streetAddresses.get(this.streetAddresses.size() - 1);
    }

    public String getMatchingStreetAddress(Predicate<String> predicate) {
        for (String item : this.streetAddresses) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingStreetAddress(Predicate<String> predicate) {
        for (String item : this.streetAddresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withStreetAddresses(List<String> streetAddresses) {
        if (streetAddresses != null) {
            this.streetAddresses = new ArrayList<String>();
            for (String item : streetAddresses) {
                this.addToStreetAddresses(item);
            }
        } else {
            this.streetAddresses = null;
        }
        return (A)((Object)this);
    }

    public A withStreetAddresses(String ... streetAddresses) {
        if (this.streetAddresses != null) {
            this.streetAddresses.clear();
            this._visitables.remove((Object)"streetAddresses");
        }
        if (streetAddresses != null) {
            for (String item : streetAddresses) {
                this.addToStreetAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasStreetAddresses() {
        return this.streetAddresses != null && !this.streetAddresses.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        X509SubjectFluent that = (X509SubjectFluent)((Object)o);
        if (!Objects.equals(this.countries, that.countries)) {
            return false;
        }
        if (!Objects.equals(this.localities, that.localities)) {
            return false;
        }
        if (!Objects.equals(this.organizationalUnits, that.organizationalUnits)) {
            return false;
        }
        if (!Objects.equals(this.organizations, that.organizations)) {
            return false;
        }
        if (!Objects.equals(this.postalCodes, that.postalCodes)) {
            return false;
        }
        if (!Objects.equals(this.provinces, that.provinces)) {
            return false;
        }
        if (!Objects.equals(this.serialNumber, that.serialNumber)) {
            return false;
        }
        if (!Objects.equals(this.streetAddresses, that.streetAddresses)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.countries, this.localities, this.organizationalUnits, this.organizations, this.postalCodes, this.provinces, this.serialNumber, this.streetAddresses, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.countries != null && !this.countries.isEmpty()) {
            sb.append("countries:");
            sb.append(this.countries + ",");
        }
        if (this.localities != null && !this.localities.isEmpty()) {
            sb.append("localities:");
            sb.append(this.localities + ",");
        }
        if (this.organizationalUnits != null && !this.organizationalUnits.isEmpty()) {
            sb.append("organizationalUnits:");
            sb.append(this.organizationalUnits + ",");
        }
        if (this.organizations != null && !this.organizations.isEmpty()) {
            sb.append("organizations:");
            sb.append(this.organizations + ",");
        }
        if (this.postalCodes != null && !this.postalCodes.isEmpty()) {
            sb.append("postalCodes:");
            sb.append(this.postalCodes + ",");
        }
        if (this.provinces != null && !this.provinces.isEmpty()) {
            sb.append("provinces:");
            sb.append(this.provinces + ",");
        }
        if (this.serialNumber != null) {
            sb.append("serialNumber:");
            sb.append(this.serialNumber + ",");
        }
        if (this.streetAddresses != null && !this.streetAddresses.isEmpty()) {
            sb.append("streetAddresses:");
            sb.append(this.streetAddresses + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

