package io.fabric8.certmanager.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertmanagerSchemaBuilder extends CertmanagerSchemaFluentImpl<CertmanagerSchemaBuilder> implements VisitableBuilder<CertmanagerSchema,CertmanagerSchemaBuilder>{
  public CertmanagerSchemaBuilder() {
    this(false);
  }
  public CertmanagerSchemaBuilder(Boolean validationEnabled) {
    this(new CertmanagerSchema(), validationEnabled);
  }
  public CertmanagerSchemaBuilder(CertmanagerSchemaFluent<?> fluent) {
    this(fluent, false);
  }
  public CertmanagerSchemaBuilder(CertmanagerSchemaFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CertmanagerSchema(), validationEnabled);
  }
  public CertmanagerSchemaBuilder(CertmanagerSchemaFluent<?> fluent,CertmanagerSchema instance) {
    this(fluent, instance, false);
  }
  public CertmanagerSchemaBuilder(CertmanagerSchemaFluent<?> fluent,CertmanagerSchema instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEAuthorization(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEAuthorization());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallenge(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallenge());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolver(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolver());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverDNS01(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverDNS01());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01GatewayHTTPRoute(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01GatewayHTTPRoute());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01Ingress(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01Ingress());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressObjectMeta(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressObjectMeta());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodObjectMeta(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodObjectMeta());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodSpec(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodSpec());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodTemplate(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodTemplate());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressTemplate(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressTemplate());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEExternalAccountBinding(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEExternalAccountBinding());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuer(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuer());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAcmeDNS(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAcmeDNS());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAkamai(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAkamai());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAzureDNS(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAzureDNS());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderCloudDNS(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderCloudDNS());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderCloudflare(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderCloudflare());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderDigitalOcean(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderDigitalOcean());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderRFC2136(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderRFC2136());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderRoute53(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderRoute53());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderWebhook(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderWebhook());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerStatus(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerStatus());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3AzureManagedIdentity(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3AzureManagedIdentity());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3CertificateDNSNameSelector(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3CertificateDNSNameSelector());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3Challenge(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3Challenge());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeList(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeList());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeSpec(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeSpec());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeStatus(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeStatus());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3Order(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3Order());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderList(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderList());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderSpec(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderSpec());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderStatus(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderStatus());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CAIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CAIssuer());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3Certificate(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3Certificate());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateCondition(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateCondition());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateKeystores(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateKeystores());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateList());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificatePrivateKey(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificatePrivateKey());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequest(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequest());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestCondition(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestCondition());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestList());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestSpec(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestSpec());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestStatus(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestStatus());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateSecretTemplate(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateSecretTemplate());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateSpec(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateSpec());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateStatus(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateStatus());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3ClusterIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3ClusterIssuer());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3ClusterIssuerList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3ClusterIssuerList());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3Issuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3Issuer());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerCondition(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerCondition());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerList());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerSpec(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerSpec());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerStatus(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerStatus());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3JKSKeystore(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3JKSKeystore());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3PKCS12Keystore(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3PKCS12Keystore());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3SelfSignedIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3SelfSignedIssuer());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultAppRole(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultAppRole());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultAuth(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultAuth());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultIssuer());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultKubernetesAuth(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultKubernetesAuth());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiCloud(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiCloud());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiIssuer());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiTPP(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiTPP());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3X509Subject(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3X509Subject());
      fluent.withGithubComJetstackCertManagerPkgApisMetaV1LocalObjectReference(instance.getGithubComJetstackCertManagerPkgApisMetaV1LocalObjectReference());
      fluent.withGithubComJetstackCertManagerPkgApisMetaV1ObjectReference(instance.getGithubComJetstackCertManagerPkgApisMetaV1ObjectReference());
      fluent.withGithubComJetstackCertManagerPkgApisMetaV1SecretKeySelector(instance.getGithubComJetstackCertManagerPkgApisMetaV1SecretKeySelector());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CertmanagerSchemaBuilder(CertmanagerSchema instance) {
    this(instance,false);
  }
  public CertmanagerSchemaBuilder(CertmanagerSchema instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEAuthorization(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEAuthorization());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallenge(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallenge());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolver(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolver());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverDNS01(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverDNS01());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01GatewayHTTPRoute(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01GatewayHTTPRoute());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01Ingress(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01Ingress());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressObjectMeta(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressObjectMeta());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodObjectMeta(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodObjectMeta());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodSpec(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodSpec());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodTemplate(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodTemplate());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressTemplate(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressTemplate());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEExternalAccountBinding(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEExternalAccountBinding());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuer(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuer());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAcmeDNS(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAcmeDNS());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAkamai(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAkamai());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAzureDNS(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAzureDNS());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderCloudDNS(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderCloudDNS());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderCloudflare(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderCloudflare());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderDigitalOcean(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderDigitalOcean());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderRFC2136(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderRFC2136());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderRoute53(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderRoute53());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderWebhook(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderWebhook());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerStatus(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerStatus());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3AzureManagedIdentity(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3AzureManagedIdentity());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3CertificateDNSNameSelector(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3CertificateDNSNameSelector());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3Challenge(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3Challenge());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeList(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeList());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeSpec(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeSpec());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeStatus(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeStatus());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3Order(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3Order());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderList(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderList());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderSpec(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderSpec());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderStatus(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderStatus());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CAIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CAIssuer());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3Certificate(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3Certificate());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateCondition(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateCondition());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateKeystores(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateKeystores());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateList());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificatePrivateKey(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificatePrivateKey());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequest(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequest());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestCondition(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestCondition());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestList());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestSpec(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestSpec());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestStatus(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestStatus());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateSecretTemplate(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateSecretTemplate());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateSpec(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateSpec());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateStatus(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateStatus());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3ClusterIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3ClusterIssuer());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3ClusterIssuerList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3ClusterIssuerList());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3Issuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3Issuer());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerCondition(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerCondition());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerList());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerSpec(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerSpec());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerStatus(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerStatus());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3JKSKeystore(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3JKSKeystore());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3PKCS12Keystore(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3PKCS12Keystore());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3SelfSignedIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3SelfSignedIssuer());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultAppRole(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultAppRole());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultAuth(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultAuth());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultIssuer());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultKubernetesAuth(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultKubernetesAuth());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiCloud(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiCloud());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiIssuer());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiTPP(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiTPP());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3X509Subject(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3X509Subject());
      this.withGithubComJetstackCertManagerPkgApisMetaV1LocalObjectReference(instance.getGithubComJetstackCertManagerPkgApisMetaV1LocalObjectReference());
      this.withGithubComJetstackCertManagerPkgApisMetaV1ObjectReference(instance.getGithubComJetstackCertManagerPkgApisMetaV1ObjectReference());
      this.withGithubComJetstackCertManagerPkgApisMetaV1SecretKeySelector(instance.getGithubComJetstackCertManagerPkgApisMetaV1SecretKeySelector());
    }
    this.validationEnabled = validationEnabled; 
  }
  CertmanagerSchemaFluent<?> fluent;
  Boolean validationEnabled;
  public CertmanagerSchema build() {
    CertmanagerSchema buildable = new CertmanagerSchema(fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEAuthorization(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallenge(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolver(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverDNS01(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01GatewayHTTPRoute(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01Ingress(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressObjectMeta(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodObjectMeta(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodSpec(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodTemplate(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressTemplate(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEExternalAccountBinding(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuer(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAcmeDNS(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAkamai(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAzureDNS(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderCloudDNS(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderCloudflare(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderDigitalOcean(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderRFC2136(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderRoute53(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderWebhook(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerStatus(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3AzureManagedIdentity(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3CertificateDNSNameSelector(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3Challenge(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeList(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeSpec(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeStatus(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3Order(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderList(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderSpec(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderStatus(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CAIssuer(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3Certificate(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateCondition(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateKeystores(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateList(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificatePrivateKey(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequest(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestCondition(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestList(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestSpec(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestStatus(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateSecretTemplate(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateSpec(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateStatus(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3ClusterIssuer(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3ClusterIssuerList(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3Issuer(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerCondition(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerList(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerSpec(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerStatus(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3JKSKeystore(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3PKCS12Keystore(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3SelfSignedIssuer(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultAppRole(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultAuth(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultIssuer(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultKubernetesAuth(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiCloud(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiIssuer(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiTPP(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3X509Subject(),fluent.getGithubComJetstackCertManagerPkgApisMetaV1LocalObjectReference(),fluent.getGithubComJetstackCertManagerPkgApisMetaV1ObjectReference(),fluent.getGithubComJetstackCertManagerPkgApisMetaV1SecretKeySelector());
    return buildable;
  }
  
}