package io.fabric8.certmanager.api.model.acme.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ACMEAuthorizationBuilder extends ACMEAuthorizationFluentImpl<ACMEAuthorizationBuilder> implements VisitableBuilder<ACMEAuthorization,ACMEAuthorizationBuilder>{
  public ACMEAuthorizationBuilder() {
    this(false);
  }
  public ACMEAuthorizationBuilder(Boolean validationEnabled) {
    this(new ACMEAuthorization(), validationEnabled);
  }
  public ACMEAuthorizationBuilder(ACMEAuthorizationFluent<?> fluent) {
    this(fluent, false);
  }
  public ACMEAuthorizationBuilder(ACMEAuthorizationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ACMEAuthorization(), validationEnabled);
  }
  public ACMEAuthorizationBuilder(ACMEAuthorizationFluent<?> fluent,ACMEAuthorization instance) {
    this(fluent, instance, false);
  }
  public ACMEAuthorizationBuilder(ACMEAuthorizationFluent<?> fluent,ACMEAuthorization instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withChallenges(instance.getChallenges());
      fluent.withIdentifier(instance.getIdentifier());
      fluent.withInitialState(instance.getInitialState());
      fluent.withUrl(instance.getUrl());
      fluent.withWildcard(instance.getWildcard());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ACMEAuthorizationBuilder(ACMEAuthorization instance) {
    this(instance,false);
  }
  public ACMEAuthorizationBuilder(ACMEAuthorization instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withChallenges(instance.getChallenges());
      this.withIdentifier(instance.getIdentifier());
      this.withInitialState(instance.getInitialState());
      this.withUrl(instance.getUrl());
      this.withWildcard(instance.getWildcard());
    }
    this.validationEnabled = validationEnabled; 
  }
  ACMEAuthorizationFluent<?> fluent;
  Boolean validationEnabled;
  public ACMEAuthorization build() {
    ACMEAuthorization buildable = new ACMEAuthorization(fluent.getChallenges(),fluent.getIdentifier(),fluent.getInitialState(),fluent.getUrl(),fluent.getWildcard());
    return buildable;
  }
  
}