package io.fabric8.certmanager.api.model.acme.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ACMEChallengeSolverHTTP01Builder extends ACMEChallengeSolverHTTP01FluentImpl<ACMEChallengeSolverHTTP01Builder> implements VisitableBuilder<ACMEChallengeSolverHTTP01,ACMEChallengeSolverHTTP01Builder>{
  public ACMEChallengeSolverHTTP01Builder() {
    this(false);
  }
  public ACMEChallengeSolverHTTP01Builder(Boolean validationEnabled) {
    this(new ACMEChallengeSolverHTTP01(), validationEnabled);
  }
  public ACMEChallengeSolverHTTP01Builder(ACMEChallengeSolverHTTP01Fluent<?> fluent) {
    this(fluent, false);
  }
  public ACMEChallengeSolverHTTP01Builder(ACMEChallengeSolverHTTP01Fluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ACMEChallengeSolverHTTP01(), validationEnabled);
  }
  public ACMEChallengeSolverHTTP01Builder(ACMEChallengeSolverHTTP01Fluent<?> fluent,ACMEChallengeSolverHTTP01 instance) {
    this(fluent, instance, false);
  }
  public ACMEChallengeSolverHTTP01Builder(ACMEChallengeSolverHTTP01Fluent<?> fluent,ACMEChallengeSolverHTTP01 instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withGatewayHTTPRoute(instance.getGatewayHTTPRoute());
      fluent.withIngress(instance.getIngress());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ACMEChallengeSolverHTTP01Builder(ACMEChallengeSolverHTTP01 instance) {
    this(instance,false);
  }
  public ACMEChallengeSolverHTTP01Builder(ACMEChallengeSolverHTTP01 instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withGatewayHTTPRoute(instance.getGatewayHTTPRoute());
      this.withIngress(instance.getIngress());
    }
    this.validationEnabled = validationEnabled; 
  }
  ACMEChallengeSolverHTTP01Fluent<?> fluent;
  Boolean validationEnabled;
  public ACMEChallengeSolverHTTP01 build() {
    ACMEChallengeSolverHTTP01 buildable = new ACMEChallengeSolverHTTP01(fluent.getGatewayHTTPRoute(),fluent.getIngress());
    return buildable;
  }
  
}