package io.fabric8.certmanager.api.model.acme.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ChallengeStatusBuilder extends ChallengeStatusFluentImpl<ChallengeStatusBuilder> implements VisitableBuilder<ChallengeStatus,ChallengeStatusBuilder>{
  public ChallengeStatusBuilder() {
    this(false);
  }
  public ChallengeStatusBuilder(Boolean validationEnabled) {
    this(new ChallengeStatus(), validationEnabled);
  }
  public ChallengeStatusBuilder(ChallengeStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ChallengeStatusBuilder(ChallengeStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ChallengeStatus(), validationEnabled);
  }
  public ChallengeStatusBuilder(ChallengeStatusFluent<?> fluent,ChallengeStatus instance) {
    this(fluent, instance, false);
  }
  public ChallengeStatusBuilder(ChallengeStatusFluent<?> fluent,ChallengeStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withPresented(instance.getPresented());
      fluent.withProcessing(instance.getProcessing());
      fluent.withReason(instance.getReason());
      fluent.withState(instance.getState());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ChallengeStatusBuilder(ChallengeStatus instance) {
    this(instance,false);
  }
  public ChallengeStatusBuilder(ChallengeStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withPresented(instance.getPresented());
      this.withProcessing(instance.getProcessing());
      this.withReason(instance.getReason());
      this.withState(instance.getState());
    }
    this.validationEnabled = validationEnabled; 
  }
  ChallengeStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ChallengeStatus build() {
    ChallengeStatus buildable = new ChallengeStatus(fluent.getPresented(),fluent.getProcessing(),fluent.getReason(),fluent.getState());
    return buildable;
  }
  
}