package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertificatePrivateKeyBuilder extends CertificatePrivateKeyFluentImpl<CertificatePrivateKeyBuilder> implements VisitableBuilder<CertificatePrivateKey,CertificatePrivateKeyBuilder>{
  public CertificatePrivateKeyBuilder() {
    this(false);
  }
  public CertificatePrivateKeyBuilder(Boolean validationEnabled) {
    this(new CertificatePrivateKey(), validationEnabled);
  }
  public CertificatePrivateKeyBuilder(CertificatePrivateKeyFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificatePrivateKeyBuilder(CertificatePrivateKeyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CertificatePrivateKey(), validationEnabled);
  }
  public CertificatePrivateKeyBuilder(CertificatePrivateKeyFluent<?> fluent,CertificatePrivateKey instance) {
    this(fluent, instance, false);
  }
  public CertificatePrivateKeyBuilder(CertificatePrivateKeyFluent<?> fluent,CertificatePrivateKey instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withRotationPolicy(instance.getRotationPolicy());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CertificatePrivateKeyBuilder(CertificatePrivateKey instance) {
    this(instance,false);
  }
  public CertificatePrivateKeyBuilder(CertificatePrivateKey instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withRotationPolicy(instance.getRotationPolicy());
    }
    this.validationEnabled = validationEnabled; 
  }
  CertificatePrivateKeyFluent<?> fluent;
  Boolean validationEnabled;
  public CertificatePrivateKey build() {
    CertificatePrivateKey buildable = new CertificatePrivateKey(fluent.getRotationPolicy());
    return buildable;
  }
  
}