/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.certmanager.api.model.meta.v1.ObjectReference;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluentImpl;
import io.fabric8.certmanager.api.model.v1alpha3.CertificateRequestSpec;
import io.fabric8.certmanager.api.model.v1alpha3.CertificateRequestSpecFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class CertificateRequestSpecFluentImpl<A extends CertificateRequestSpecFluent<A>>
extends BaseFluent<A>
implements CertificateRequestSpecFluent<A> {
    private String csr;
    private Duration duration;
    private Map<String, List<String>> extra;
    private List<String> groups = new ArrayList<String>();
    private Boolean isCA;
    private ObjectReferenceBuilder issuerRef;
    private String uid;
    private List<String> usages = new ArrayList<String>();
    private String username;

    public CertificateRequestSpecFluentImpl() {
    }

    public CertificateRequestSpecFluentImpl(CertificateRequestSpec instance) {
        if (instance != null) {
            this.withCsr(instance.getCsr());
            this.withDuration(instance.getDuration());
            this.withExtra(instance.getExtra());
            this.withGroups(instance.getGroups());
            this.withIsCA(instance.getIsCA());
            this.withIssuerRef(instance.getIssuerRef());
            this.withUid(instance.getUid());
            this.withUsages(instance.getUsages());
            this.withUsername(instance.getUsername());
        }
    }

    @Override
    public String getCsr() {
        return this.csr;
    }

    @Override
    public A withCsr(String csr) {
        this.csr = csr;
        return (A)this;
    }

    @Override
    public Boolean hasCsr() {
        return this.csr != null;
    }

    @Override
    public Duration getDuration() {
        return this.duration;
    }

    @Override
    public A withDuration(Duration duration) {
        this.duration = duration;
        return (A)this;
    }

    @Override
    public Boolean hasDuration() {
        return this.duration != null;
    }

    @Override
    public A addToExtra(String key, List<String> value) {
        if (this.extra == null && key != null && value != null) {
            this.extra = new LinkedHashMap<String, List<String>>();
        }
        if (key != null && value != null) {
            this.extra.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToExtra(Map<String, List<String>> map) {
        if (this.extra == null && map != null) {
            this.extra = new LinkedHashMap<String, List<String>>();
        }
        if (map != null) {
            this.extra.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtra(String key) {
        if (this.extra == null) {
            return (A)this;
        }
        if (key != null && this.extra != null) {
            this.extra.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtra(Map<String, List<String>> map) {
        if (this.extra == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.extra == null) continue;
                this.extra.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, List<String>> getExtra() {
        return this.extra;
    }

    @Override
    public <K, V> A withExtra(Map<String, List<String>> extra) {
        this.extra = extra == null ? null : new LinkedHashMap<String, List<String>>(extra);
        return (A)this;
    }

    @Override
    public Boolean hasExtra() {
        return this.extra != null;
    }

    @Override
    public A addToGroups(int index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(index, item);
        return (A)this;
    }

    @Override
    public A setToGroups(int index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.set(index, item);
        return (A)this;
    }

    @Override
    public A addToGroups(String ... items) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToGroups(Collection<String> items) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromGroups(String ... items) {
        for (String item : items) {
            if (this.groups == null) continue;
            this.groups.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGroups(Collection<String> items) {
        for (String item : items) {
            if (this.groups == null) continue;
            this.groups.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public String getGroup(int index) {
        return this.groups.get(index);
    }

    @Override
    public String getFirstGroup() {
        return this.groups.get(0);
    }

    @Override
    public String getLastGroup() {
        return this.groups.get(this.groups.size() - 1);
    }

    @Override
    public String getMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withGroups(List<String> groups) {
        if (groups != null) {
            this.groups = new ArrayList<String>();
            for (String item : groups) {
                this.addToGroups(item);
            }
        } else {
            this.groups = null;
        }
        return (A)this;
    }

    @Override
    public A withGroups(String ... groups) {
        if (this.groups != null) {
            this.groups.clear();
            this._visitables.remove((Object)"groups");
        }
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasGroups() {
        return this.groups != null && !this.groups.isEmpty();
    }

    @Override
    public Boolean getIsCA() {
        return this.isCA;
    }

    @Override
    public A withIsCA(Boolean isCA) {
        this.isCA = isCA;
        return (A)this;
    }

    @Override
    public Boolean hasIsCA() {
        return this.isCA != null;
    }

    @Override
    @Deprecated
    public ObjectReference getIssuerRef() {
        return this.issuerRef != null ? this.issuerRef.build() : null;
    }

    @Override
    public ObjectReference buildIssuerRef() {
        return this.issuerRef != null ? this.issuerRef.build() : null;
    }

    @Override
    public A withIssuerRef(ObjectReference issuerRef) {
        this._visitables.get((Object)"issuerRef").remove(this.issuerRef);
        if (issuerRef != null) {
            this.issuerRef = new ObjectReferenceBuilder(issuerRef);
            this._visitables.get((Object)"issuerRef").add(this.issuerRef);
        } else {
            this.issuerRef = null;
            this._visitables.get((Object)"issuerRef").remove(this.issuerRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasIssuerRef() {
        return this.issuerRef != null;
    }

    @Override
    public A withNewIssuerRef(String group, String kind, String name) {
        return this.withIssuerRef(new ObjectReference(group, kind, name));
    }

    @Override
    public CertificateRequestSpecFluent.IssuerRefNested<A> withNewIssuerRef() {
        return new IssuerRefNestedImpl();
    }

    @Override
    public CertificateRequestSpecFluent.IssuerRefNested<A> withNewIssuerRefLike(ObjectReference item) {
        return new IssuerRefNestedImpl(item);
    }

    @Override
    public CertificateRequestSpecFluent.IssuerRefNested<A> editIssuerRef() {
        return this.withNewIssuerRefLike(this.getIssuerRef());
    }

    @Override
    public CertificateRequestSpecFluent.IssuerRefNested<A> editOrNewIssuerRef() {
        return this.withNewIssuerRefLike(this.getIssuerRef() != null ? this.getIssuerRef() : new ObjectReferenceBuilder().build());
    }

    @Override
    public CertificateRequestSpecFluent.IssuerRefNested<A> editOrNewIssuerRefLike(ObjectReference item) {
        return this.withNewIssuerRefLike(this.getIssuerRef() != null ? this.getIssuerRef() : item);
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public A withUid(String uid) {
        this.uid = uid;
        return (A)this;
    }

    @Override
    public Boolean hasUid() {
        return this.uid != null;
    }

    @Override
    public A addToUsages(int index, String item) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        this.usages.add(index, item);
        return (A)this;
    }

    @Override
    public A setToUsages(int index, String item) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        this.usages.set(index, item);
        return (A)this;
    }

    @Override
    public A addToUsages(String ... items) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        for (String item : items) {
            this.usages.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToUsages(Collection<String> items) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        for (String item : items) {
            this.usages.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromUsages(String ... items) {
        for (String item : items) {
            if (this.usages == null) continue;
            this.usages.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromUsages(Collection<String> items) {
        for (String item : items) {
            if (this.usages == null) continue;
            this.usages.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getUsages() {
        return this.usages;
    }

    @Override
    public String getUsage(int index) {
        return this.usages.get(index);
    }

    @Override
    public String getFirstUsage() {
        return this.usages.get(0);
    }

    @Override
    public String getLastUsage() {
        return this.usages.get(this.usages.size() - 1);
    }

    @Override
    public String getMatchingUsage(Predicate<String> predicate) {
        for (String item : this.usages) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingUsage(Predicate<String> predicate) {
        for (String item : this.usages) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withUsages(List<String> usages) {
        if (usages != null) {
            this.usages = new ArrayList<String>();
            for (String item : usages) {
                this.addToUsages(item);
            }
        } else {
            this.usages = null;
        }
        return (A)this;
    }

    @Override
    public A withUsages(String ... usages) {
        if (this.usages != null) {
            this.usages.clear();
            this._visitables.remove((Object)"usages");
        }
        if (usages != null) {
            for (String item : usages) {
                this.addToUsages(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasUsages() {
        return this.usages != null && !this.usages.isEmpty();
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public A withUsername(String username) {
        this.username = username;
        return (A)this;
    }

    @Override
    public Boolean hasUsername() {
        return this.username != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CertificateRequestSpecFluentImpl that = (CertificateRequestSpecFluentImpl)o;
        if (!Objects.equals(this.csr, that.csr)) {
            return false;
        }
        if (!Objects.equals(this.duration, that.duration)) {
            return false;
        }
        if (!Objects.equals(this.extra, that.extra)) {
            return false;
        }
        if (!Objects.equals(this.groups, that.groups)) {
            return false;
        }
        if (!Objects.equals(this.isCA, that.isCA)) {
            return false;
        }
        if (!Objects.equals(this.issuerRef, that.issuerRef)) {
            return false;
        }
        if (!Objects.equals(this.uid, that.uid)) {
            return false;
        }
        if (!Objects.equals(this.usages, that.usages)) {
            return false;
        }
        return Objects.equals(this.username, that.username);
    }

    public int hashCode() {
        return Objects.hash(this.csr, this.duration, this.extra, this.groups, this.isCA, this.issuerRef, this.uid, this.usages, this.username, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.csr != null) {
            sb.append("csr:");
            sb.append(this.csr + ",");
        }
        if (this.duration != null) {
            sb.append("duration:");
            sb.append(this.duration + ",");
        }
        if (this.extra != null && !this.extra.isEmpty()) {
            sb.append("extra:");
            sb.append(this.extra + ",");
        }
        if (this.groups != null && !this.groups.isEmpty()) {
            sb.append("groups:");
            sb.append(this.groups + ",");
        }
        if (this.isCA != null) {
            sb.append("isCA:");
            sb.append(this.isCA + ",");
        }
        if (this.issuerRef != null) {
            sb.append("issuerRef:");
            sb.append(this.issuerRef + ",");
        }
        if (this.uid != null) {
            sb.append("uid:");
            sb.append(this.uid + ",");
        }
        if (this.usages != null && !this.usages.isEmpty()) {
            sb.append("usages:");
            sb.append(this.usages + ",");
        }
        if (this.username != null) {
            sb.append("username:");
            sb.append(this.username);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withIsCA() {
        return this.withIsCA(true);
    }

    class IssuerRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<CertificateRequestSpecFluent.IssuerRefNested<N>>
    implements CertificateRequestSpecFluent.IssuerRefNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        IssuerRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        IssuerRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)CertificateRequestSpecFluentImpl.this.withIssuerRef(this.builder.build());
        }

        @Override
        public N endIssuerRef() {
            return this.and();
        }
    }
}

