package io.fabric8.certmanager.api.model.acme.v1alpha3;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import java.util.LinkedHashMap;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ACMEIssuerDNS01ProviderRFC2136Fluent<A extends ACMEIssuerDNS01ProviderRFC2136Fluent<A>> extends BaseFluent<A>{
  public ACMEIssuerDNS01ProviderRFC2136Fluent() {
  }
  
  public ACMEIssuerDNS01ProviderRFC2136Fluent(ACMEIssuerDNS01ProviderRFC2136 instance) {
    this.copyInstance(instance);
  }
  private String nameserver;
  private String tsigAlgorithm;
  private String tsigKeyName;
  private SecretKeySelectorBuilder tsigSecretSecretRef;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ACMEIssuerDNS01ProviderRFC2136 instance) {
    instance = (instance != null ? instance : new ACMEIssuerDNS01ProviderRFC2136());
    if (instance != null) {
          this.withNameserver(instance.getNameserver());
          this.withTsigAlgorithm(instance.getTsigAlgorithm());
          this.withTsigKeyName(instance.getTsigKeyName());
          this.withTsigSecretSecretRef(instance.getTsigSecretSecretRef());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getNameserver() {
    return this.nameserver;
  }
  
  public A withNameserver(String nameserver) {
    this.nameserver = nameserver;
    return (A) this;
  }
  
  public boolean hasNameserver() {
    return this.nameserver != null;
  }
  
  public String getTsigAlgorithm() {
    return this.tsigAlgorithm;
  }
  
  public A withTsigAlgorithm(String tsigAlgorithm) {
    this.tsigAlgorithm = tsigAlgorithm;
    return (A) this;
  }
  
  public boolean hasTsigAlgorithm() {
    return this.tsigAlgorithm != null;
  }
  
  public String getTsigKeyName() {
    return this.tsigKeyName;
  }
  
  public A withTsigKeyName(String tsigKeyName) {
    this.tsigKeyName = tsigKeyName;
    return (A) this;
  }
  
  public boolean hasTsigKeyName() {
    return this.tsigKeyName != null;
  }
  
  public SecretKeySelector buildTsigSecretSecretRef() {
    return this.tsigSecretSecretRef != null ? this.tsigSecretSecretRef.build() : null;
  }
  
  public A withTsigSecretSecretRef(SecretKeySelector tsigSecretSecretRef) {
    this._visitables.remove("tsigSecretSecretRef");
    if (tsigSecretSecretRef != null) {
        this.tsigSecretSecretRef = new SecretKeySelectorBuilder(tsigSecretSecretRef);
        this._visitables.get("tsigSecretSecretRef").add(this.tsigSecretSecretRef);
    } else {
        this.tsigSecretSecretRef = null;
        this._visitables.get("tsigSecretSecretRef").remove(this.tsigSecretSecretRef);
    }
    return (A) this;
  }
  
  public boolean hasTsigSecretSecretRef() {
    return this.tsigSecretSecretRef != null;
  }
  
  public A withNewTsigSecretSecretRef(String key,String name) {
    return (A)withTsigSecretSecretRef(new SecretKeySelector(key, name));
  }
  
  public TsigSecretSecretRefNested<A> withNewTsigSecretSecretRef() {
    return new TsigSecretSecretRefNested(null);
  }
  
  public TsigSecretSecretRefNested<A> withNewTsigSecretSecretRefLike(SecretKeySelector item) {
    return new TsigSecretSecretRefNested(item);
  }
  
  public TsigSecretSecretRefNested<A> editTsigSecretSecretRef() {
    return withNewTsigSecretSecretRefLike(java.util.Optional.ofNullable(buildTsigSecretSecretRef()).orElse(null));
  }
  
  public TsigSecretSecretRefNested<A> editOrNewTsigSecretSecretRef() {
    return withNewTsigSecretSecretRefLike(java.util.Optional.ofNullable(buildTsigSecretSecretRef()).orElse(new SecretKeySelectorBuilder().build()));
  }
  
  public TsigSecretSecretRefNested<A> editOrNewTsigSecretSecretRefLike(SecretKeySelector item) {
    return withNewTsigSecretSecretRefLike(java.util.Optional.ofNullable(buildTsigSecretSecretRef()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ACMEIssuerDNS01ProviderRFC2136Fluent that = (ACMEIssuerDNS01ProviderRFC2136Fluent) o;
    if (!java.util.Objects.equals(nameserver, that.nameserver)) return false;
    if (!java.util.Objects.equals(tsigAlgorithm, that.tsigAlgorithm)) return false;
    if (!java.util.Objects.equals(tsigKeyName, that.tsigKeyName)) return false;
    if (!java.util.Objects.equals(tsigSecretSecretRef, that.tsigSecretSecretRef)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(nameserver,  tsigAlgorithm,  tsigKeyName,  tsigSecretSecretRef,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (nameserver != null) { sb.append("nameserver:"); sb.append(nameserver + ","); }
    if (tsigAlgorithm != null) { sb.append("tsigAlgorithm:"); sb.append(tsigAlgorithm + ","); }
    if (tsigKeyName != null) { sb.append("tsigKeyName:"); sb.append(tsigKeyName + ","); }
    if (tsigSecretSecretRef != null) { sb.append("tsigSecretSecretRef:"); sb.append(tsigSecretSecretRef + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class TsigSecretSecretRefNested<N> extends SecretKeySelectorFluent<TsigSecretSecretRefNested<N>> implements Nested<N>{
    TsigSecretSecretRefNested(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorBuilder builder;
    
    public N and() {
      return (N) ACMEIssuerDNS01ProviderRFC2136Fluent.this.withTsigSecretSecretRef(builder.build());
    }
    
    public N endTsigSecretSecretRef() {
      return and();
    }
    
  
  }

}