package io.fabric8.certmanager.api.model.acme.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class OrderStatusFluent<A extends OrderStatusFluent<A>> extends BaseFluent<A>{
  public OrderStatusFluent() {
  }
  
  public OrderStatusFluent(OrderStatus instance) {
    this.copyInstance(instance);
  }
  private ArrayList<ACMEAuthorizationBuilder> authorizations = new ArrayList<ACMEAuthorizationBuilder>();
  private String certificate;
  private String failureTime;
  private String finalizeURL;
  private String reason;
  private String state;
  private String url;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(OrderStatus instance) {
    instance = (instance != null ? instance : new OrderStatus());
    if (instance != null) {
          this.withAuthorizations(instance.getAuthorizations());
          this.withCertificate(instance.getCertificate());
          this.withFailureTime(instance.getFailureTime());
          this.withFinalizeURL(instance.getFinalizeURL());
          this.withReason(instance.getReason());
          this.withState(instance.getState());
          this.withUrl(instance.getUrl());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToAuthorizations(int index,ACMEAuthorization item) {
    if (this.authorizations == null) {this.authorizations = new ArrayList<ACMEAuthorizationBuilder>();}
    ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);
    if (index < 0 || index >= authorizations.size()) { _visitables.get("authorizations").add(builder); authorizations.add(builder); } else { _visitables.get("authorizations").add(index, builder); authorizations.add(index, builder);}
    return (A)this;
  }
  
  public A setToAuthorizations(int index,ACMEAuthorization item) {
    if (this.authorizations == null) {this.authorizations = new ArrayList<ACMEAuthorizationBuilder>();}
    ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);
    if (index < 0 || index >= authorizations.size()) { _visitables.get("authorizations").add(builder); authorizations.add(builder); } else { _visitables.get("authorizations").set(index, builder); authorizations.set(index, builder);}
    return (A)this;
  }
  
  public A addToAuthorizations(io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEAuthorization... items) {
    if (this.authorizations == null) {this.authorizations = new ArrayList<ACMEAuthorizationBuilder>();}
    for (ACMEAuthorization item : items) {ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);_visitables.get("authorizations").add(builder);this.authorizations.add(builder);} return (A)this;
  }
  
  public A addAllToAuthorizations(Collection<ACMEAuthorization> items) {
    if (this.authorizations == null) {this.authorizations = new ArrayList<ACMEAuthorizationBuilder>();}
    for (ACMEAuthorization item : items) {ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);_visitables.get("authorizations").add(builder);this.authorizations.add(builder);} return (A)this;
  }
  
  public A removeFromAuthorizations(io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEAuthorization... items) {
    if (this.authorizations == null) return (A)this;
    for (ACMEAuthorization item : items) {ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);_visitables.get("authorizations").remove(builder); this.authorizations.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAuthorizations(Collection<ACMEAuthorization> items) {
    if (this.authorizations == null) return (A)this;
    for (ACMEAuthorization item : items) {ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);_visitables.get("authorizations").remove(builder); this.authorizations.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAuthorizations(Predicate<ACMEAuthorizationBuilder> predicate) {
    if (authorizations == null) return (A) this;
    final Iterator<ACMEAuthorizationBuilder> each = authorizations.iterator();
    final List visitables = _visitables.get("authorizations");
    while (each.hasNext()) {
      ACMEAuthorizationBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ACMEAuthorization> buildAuthorizations() {
    return this.authorizations != null ? build(authorizations) : null;
  }
  
  public ACMEAuthorization buildAuthorization(int index) {
    return this.authorizations.get(index).build();
  }
  
  public ACMEAuthorization buildFirstAuthorization() {
    return this.authorizations.get(0).build();
  }
  
  public ACMEAuthorization buildLastAuthorization() {
    return this.authorizations.get(authorizations.size() - 1).build();
  }
  
  public ACMEAuthorization buildMatchingAuthorization(Predicate<ACMEAuthorizationBuilder> predicate) {
      for (ACMEAuthorizationBuilder item : authorizations) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAuthorization(Predicate<ACMEAuthorizationBuilder> predicate) {
      for (ACMEAuthorizationBuilder item : authorizations) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAuthorizations(List<ACMEAuthorization> authorizations) {
    if (this.authorizations != null) {
      this._visitables.get("authorizations").clear();
    }
    if (authorizations != null) {
        this.authorizations = new ArrayList();
        for (ACMEAuthorization item : authorizations) {
          this.addToAuthorizations(item);
        }
    } else {
      this.authorizations = null;
    }
    return (A) this;
  }
  
  public A withAuthorizations(io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEAuthorization... authorizations) {
    if (this.authorizations != null) {
        this.authorizations.clear();
        _visitables.remove("authorizations");
    }
    if (authorizations != null) {
      for (ACMEAuthorization item : authorizations) {
        this.addToAuthorizations(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAuthorizations() {
    return this.authorizations != null && !this.authorizations.isEmpty();
  }
  
  public AuthorizationsNested<A> addNewAuthorization() {
    return new AuthorizationsNested(-1, null);
  }
  
  public AuthorizationsNested<A> addNewAuthorizationLike(ACMEAuthorization item) {
    return new AuthorizationsNested(-1, item);
  }
  
  public AuthorizationsNested<A> setNewAuthorizationLike(int index,ACMEAuthorization item) {
    return new AuthorizationsNested(index, item);
  }
  
  public AuthorizationsNested<A> editAuthorization(int index) {
    if (authorizations.size() <= index) throw new RuntimeException("Can't edit authorizations. Index exceeds size.");
    return setNewAuthorizationLike(index, buildAuthorization(index));
  }
  
  public AuthorizationsNested<A> editFirstAuthorization() {
    if (authorizations.size() == 0) throw new RuntimeException("Can't edit first authorizations. The list is empty.");
    return setNewAuthorizationLike(0, buildAuthorization(0));
  }
  
  public AuthorizationsNested<A> editLastAuthorization() {
    int index = authorizations.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last authorizations. The list is empty.");
    return setNewAuthorizationLike(index, buildAuthorization(index));
  }
  
  public AuthorizationsNested<A> editMatchingAuthorization(Predicate<ACMEAuthorizationBuilder> predicate) {
    int index = -1;
    for (int i=0;i<authorizations.size();i++) { 
    if (predicate.test(authorizations.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching authorizations. No match found.");
    return setNewAuthorizationLike(index, buildAuthorization(index));
  }
  
  public String getCertificate() {
    return this.certificate;
  }
  
  public A withCertificate(String certificate) {
    this.certificate = certificate;
    return (A) this;
  }
  
  public boolean hasCertificate() {
    return this.certificate != null;
  }
  
  public String getFailureTime() {
    return this.failureTime;
  }
  
  public A withFailureTime(String failureTime) {
    this.failureTime = failureTime;
    return (A) this;
  }
  
  public boolean hasFailureTime() {
    return this.failureTime != null;
  }
  
  public String getFinalizeURL() {
    return this.finalizeURL;
  }
  
  public A withFinalizeURL(String finalizeURL) {
    this.finalizeURL = finalizeURL;
    return (A) this;
  }
  
  public boolean hasFinalizeURL() {
    return this.finalizeURL != null;
  }
  
  public String getReason() {
    return this.reason;
  }
  
  public A withReason(String reason) {
    this.reason = reason;
    return (A) this;
  }
  
  public boolean hasReason() {
    return this.reason != null;
  }
  
  public String getState() {
    return this.state;
  }
  
  public A withState(String state) {
    this.state = state;
    return (A) this;
  }
  
  public boolean hasState() {
    return this.state != null;
  }
  
  public String getUrl() {
    return this.url;
  }
  
  public A withUrl(String url) {
    this.url = url;
    return (A) this;
  }
  
  public boolean hasUrl() {
    return this.url != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OrderStatusFluent that = (OrderStatusFluent) o;
    if (!java.util.Objects.equals(authorizations, that.authorizations)) return false;
    if (!java.util.Objects.equals(certificate, that.certificate)) return false;
    if (!java.util.Objects.equals(failureTime, that.failureTime)) return false;
    if (!java.util.Objects.equals(finalizeURL, that.finalizeURL)) return false;
    if (!java.util.Objects.equals(reason, that.reason)) return false;
    if (!java.util.Objects.equals(state, that.state)) return false;
    if (!java.util.Objects.equals(url, that.url)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(authorizations,  certificate,  failureTime,  finalizeURL,  reason,  state,  url,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authorizations != null && !authorizations.isEmpty()) { sb.append("authorizations:"); sb.append(authorizations + ","); }
    if (certificate != null) { sb.append("certificate:"); sb.append(certificate + ","); }
    if (failureTime != null) { sb.append("failureTime:"); sb.append(failureTime + ","); }
    if (finalizeURL != null) { sb.append("finalizeURL:"); sb.append(finalizeURL + ","); }
    if (reason != null) { sb.append("reason:"); sb.append(reason + ","); }
    if (state != null) { sb.append("state:"); sb.append(state + ","); }
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AuthorizationsNested<N> extends ACMEAuthorizationFluent<AuthorizationsNested<N>> implements Nested<N>{
    AuthorizationsNested(int index,ACMEAuthorization item) {
      this.index = index;
      this.builder = new ACMEAuthorizationBuilder(this, item);
    }
    ACMEAuthorizationBuilder builder;
    int index;
    
    public N and() {
      return (N) OrderStatusFluent.this.setToAuthorizations(index,builder.build());
    }
    
    public N endAuthorization() {
      return and();
    }
    
  
  }

}