/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.chaosmesh.v1alpha1.Task;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class TaskFluent<A extends TaskFluent<A>>
extends BaseFluent<A> {
    private ContainerBuilder container;
    private ArrayList<VolumeBuilder> volumes = new ArrayList();
    private Map<String, Object> additionalProperties;

    public TaskFluent() {
    }

    public TaskFluent(Task instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Task instance) {
        Task task = instance = instance != null ? instance : new Task();
        if (instance != null) {
            this.withContainer(instance.getContainer());
            this.withVolumes(instance.getVolumes());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Container buildContainer() {
        return this.container != null ? this.container.build() : null;
    }

    public A withContainer(Container container) {
        this._visitables.remove((Object)"container");
        if (container != null) {
            this.container = new ContainerBuilder(container);
            this._visitables.get((Object)"container").add(this.container);
        } else {
            this.container = null;
            this._visitables.get((Object)"container").remove(this.container);
        }
        return (A)((Object)this);
    }

    public boolean hasContainer() {
        return this.container != null;
    }

    public ContainerNested<A> withNewContainer() {
        return new ContainerNested(null);
    }

    public ContainerNested<A> withNewContainerLike(Container item) {
        return new ContainerNested(item);
    }

    public ContainerNested<A> editContainer() {
        return this.withNewContainerLike(Optional.ofNullable(this.buildContainer()).orElse(null));
    }

    public ContainerNested<A> editOrNewContainer() {
        return this.withNewContainerLike(Optional.ofNullable(this.buildContainer()).orElse(new ContainerBuilder().build()));
    }

    public ContainerNested<A> editOrNewContainerLike(Container item) {
        return this.withNewContainerLike(Optional.ofNullable(this.buildContainer()).orElse(item));
    }

    public A addToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        VolumeBuilder builder = new VolumeBuilder(item);
        if (index < 0 || index >= this.volumes.size()) {
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        } else {
            this._visitables.get((Object)"volumes").add(index, builder);
            this.volumes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        VolumeBuilder builder = new VolumeBuilder(item);
        if (index < 0 || index >= this.volumes.size()) {
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        } else {
            this._visitables.get((Object)"volumes").set(index, builder);
            this.volumes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToVolumes(Volume ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToVolumes(Collection<Volume> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromVolumes(Volume ... items) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").remove(builder);
            this.volumes.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVolumes(Collection<Volume> items) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").remove(builder);
            this.volumes.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromVolumes(Predicate<VolumeBuilder> predicate) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        Iterator<VolumeBuilder> each = this.volumes.iterator();
        List visitables = this._visitables.get((Object)"volumes");
        while (each.hasNext()) {
            VolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Volume> buildVolumes() {
        return this.volumes != null ? TaskFluent.build(this.volumes) : null;
    }

    public Volume buildVolume(int index) {
        return this.volumes.get(index).build();
    }

    public Volume buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    public Volume buildLastVolume() {
        return this.volumes.get(this.volumes.size() - 1).build();
    }

    public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVolumes(List<Volume> volumes) {
        if (this.volumes != null) {
            this._visitables.get((Object)"volumes").clear();
        }
        if (volumes != null) {
            this.volumes = new ArrayList();
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)((Object)this);
    }

    public A withVolumes(Volume ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
            this._visitables.remove((Object)"volumes");
        }
        if (volumes != null) {
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    public VolumesNested<A> addNewVolume() {
        return new VolumesNested(-1, null);
    }

    public VolumesNested<A> addNewVolumeLike(Volume item) {
        return new VolumesNested(-1, item);
    }

    public VolumesNested<A> setNewVolumeLike(int index, Volume item) {
        return new VolumesNested(index, item);
    }

    public VolumesNested<A> editVolume(int index) {
        if (this.volumes.size() <= index) {
            throw new RuntimeException("Can't edit volumes. Index exceeds size.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public VolumesNested<A> editFirstVolume() {
        if (this.volumes.size() == 0) {
            throw new RuntimeException("Can't edit first volumes. The list is empty.");
        }
        return this.setNewVolumeLike(0, this.buildVolume(0));
    }

    public VolumesNested<A> editLastVolume() {
        int index = this.volumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumes. The list is empty.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumes.size(); ++i) {
            if (!predicate.test(this.volumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumes. No match found.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaskFluent that = (TaskFluent)((Object)o);
        if (!Objects.equals(this.container, that.container)) {
            return false;
        }
        if (!Objects.equals(this.volumes, that.volumes)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.container, this.volumes, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.container != null) {
            sb.append("container:");
            sb.append(this.container + ",");
        }
        if (this.volumes != null && !this.volumes.isEmpty()) {
            sb.append("volumes:");
            sb.append(this.volumes + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class VolumesNested<N>
    extends VolumeFluent<VolumesNested<N>>
    implements Nested<N> {
        VolumeBuilder builder;
        int index;

        VolumesNested(int index, Volume item) {
            this.index = index;
            this.builder = new VolumeBuilder((VolumeFluent)this, item);
        }

        public N and() {
            return (N)TaskFluent.this.setToVolumes(this.index, this.builder.build());
        }

        public N endVolume() {
            return this.and();
        }
    }

    public class ContainerNested<N>
    extends ContainerFluent<ContainerNested<N>>
    implements Nested<N> {
        ContainerBuilder builder;

        ContainerNested(Container item) {
            this.builder = new ContainerBuilder((ContainerFluent)this, item);
        }

        public N and() {
            return (N)TaskFluent.this.withContainer(this.builder.build());
        }

        public N endContainer() {
            return this.and();
        }
    }
}

