/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.chaosmesh.v1alpha1.Template;
import io.fabric8.chaosmesh.v1alpha1.TemplateBuilder;
import io.fabric8.chaosmesh.v1alpha1.TemplateFluent;
import io.fabric8.chaosmesh.v1alpha1.WorkflowSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class WorkflowSpecFluent<A extends WorkflowSpecFluent<A>>
extends BaseFluent<A> {
    private String entry;
    private ArrayList<TemplateBuilder> templates = new ArrayList();
    private Map<String, Object> additionalProperties;

    public WorkflowSpecFluent() {
    }

    public WorkflowSpecFluent(WorkflowSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(WorkflowSpec instance) {
        WorkflowSpec workflowSpec = instance = instance != null ? instance : new WorkflowSpec();
        if (instance != null) {
            this.withEntry(instance.getEntry());
            this.withTemplates(instance.getTemplates());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getEntry() {
        return this.entry;
    }

    public A withEntry(String entry) {
        this.entry = entry;
        return (A)((Object)this);
    }

    public boolean hasEntry() {
        return this.entry != null;
    }

    public A addToTemplates(int index, Template item) {
        if (this.templates == null) {
            this.templates = new ArrayList();
        }
        TemplateBuilder builder = new TemplateBuilder(item);
        if (index < 0 || index >= this.templates.size()) {
            this._visitables.get((Object)"templates").add(builder);
            this.templates.add(builder);
        } else {
            this._visitables.get((Object)"templates").add(builder);
            this.templates.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToTemplates(int index, Template item) {
        if (this.templates == null) {
            this.templates = new ArrayList();
        }
        TemplateBuilder builder = new TemplateBuilder(item);
        if (index < 0 || index >= this.templates.size()) {
            this._visitables.get((Object)"templates").add(builder);
            this.templates.add(builder);
        } else {
            this._visitables.get((Object)"templates").add(builder);
            this.templates.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToTemplates(Template ... items) {
        if (this.templates == null) {
            this.templates = new ArrayList();
        }
        for (Template item : items) {
            TemplateBuilder builder = new TemplateBuilder(item);
            this._visitables.get((Object)"templates").add(builder);
            this.templates.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToTemplates(Collection<Template> items) {
        if (this.templates == null) {
            this.templates = new ArrayList();
        }
        for (Template item : items) {
            TemplateBuilder builder = new TemplateBuilder(item);
            this._visitables.get((Object)"templates").add(builder);
            this.templates.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromTemplates(Template ... items) {
        if (this.templates == null) {
            return (A)((Object)this);
        }
        for (Template item : items) {
            TemplateBuilder builder = new TemplateBuilder(item);
            this._visitables.get((Object)"templates").remove((Object)builder);
            this.templates.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTemplates(Collection<Template> items) {
        if (this.templates == null) {
            return (A)((Object)this);
        }
        for (Template item : items) {
            TemplateBuilder builder = new TemplateBuilder(item);
            this._visitables.get((Object)"templates").remove((Object)builder);
            this.templates.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTemplates(Predicate<TemplateBuilder> predicate) {
        if (this.templates == null) {
            return (A)((Object)this);
        }
        Iterator<TemplateBuilder> each = this.templates.iterator();
        List visitables = this._visitables.get((Object)"templates");
        while (each.hasNext()) {
            TemplateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Template> buildTemplates() {
        return this.templates != null ? WorkflowSpecFluent.build(this.templates) : null;
    }

    public Template buildTemplate(int index) {
        return this.templates.get(index).build();
    }

    public Template buildFirstTemplate() {
        return this.templates.get(0).build();
    }

    public Template buildLastTemplate() {
        return this.templates.get(this.templates.size() - 1).build();
    }

    public Template buildMatchingTemplate(Predicate<TemplateBuilder> predicate) {
        for (TemplateBuilder item : this.templates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTemplate(Predicate<TemplateBuilder> predicate) {
        for (TemplateBuilder item : this.templates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTemplates(List<Template> templates) {
        if (this.templates != null) {
            this._visitables.get((Object)"templates").clear();
        }
        if (templates != null) {
            this.templates = new ArrayList();
            for (Template item : templates) {
                this.addToTemplates(item);
            }
        } else {
            this.templates = null;
        }
        return (A)((Object)this);
    }

    public A withTemplates(Template ... templates) {
        if (this.templates != null) {
            this.templates.clear();
            this._visitables.remove((Object)"templates");
        }
        if (templates != null) {
            for (Template item : templates) {
                this.addToTemplates(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTemplates() {
        return this.templates != null && !this.templates.isEmpty();
    }

    public TemplatesNested<A> addNewTemplate() {
        return new TemplatesNested(-1, null);
    }

    public TemplatesNested<A> addNewTemplateLike(Template item) {
        return new TemplatesNested(-1, item);
    }

    public TemplatesNested<A> setNewTemplateLike(int index, Template item) {
        return new TemplatesNested(index, item);
    }

    public TemplatesNested<A> editTemplate(int index) {
        if (this.templates.size() <= index) {
            throw new RuntimeException("Can't edit templates. Index exceeds size.");
        }
        return this.setNewTemplateLike(index, this.buildTemplate(index));
    }

    public TemplatesNested<A> editFirstTemplate() {
        if (this.templates.size() == 0) {
            throw new RuntimeException("Can't edit first templates. The list is empty.");
        }
        return this.setNewTemplateLike(0, this.buildTemplate(0));
    }

    public TemplatesNested<A> editLastTemplate() {
        int index = this.templates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last templates. The list is empty.");
        }
        return this.setNewTemplateLike(index, this.buildTemplate(index));
    }

    public TemplatesNested<A> editMatchingTemplate(Predicate<TemplateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.templates.size(); ++i) {
            if (!predicate.test(this.templates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching templates. No match found.");
        }
        return this.setNewTemplateLike(index, this.buildTemplate(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WorkflowSpecFluent that = (WorkflowSpecFluent)((Object)o);
        if (!Objects.equals(this.entry, that.entry)) {
            return false;
        }
        if (!Objects.equals(this.templates, that.templates)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.entry, this.templates, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.entry != null) {
            sb.append("entry:");
            sb.append(this.entry + ",");
        }
        if (this.templates != null && !this.templates.isEmpty()) {
            sb.append("templates:");
            sb.append(String.valueOf(this.templates) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TemplatesNested<N>
    extends TemplateFluent<TemplatesNested<N>>
    implements Nested<N> {
        TemplateBuilder builder;
        int index;

        TemplatesNested(int index, Template item) {
            this.index = index;
            this.builder = new TemplateBuilder(this, item);
        }

        public N and() {
            return (N)WorkflowSpecFluent.this.setToTemplates(this.index, this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }
}

