/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.chaosmesh.server.mock;

import io.fabric8.chaosmesh.client.ChaosMeshClient;
import io.fabric8.chaosmesh.client.NamespacedChaosMeshClient;
import io.fabric8.chaosmesh.server.mock.ChaosMeshMockServer;
import io.fabric8.chaosmesh.server.mock.EnableChaosMeshMockClient;
import io.fabric8.kubernetes.client.server.mock.KubernetesMixedDispatcher;
import io.fabric8.kubernetes.client.server.mock.KubernetesMockServerExtension;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Queue;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ChaosMeshMockServerExtension
extends KubernetesMockServerExtension {
    private ChaosMeshMockServer chaosMeshMockServer;
    private NamespacedChaosMeshClient chaosMeshClient;

    protected void destroy() {
        this.chaosMeshMockServer.destroy();
        this.chaosMeshClient.close();
    }

    protected Class<?> getClientType() {
        return ChaosMeshClient.class;
    }

    protected Class<?> getKubernetesMockServerType() {
        return ChaosMeshMockServer.class;
    }

    protected void initializeKubernetesClientAndMockServer(Class<?> testClass) {
        EnableChaosMeshMockClient a = testClass.getAnnotation(EnableChaosMeshMockClient.class);
        HashMap<ServerRequest, Queue<ServerResponse>> responses = new HashMap<ServerRequest, Queue<ServerResponse>>();
        this.chaosMeshMockServer = a.crud() ? new ChaosMeshMockServer(new Context(), new MockWebServer(), responses, (Dispatcher)new KubernetesMixedDispatcher(responses), a.https()) : new ChaosMeshMockServer(a.https());
        this.chaosMeshMockServer.init();
        this.chaosMeshClient = this.chaosMeshMockServer.createChaosMeshClient();
    }

    protected void setFieldIfKubernetesClientOrMockServer(ExtensionContext context, boolean isStatic, Field field) throws IllegalAccessException {
        this.setFieldIfEqualsToProvidedType(context, isStatic, field, this.getClientType(), (i, f) -> f.set(i, this.chaosMeshClient));
        this.setFieldIfEqualsToProvidedType(context, isStatic, field, this.getKubernetesMockServerType(), (i, f) -> f.set(i, (Object)this.chaosMeshMockServer));
    }
}

