/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.utils.cxf;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.cfg.Annotations;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import io.fabric8.utils.Strings;
import io.fabric8.utils.cxf.ExceptionResponseMapper;
import io.fabric8.utils.jaxrs.JsonHelper;
import io.fabric8.utils.ssl.TrustEverythingSSLTrustManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import net.oauth.signature.pem.PEMReader;
import net.oauth.signature.pem.PKCS1EncodedKeySpec;
import org.apache.cxf.attachment.Base64DecoderStream;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.auth.DigestAuthSupplier;
import org.apache.cxf.transport.http.auth.HttpAuthSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebClients {
    private static final transient Logger LOG = LoggerFactory.getLogger(WebClients.class);

    public static InputStream getInputStreamFromDataOrFile(String data, File file) throws FileNotFoundException {
        if (data != null) {
            return new Base64DecoderStream((InputStream)new ByteArrayInputStream(data.getBytes()));
        }
        if (file != null) {
            return new FileInputStream(file);
        }
        return null;
    }

    public static KeyStore createTrustStore(String caCertData, File caCertFile) throws Exception {
        try (InputStream pemInputStream = WebClients.getInputStreamFromDataOrFile(caCertData, caCertFile);){
            CertificateFactory certFactory = CertificateFactory.getInstance("X509");
            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(pemInputStream);
            KeyStore trustStore = KeyStore.getInstance("JKS");
            trustStore.load(null);
            String alias = cert.getSubjectX500Principal().getName();
            trustStore.setCertificateEntry(alias, cert);
            KeyStore keyStore = trustStore;
            return keyStore;
        }
    }

    public static void configureCaCert(WebClient webClient, String caCertData, File caCertFile) {
        try {
            TrustManager[] existingTrustManagers;
            KeyStore trustStore = WebClients.createTrustStore(caCertData, caCertFile);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            HTTPConduit conduit = WebClient.getConfig((Object)webClient).getHttpConduit();
            TLSClientParameters params = conduit.getTlsClientParameters();
            if (params == null) {
                params = new TLSClientParameters();
                conduit.setTlsClientParameters(params);
            }
            if ((existingTrustManagers = params.getTrustManagers()) != null && existingTrustManagers.length > 0) {
                ArrayList<TrustManager> list = new ArrayList<TrustManager>();
                list.addAll(Arrays.asList(existingTrustManagers));
                list.addAll(Arrays.asList(trustManagers));
                trustManagers = list.toArray(new TrustManager[list.size()]);
            }
            params.setTrustManagers(trustManagers);
        }
        catch (Exception e) {
            LOG.error("Could not create trust manager for " + caCertFile, (Throwable)e);
        }
    }

    public static void disableSslChecks(WebClient webClient) {
        HTTPConduit conduit = WebClient.getConfig((Object)webClient).getHttpConduit();
        TLSClientParameters params = conduit.getTlsClientParameters();
        if (params == null) {
            params = new TLSClientParameters();
            conduit.setTlsClientParameters(params);
        }
        params.setTrustManagers(new TrustManager[]{new TrustEverythingSSLTrustManager()});
        params.setDisableCNCheck(true);
    }

    public static void disableHostNameChecks(WebClient webClient) {
        HTTPConduit conduit = WebClient.getConfig((Object)webClient).getHttpConduit();
        TLSClientParameters params = conduit.getTlsClientParameters();
        if (params == null) {
            params = new TLSClientParameters();
            conduit.setTlsClientParameters(params);
        }
        LOG.debug("Disabling host name checks");
        params.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        });
    }

    public static void configureClientCert(WebClient webClient, String clientCertData, File clientCertFile, String clientKeyData, File clientKeyFile, String clientKeyAlgo, char[] clientKeyPassword) {
        try {
            KeyManager[] existingKeyManagers;
            KeyStore keyStore = WebClients.createKeyStore(clientCertData, clientCertFile, clientKeyData, clientKeyFile, clientKeyAlgo, clientKeyPassword);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, clientKeyPassword);
            KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
            HTTPConduit conduit = WebClient.getConfig((Object)webClient).getHttpConduit();
            TLSClientParameters params = conduit.getTlsClientParameters();
            if (params == null) {
                params = new TLSClientParameters();
                conduit.setTlsClientParameters(params);
            }
            if ((existingKeyManagers = params.getKeyManagers()) != null && existingKeyManagers.length > 0) {
                ArrayList<KeyManager> list = new ArrayList<KeyManager>();
                list.addAll(Arrays.asList(existingKeyManagers));
                list.addAll(Arrays.asList(keyManagers));
                keyManagers = list.toArray(new KeyManager[list.size()]);
            }
            params.setKeyManagers(keyManagers);
        }
        catch (Exception e) {
            LOG.error("Could not create key manager for " + clientCertFile + " (" + clientKeyFile + ")", (Throwable)e);
        }
    }

    public static KeyStore createKeyStore(String clientCertData, File clientCertFile, String clientKeyData, File clientKeyFile, String clientKeyAlgo, char[] clientKeyPassword) throws Exception {
        try (InputStream certInputStream = WebClients.getInputStreamFromDataOrFile(clientCertData, clientCertFile);){
            CertificateFactory certFactory = CertificateFactory.getInstance("X509");
            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(certInputStream);
            InputStream keyInputStream = WebClients.getInputStreamFromDataOrFile(clientKeyData, clientKeyFile);
            PEMReader reader = new PEMReader(keyInputStream);
            RSAPrivateCrtKeySpec keySpec = new PKCS1EncodedKeySpec(reader.getDerBytes()).getKeySpec();
            KeyFactory kf = KeyFactory.getInstance(clientKeyAlgo);
            RSAPrivateKey privKey = (RSAPrivateKey)kf.generatePrivate(keySpec);
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null, clientKeyPassword);
            String alias = cert.getSubjectX500Principal().getName();
            keyStore.setKeyEntry(alias, privKey, clientKeyPassword, new Certificate[]{cert});
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
    }

    public static void configureUserAndPassword(WebClient webClient, String username, String password) {
        if (Strings.isNotBlank((String)username) && Strings.isNotBlank((String)password)) {
            HTTPConduit conduit = WebClient.getConfig((Object)webClient).getHttpConduit();
            conduit.getAuthorization().setUserName(username);
            conduit.getAuthorization().setPassword(password);
        }
    }

    public static ClientRequestFilter createPrivateTokenFilter(final String privateToken) {
        ClientRequestFilter interceptor = new ClientRequestFilter(){

            public void filter(ClientRequestContext requestContext) throws IOException {
                requestContext.getHeaders().add((Object)"PRIVATE-TOKEN", (Object)privateToken);
            }
        };
        return interceptor;
    }

    public static void configureAuthorization(WebClient webClient, String username, String authorizationType, String authorization) {
        HTTPConduit conduit = WebClient.getConfig((Object)webClient).getHttpConduit();
        if (Strings.isNotBlank((String)username)) {
            conduit.getAuthorization().setUserName(username);
        }
        if (Strings.isNotBlank((String)authorizationType) && Strings.isNotBlank((String)authorization)) {
            conduit.getAuthorization().setUserName(username);
            conduit.getAuthorization().setAuthorizationType(authorizationType);
            conduit.getAuthorization().setAuthorization(authorization);
        }
    }

    public static void enableDigestAuthenticaionType(WebClient webClient) {
        HTTPConduit conduit = WebClient.getConfig((Object)webClient).getHttpConduit();
        conduit.setAuthSupplier((HttpAuthSupplier)new DigestAuthSupplier());
    }

    public static List<Object> createProviders() {
        ArrayList<Object> providers = new ArrayList<Object>();
        Annotations[] annotationsToUse = JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS;
        ObjectMapper objectMapper = JsonHelper.createObjectMapper();
        providers.add(new JacksonJaxbJsonProvider(objectMapper, annotationsToUse));
        providers.add(new ExceptionResponseMapper());
        return providers;
    }
}

