/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.examples;

import io.fabric8.docker.api.model.ContainerCreateResponse;
import io.fabric8.docker.api.model.ContainerExecCreateResponse;
import io.fabric8.docker.api.model.InlineContainerCreate;
import io.fabric8.docker.api.model.InlineExecConfig;
import io.fabric8.docker.client.Config;
import io.fabric8.docker.client.ConfigBuilder;
import io.fabric8.docker.client.DefaultDockerClient;
import io.fabric8.docker.client.DockerClientException;
import io.fabric8.docker.client.EditableConfig;
import io.fabric8.docker.dsl.EventListener;
import io.fabric8.docker.dsl.OutputHandle;
import io.fabric8.docker.dsl.container.ContainerErrorUsingListenerExecResourceInterface;
import io.fabric8.docker.dsl.container.ContainerExecResource;
import io.fabric8.docker.dsl.container.ContainerExecResourceLogsAttachArchiveInterface;
import io.fabric8.docker.dsl.container.ContainerExecResourceOutputErrorUsingListenerInterface;
import io.fabric8.docker.dsl.container.UsingListenerContainerExecResourceInterface;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ContainerExecStartExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException, IOException {
        OutputHandle handle = null;
        if (args.length < 2) {
            System.err.println("Usage: ContainerLogsExample <docker url>");
            System.err.println("Optionally: ContainerLogsExample <docker url> <container id>");
            return;
        }
        String dockerUrl = args[0];
        String image = args[1];
        EditableConfig config = ((ConfigBuilder)new ConfigBuilder().withDockerUrl(dockerUrl)).build();
        DefaultDockerClient client = new DefaultDockerClient((Config)config);
        try {
            ContainerCreateResponse container = ((InlineContainerCreate)((InlineContainerCreate)((InlineContainerCreate)client.container().createNew()).withName("example")).withImage(image)).done();
            if (!((Boolean)((ContainerExecResourceLogsAttachArchiveInterface)client.container().withName(container.getId())).start()).booleanValue()) {
                throw new DockerClientException("Failed to start container.");
            }
            System.out.println("Container started!");
            String[] commands = new String[]{"sh", "-c", "ping localhost"};
            ContainerExecCreateResponse done = ((InlineExecConfig)((InlineExecConfig)((InlineExecConfig)((InlineExecConfig)((InlineExecConfig)((InlineExecConfig)((ContainerExecResourceLogsAttachArchiveInterface)client.container().withName(container.getId())).execNew()).withCmd(commands)).withAttachStderr(Boolean.valueOf(true))).withAttachStdout(Boolean.valueOf(true))).withTty(Boolean.valueOf(false))).withDetach(Boolean.valueOf(false))).done();
            CountDownLatch countDownLatch = new CountDownLatch(1);
            handle = (OutputHandle)((ContainerExecResource)((UsingListenerContainerExecResourceInterface)((ContainerErrorUsingListenerExecResourceInterface)((ContainerExecResourceOutputErrorUsingListenerInterface)client.exec().withName(done.getId())).writingOutput((OutputStream)System.out)).writingError((OutputStream)System.err)).usingListener(new EventListener(){

                public void onSuccess(String message) {
                }

                public void onError(String message) {
                }

                public void onError(Throwable t) {
                }

                public void onEvent(String event) {
                    System.out.println("*****" + event);
                }
            })).start(false);
            countDownLatch.await(10L, TimeUnit.SECONDS);
            if (!((Boolean)((ContainerExecResourceLogsAttachArchiveInterface)client.container().withName(container.getId())).stop()).booleanValue()) {
                throw new DockerClientException("Failed to stop container.");
            }
            System.out.println("Container stopped!");
            ((ContainerExecResourceLogsAttachArchiveInterface)client.container().withName(container.getId())).remove();
        }
        finally {
            if (handle != null) {
                handle.close();
            }
            System.out.close();
            System.err.close();
            client.close();
        }
    }
}

