/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.examples;

import io.fabric8.docker.client.Config;
import io.fabric8.docker.client.ConfigBuilder;
import io.fabric8.docker.client.DefaultDockerClient;
import io.fabric8.docker.client.EditableConfig;
import io.fabric8.docker.dsl.EventListener;
import io.fabric8.docker.dsl.OutputHandle;
import io.fabric8.docker.dsl.container.ContainerErrorTimestampsTailingLinesUsingListenerFollowDisplayInterface;
import io.fabric8.docker.dsl.container.ContainerExecResourceLogsAttachArchiveInterface;
import io.fabric8.docker.dsl.container.FollowDisplayInterface;
import io.fabric8.docker.dsl.container.SinceContainerOutputErrorTimestampsTailingLinesUsingListenerFollowDisplayInterface;
import io.fabric8.docker.dsl.container.TimestampsTailingLinesUsingListenerFollowDisplayInterface;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ContainerLogsExample {
    public static void main(String[] args) throws InterruptedException, IOException {
        if (args.length < 2) {
            System.err.println("Usage: ContainerLogsExample <docker url>");
            System.err.println("Optionally: ContainerLogsExample <docker url> <container id>");
            return;
        }
        String dockerUrl = args[0];
        String containerId = args[1];
        EditableConfig config = ((ConfigBuilder)new ConfigBuilder().withDockerUrl(dockerUrl)).build();
        DefaultDockerClient client = new DefaultDockerClient((Config)config);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        OutputHandle handle = (OutputHandle)((FollowDisplayInterface)((TimestampsTailingLinesUsingListenerFollowDisplayInterface)((ContainerErrorTimestampsTailingLinesUsingListenerFollowDisplayInterface)((SinceContainerOutputErrorTimestampsTailingLinesUsingListenerFollowDisplayInterface)((ContainerExecResourceLogsAttachArchiveInterface)client.container().withName(containerId)).logs()).writingOutput((OutputStream)System.out)).writingError((OutputStream)System.err)).usingListener(new EventListener(){

            public void onSuccess(String message) {
                System.out.println(message);
            }

            public void onError(String message) {
                System.out.println(message);
            }

            public void onError(Throwable t) {
                t.printStackTrace(System.err);
            }

            public void onEvent(String event) {
                System.out.println(event);
            }
        })).follow();
        countDownLatch.await(10L, TimeUnit.SECONDS);
        handle.close();
        client.close();
    }
}

