/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.examples;

import io.fabric8.docker.api.model.ContainerCreateResponse;
import io.fabric8.docker.api.model.InlineContainerCreate;
import io.fabric8.docker.client.Config;
import io.fabric8.docker.client.ConfigBuilder;
import io.fabric8.docker.client.DefaultDockerClient;
import io.fabric8.docker.client.DockerClientException;
import io.fabric8.docker.client.EditableConfig;
import io.fabric8.docker.dsl.EventListener;
import io.fabric8.docker.dsl.OutputHandle;
import io.fabric8.docker.dsl.container.ContainerErrorTimestampsTailingLinesUsingListenerFollowDisplayInterface;
import io.fabric8.docker.dsl.container.ContainerExecResourceLogsAttachArchiveInterface;
import io.fabric8.docker.dsl.container.SinceContainerOutputErrorTimestampsTailingLinesUsingListenerFollowDisplayInterface;
import io.fabric8.docker.dsl.container.TimestampsTailingLinesUsingListenerFollowDisplayInterface;
import io.fabric8.docker.dsl.image.ImageInspectPullHistoryPushTagDeleteGetLoadInterface;
import io.fabric8.docker.dsl.image.RedirectingWritingOutputTagFromRegistryInterface;
import io.fabric8.docker.dsl.image.UsingListenerRedirectingWritingOutputTagFromRegistryInterface;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ContainerStartExample {
    public static void main(String[] args) throws InterruptedException, IOException {
        if (args.length < 2) {
            System.err.println("Usage: ContainerInspectExample <docker url>");
            System.err.println("Optionally: ContainerStartExample <docker url> <image>");
            return;
        }
        String dockerUrl = args[0];
        String image = args[1];
        EditableConfig config = ((ConfigBuilder)new ConfigBuilder().withDockerUrl(dockerUrl)).build();
        try (DefaultDockerClient client = new DefaultDockerClient((Config)config);){
            ContainerCreateResponse container;
            block41: {
                final CountDownLatch latch = new CountDownLatch(1);
                try (OutputHandle pullHandle = (OutputHandle)((RedirectingWritingOutputTagFromRegistryInterface)((UsingListenerRedirectingWritingOutputTagFromRegistryInterface)((ImageInspectPullHistoryPushTagDeleteGetLoadInterface)client.image().withName(image)).pull()).usingListener(new EventListener(){

                    public void onSuccess(String message) {
                        latch.countDown();
                    }

                    public void onError(String message) {
                        latch.countDown();
                    }

                    public void onError(Throwable t) {
                        latch.countDown();
                    }

                    public void onEvent(String event) {
                        System.out.println(event);
                    }
                })).fromRegistry();){
                    if (!latch.await(5L, TimeUnit.MINUTES)) {
                        throw new DockerClientException("Failed to pull image [" + image + "]");
                    }
                }
                container = ((InlineContainerCreate)((InlineContainerCreate)((InlineContainerCreate)client.container().createNew()).withName("example")).withImage(image)).done();
                try (OutputHandle logHandle = (OutputHandle)((TimestampsTailingLinesUsingListenerFollowDisplayInterface)((ContainerErrorTimestampsTailingLinesUsingListenerFollowDisplayInterface)((SinceContainerOutputErrorTimestampsTailingLinesUsingListenerFollowDisplayInterface)((ContainerExecResourceLogsAttachArchiveInterface)client.container().withName(container.getId())).logs()).writingOutput((OutputStream)System.out)).writingError((OutputStream)System.err)).display();){
                    if (!((Boolean)((ContainerExecResourceLogsAttachArchiveInterface)client.container().withName(container.getId())).start()).booleanValue()) {
                        throw new DockerClientException("Failed to start container.");
                    }
                    System.out.println("Container started!");
                    if (((Boolean)((ContainerExecResourceLogsAttachArchiveInterface)client.container().withName(container.getId())).stop()).booleanValue()) {
                        System.out.println("Container stopped!");
                        break block41;
                    }
                    throw new DockerClientException("Failed to stop container.");
                }
            }
            ((ContainerExecResourceLogsAttachArchiveInterface)client.container().withName(container.getId())).remove();
        }
    }
}

