/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.examples;

import io.fabric8.docker.api.model.ContainerCreateResponse;
import io.fabric8.docker.api.model.ContainerExecCreateResponse;
import io.fabric8.docker.api.model.EditableExecConfig;
import io.fabric8.docker.api.model.ExecConfig;
import io.fabric8.docker.api.model.ExecConfigBuilder;
import io.fabric8.docker.api.model.InlineContainerCreate;
import io.fabric8.docker.client.Config;
import io.fabric8.docker.client.ConfigBuilder;
import io.fabric8.docker.client.DefaultDockerClient;
import io.fabric8.docker.client.DockerClientException;
import io.fabric8.docker.client.EditableConfig;
import io.fabric8.docker.dsl.container.ContainerExecResourceLogsAttachArchiveInterface;
import io.fabric8.docker.dsl.container.ContainerExecResourceOutputErrorUsingListenerInterface;
import io.fabric8.docker.dsl.container.NoOverwriteDirNonDownloadFromHostResourceTarInputStreamInterface;
import io.fabric8.docker.dsl.container.UploadToDownloadFromHostResourceTarInputStreamInterface;
import java.io.IOException;

public class ContainerUploadToExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException, IOException {
        if (args.length < 2) {
            System.err.println("Usage: ContainerLogsExample <docker url>");
            System.err.println("Optionally: ContainerLogsExample <docker url> <container id>");
            return;
        }
        String dockerUrl = args[0];
        String image = args[1];
        EditableConfig config = ((ConfigBuilder)new ConfigBuilder().withDockerUrl(dockerUrl)).build();
        try (DefaultDockerClient client = new DefaultDockerClient((Config)config);){
            ContainerCreateResponse container = ((InlineContainerCreate)((InlineContainerCreate)((InlineContainerCreate)client.container().createNew()).withName("example")).withImage(image)).done();
            if (!((Boolean)((ContainerExecResourceLogsAttachArchiveInterface)client.container().withName(container.getId())).start()).booleanValue()) {
                throw new DockerClientException("Failed to start container.");
            }
            System.out.println("Container started!");
            String[] commands = new String[]{"sh", "-c", "mkdir /upload"};
            EditableExecConfig execConfig = ((ExecConfigBuilder)((ExecConfigBuilder)new ExecConfigBuilder().addToCmd(commands)).withDetach(Boolean.valueOf(true))).build();
            ContainerExecCreateResponse exec = (ContainerExecCreateResponse)((ContainerExecResourceLogsAttachArchiveInterface)client.container().withName(container.getId())).exec((ExecConfig)execConfig);
            ((ContainerExecResourceOutputErrorUsingListenerInterface)client.exec().withName(exec.getId())).start();
            ((NoOverwriteDirNonDownloadFromHostResourceTarInputStreamInterface)((UploadToDownloadFromHostResourceTarInputStreamInterface)((ContainerExecResourceLogsAttachArchiveInterface)client.container().withName(container.getId())).archive()).uploadTo(".")).withHostResource("examples/readme.md");
            if (!((Boolean)((ContainerExecResourceLogsAttachArchiveInterface)client.container().withName(container.getId())).stop()).booleanValue()) {
                throw new DockerClientException("Failed to stop container.");
            }
            System.out.println("Container stopped!");
            ((ContainerExecResourceLogsAttachArchiveInterface)client.container().withName(container.getId())).remove();
        }
    }
}

