/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.examples;

import io.fabric8.docker.client.Config;
import io.fabric8.docker.client.ConfigBuilder;
import io.fabric8.docker.client.DefaultDockerClient;
import io.fabric8.docker.client.EditableConfig;
import io.fabric8.docker.dsl.EventListener;
import io.fabric8.docker.dsl.OutputHandle;
import io.fabric8.docker.dsl.image.RedirectingWritingOutputFromPathInterface;
import io.fabric8.docker.dsl.image.RepositoryNameSupressingVerboseOutputNoCachePullingRemoveIntermediateMemorySwapCpuSharesCpusPeriodQuotaBuildArgsUsingDockerFileListenerRedirectingWritingFromPathInterface;
import io.fabric8.docker.dsl.image.SupressingVerboseOutputNoCachePullingRemoveIntermediateMemorySwapCpuSharesCpusPeriodQuotaBuildArgsUsingDockerFileListenerRedirectingWritingFromPathInterface;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;

public class ImageBuildExample {
    private static final String DEFAULT_IMAGE = "image1";
    private static final String DEFAULT_IMAGE_PATH = ImageBuildExample.class.getClassLoader().getResource("image1").getFile();

    public static void main(String[] args) throws InterruptedException, IOException {
        if (args.length == 0) {
            System.err.println("Usage: ImageBuildExample <docker url>");
            System.err.println("Optionally: ImageBuildExample <docker url> <image name> <path to image>");
            return;
        }
        String dockerUrl = args[0];
        String image = args.length >= 2 ? args[1] : DEFAULT_IMAGE;
        String imageFolder = args.length >= 3 ? args[2] : DEFAULT_IMAGE_PATH;
        EditableConfig config = ((ConfigBuilder)new ConfigBuilder().withDockerUrl(dockerUrl)).build();
        DefaultDockerClient client = new DefaultDockerClient((Config)config);
        final CountDownLatch buildDone = new CountDownLatch(1);
        OutputHandle handle = (OutputHandle)((RedirectingWritingOutputFromPathInterface)((SupressingVerboseOutputNoCachePullingRemoveIntermediateMemorySwapCpuSharesCpusPeriodQuotaBuildArgsUsingDockerFileListenerRedirectingWritingFromPathInterface)((RepositoryNameSupressingVerboseOutputNoCachePullingRemoveIntermediateMemorySwapCpuSharesCpusPeriodQuotaBuildArgsUsingDockerFileListenerRedirectingWritingFromPathInterface)client.image().build()).withRepositoryName(image)).usingListener(new EventListener(){

            public void onSuccess(String message) {
                System.out.println("Success:" + message);
                buildDone.countDown();
            }

            public void onError(String messsage) {
                System.err.println("Failure:" + messsage);
                buildDone.countDown();
            }

            public void onError(Throwable t) {
                t.printStackTrace(System.err);
                buildDone.countDown();
            }

            public void onEvent(String event) {
                System.out.println(event);
            }
        })).fromFolder(imageFolder);
        buildDone.await();
        handle.close();
        client.close();
    }
}

