/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.examples;

import io.fabric8.docker.api.model.ImageDelete;
import io.fabric8.docker.client.Config;
import io.fabric8.docker.client.ConfigBuilder;
import io.fabric8.docker.client.DefaultDockerClient;
import io.fabric8.docker.client.EditableConfig;
import io.fabric8.docker.client.utils.Utils;
import io.fabric8.docker.dsl.image.AndPruneNoInterface;
import io.fabric8.docker.dsl.image.ForceAndPruneNoInterface;
import io.fabric8.docker.dsl.image.ImageInspectPullHistoryPushTagDeleteGetLoadInterface;
import java.io.IOException;
import java.util.List;

public class ImageDeleteExample {
    private static final String DEFAULT_IMAGE = "image1";

    public static void main(String[] args) throws InterruptedException, IOException {
        if (args.length == 0) {
            System.err.println("Usage: ImagePushExample <docker url>");
            System.err.println("Optionally: ImageDeleteExample <docker url> <image name>");
            return;
        }
        String dockerUrl = args[0];
        String image = args.length >= 2 ? args[1] : DEFAULT_IMAGE;
        EditableConfig config = ((ConfigBuilder)new ConfigBuilder().withDockerUrl(dockerUrl)).build();
        DefaultDockerClient client = new DefaultDockerClient((Config)config);
        List imageDeleteList = (List)((AndPruneNoInterface)((ForceAndPruneNoInterface)((ImageInspectPullHistoryPushTagDeleteGetLoadInterface)client.image().withName(image)).delete()).force()).andPrune();
        for (ImageDelete imageDelete : imageDeleteList) {
            if (Utils.isNotNullOrEmpty((String)imageDelete.getDeleted())) {
                System.out.println("Deleted:" + imageDelete.getDeleted());
            }
            if (!Utils.isNotNullOrEmpty((String)imageDelete.getUntagged())) continue;
            System.out.println("Untagged:" + imageDelete.getUntagged());
        }
        client.close();
    }
}

