/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.examples;

import io.fabric8.docker.client.Config;
import io.fabric8.docker.client.ConfigBuilder;
import io.fabric8.docker.client.DefaultDockerClient;
import io.fabric8.docker.client.EditableConfig;
import io.fabric8.docker.dsl.EventListener;
import io.fabric8.docker.dsl.OutputHandle;
import io.fabric8.docker.dsl.image.ForceTagNameInterface;
import io.fabric8.docker.dsl.image.ForceToRegistryInterface;
import io.fabric8.docker.dsl.image.ImageInspectPullHistoryPushTagDeleteGetLoadInterface;
import io.fabric8.docker.dsl.image.InRepositoryForceTagNameInterface;
import io.fabric8.docker.dsl.image.RedirectingWritingOutputTagForceToRegistryInterface;
import io.fabric8.docker.dsl.image.UsingListenerRedirectingWritingOutputTagForceToRegistryInterface;
import io.fabric8.docker.dsl.image.WithTagNameInterface;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;

public class ImagePushExample {
    private static final String DEFAULT_IMAGE = "image1";
    private static final String DEFAULT_IMAGE_PATH = ImagePushExample.class.getClassLoader().getResource("image1").getFile();

    public static void main(String[] args) throws InterruptedException, IOException {
        if (args.length == 0) {
            System.err.println("Usage: ImagePushExample <docker url>");
            System.err.println("Optionally: ImagePushExample <docker url> <registry> <registry>");
            return;
        }
        String dockerUrl = args[0];
        String image = args.length >= 2 ? args[1] : DEFAULT_IMAGE;
        String registry = args.length >= 3 ? args[2] : "index.docker.io";
        String namespace = args.length >= 4 ? args[3] : "default";
        String repositoryName = registry + "/" + namespace + "/" + image;
        EditableConfig config = ((ConfigBuilder)new ConfigBuilder().withDockerUrl(dockerUrl)).build();
        DefaultDockerClient client = new DefaultDockerClient((Config)config);
        CountDownLatch buildDone = new CountDownLatch(1);
        final CountDownLatch pushDone = new CountDownLatch(1);
        ((WithTagNameInterface)((ForceTagNameInterface)((InRepositoryForceTagNameInterface)((ImageInspectPullHistoryPushTagDeleteGetLoadInterface)client.image().withName(image)).tag()).inRepository(repositoryName)).force()).withTagName("1.0");
        OutputHandle handle = (OutputHandle)((ForceToRegistryInterface)((RedirectingWritingOutputTagForceToRegistryInterface)((UsingListenerRedirectingWritingOutputTagForceToRegistryInterface)((ImageInspectPullHistoryPushTagDeleteGetLoadInterface)client.image().withName(repositoryName)).push()).usingListener(new EventListener(){

            public void onSuccess(String message) {
                System.out.println("Success:" + message);
                pushDone.countDown();
            }

            public void onError(String messsage) {
                System.err.println("Failure:" + messsage);
                pushDone.countDown();
            }

            public void onError(Throwable t) {
                t.printStackTrace(System.err);
                pushDone.countDown();
            }

            public void onEvent(String event) {
                System.out.println(event);
            }
        })).withTag("1.0")).toRegistry();
        pushDone.await();
        handle.close();
        client.close();
    }
}

