/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.examples;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Main {
    public static void main(String[] args) throws InterruptedException, IOException {
        if (args.length == 0) {
            System.err.println("Usage: Main <example name> <arguments>");
            System.err.println("Example: Main ImageBuilder http://localhost:2375 myImage /some/path docker.io myns");
            System.err.println("Optionally: ImagePushExample <docker url> <repo name> <path> <registry> <namespace>");
            return;
        }
        String exampleName = args[0];
        try {
            Class<?> example = Class.forName(Main.class.getPackage().getName() + "." + exampleName);
            String[] exampleArgs = new String[args.length - 1];
            System.arraycopy(args, 1, exampleArgs, 0, args.length - 1);
            Method mainMethod = example.getDeclaredMethod("main", String[].class);
            mainMethod.invoke(example.newInstance(), new Object[]{exampleArgs});
        }
        catch (ClassNotFoundException e) {
            System.err.println("Could not load example:" + exampleName);
        }
        catch (NoSuchMethodException e) {
            System.err.println("Could not find main method on:" + exampleName);
        }
        catch (IllegalAccessException e) {
            System.err.println("Could not access main on:" + exampleName);
        }
        catch (InstantiationException e) {
            System.err.println("Could not create instance of:" + exampleName);
        }
        catch (InvocationTargetException e) {
            System.err.println("Could not invoke main on:" + exampleName);
            e.printStackTrace(System.err);
        }
    }
}

