/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import io.fabric8.maven.docker.AbstractDockerMojo;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.config.AssemblyConfiguration;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.DockerFileUtil;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.maven.docker.util.MojoParameters;
import java.io.File;
import java.io.IOException;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenReaderFilter;

public abstract class AbstractBuildSupportMojo
extends AbstractDockerMojo {
    @Parameter
    private MavenArchiveConfiguration archive;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Component
    private MavenFileFilter mavenFileFilter;
    @Component
    private MavenReaderFilter mavenFilterReader;
    @Parameter(property="docker.pull.registry")
    private String pullRegistry;
    @Parameter(property="docker.source.dir", defaultValue="src/main/docker")
    private String sourceDirectory;
    @Parameter(property="docker.target.dir", defaultValue="target/docker")
    private String outputDirectory;

    protected MojoParameters createMojoParameters() {
        return new MojoParameters(this.session, this.project, this.archive, this.mavenFileFilter, this.mavenFilterReader, this.sourceDirectory, this.outputDirectory);
    }

    protected void buildImage(ServiceHub hub, ImageConfiguration imageConfig) throws DockerAccessException, MojoExecutionException {
        this.autoPullBaseImage(hub, imageConfig);
        MojoParameters params = this.createMojoParameters();
        hub.getBuildService().buildImage(imageConfig, params, this.checkForNocache(imageConfig));
    }

    private void autoPullBaseImage(ServiceHub hub, ImageConfiguration imageConfig) throws DockerAccessException, MojoExecutionException {
        BuildImageConfiguration buildConfig = imageConfig.getBuildConfiguration();
        String fromImage = buildConfig.getFrom();
        if (fromImage == null) {
            AssemblyConfiguration assemblyConfig = buildConfig.getAssemblyConfiguration();
            if (assemblyConfig == null) {
                fromImage = "busybox:latest";
            } else if (assemblyConfig.getDockerFileDir() != null) {
                try {
                    File dockerFileDir = EnvUtil.prepareAbsoluteSourceDirPath(this.createMojoParameters(), assemblyConfig.getDockerFileDir());
                    fromImage = DockerFileUtil.extractBaseImage(new File(dockerFileDir, "Dockerfile"));
                }
                catch (IOException e) {
                    fromImage = null;
                }
            }
        }
        if (fromImage != null) {
            String pullRegistry = EnvUtil.findRegistry(new ImageName(fromImage).getRegistry(), this.pullRegistry, this.registry);
            this.checkImageWithAutoPull(hub, fromImage, pullRegistry, true);
        }
    }

    private boolean checkForNocache(ImageConfiguration imageConfig) {
        String nocache = System.getProperty("docker.nocache");
        if (nocache != null) {
            return nocache.length() == 0 || Boolean.valueOf(nocache) != false;
        }
        BuildImageConfiguration buildConfig = imageConfig.getBuildConfiguration();
        return buildConfig.nocache();
    }
}

