/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import edu.emory.mathcs.backport.java.util.Collections;
import io.fabric8.maven.docker.AbstractDockerMojo;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.RunImageConfiguration;
import io.fabric8.maven.docker.log.LogDispatcher;
import io.fabric8.maven.docker.model.Container;
import io.fabric8.maven.docker.service.QueryService;
import io.fabric8.maven.docker.service.RunService;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.PomLabel;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="stop", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST)
public class StopMojo
extends AbstractDockerMojo {
    @Parameter(property="docker.keepRunning", defaultValue="false")
    private boolean keepRunning;

    @Override
    protected void executeInternal(ServiceHub hub) throws MojoExecutionException, DockerAccessException {
        QueryService queryService = hub.getQueryService();
        RunService runService = hub.getRunService();
        PomLabel pomLabel = this.getPomLabel();
        if (!this.keepRunning) {
            if (this.invokedTogetherWithDockerStart()) {
                runService.stopStartedContainers(this.keepContainer, this.removeVolumes, pomLabel);
            } else {
                this.stopContainers(queryService, runService, pomLabel);
            }
        }
        LogDispatcher dispatcher = this.getLogDispatcher(hub);
        dispatcher.untrackAllContainerLogs();
    }

    private void stopContainers(QueryService queryService, RunService runService, PomLabel pomLabel) throws DockerAccessException {
        for (ImageConfiguration image : this.getImages()) {
            for (Container container : this.getContainersToStop(queryService, image)) {
                if (!this.shouldStopContainer(container, pomLabel)) continue;
                runService.stopContainer(container.getId(), image, this.keepContainer, this.removeVolumes);
            }
        }
    }

    private List<Container> getContainersToStop(QueryService queryService, ImageConfiguration image) throws DockerAccessException {
        Container container;
        RunImageConfiguration.NamingStrategy strategy = image.getRunConfiguration().getNamingStrategy();
        List containers = strategy == RunImageConfiguration.NamingStrategy.alias ? ((container = queryService.getContainerByName(image.getAlias())) != null ? Collections.singletonList((Object)container) : Collections.emptyList()) : queryService.getContainersForImage(image.getName());
        return containers;
    }

    private boolean shouldStopContainer(Container container, PomLabel pomLabel) {
        if (this.isStopAllContainers()) {
            return true;
        }
        String key = pomLabel.getKey();
        Map<String, String> labels = container.getLabels();
        return labels.containsKey(key) && pomLabel.equals(new PomLabel(labels.get(key)));
    }

    private boolean isStopAllContainers() {
        for (String prop : new String[]{"docker.allContainers", "docker.sledgeHammer"}) {
            String val = System.getProperty(prop);
            if (val == null || !Boolean.valueOf(val).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean invokedTogetherWithDockerStart() {
        Boolean startCalled = (Boolean)this.getPluginContext().get("CONTEXT_KEY_DOCKER_START_CALLED");
        return startCalled != null && startCalled != false;
    }
}

