/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config;

import io.fabric8.maven.docker.config.Arguments;
import io.fabric8.maven.docker.config.AssemblyConfiguration;
import io.fabric8.maven.docker.config.BuildTarArchiveCompression;
import io.fabric8.maven.docker.util.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class BuildImageConfiguration {
    private String from;
    private String registry;
    private String maintainer;
    private List<String> ports;
    private List<String> runCmds;
    private boolean cleanup = true;
    private boolean nocache = false;
    private boolean optimise = false;
    private List<String> volumes;
    private List<String> tags;
    private Map<String, String> env;
    private Map<String, String> labels;
    private Arguments entryPoint;
    private String command;
    private String workdir;
    private Arguments cmd;
    private AssemblyConfiguration assembly;
    private boolean skip = false;
    private BuildTarArchiveCompression compression = BuildTarArchiveCompression.none;

    public String getFrom() {
        return this.from;
    }

    public String getRegistry() {
        return this.registry;
    }

    public String getMaintainer() {
        return this.maintainer;
    }

    public String getWorkdir() {
        return this.workdir;
    }

    public AssemblyConfiguration getAssemblyConfiguration() {
        return this.assembly;
    }

    public List<String> getPorts() {
        return this.ports;
    }

    public List<String> getVolumes() {
        return this.volumes != null ? this.volumes : Collections.emptyList();
    }

    public List<String> getTags() {
        return this.tags != null ? this.tags : Collections.emptyList();
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Arguments getCmd() {
        return this.cmd;
    }

    @Deprecated
    public String getCommand() {
        return this.command;
    }

    public boolean cleanup() {
        return this.cleanup;
    }

    public boolean nocache() {
        return this.nocache;
    }

    public boolean optimise() {
        return this.optimise;
    }

    public boolean skip() {
        return this.skip;
    }

    public BuildTarArchiveCompression getCompression() {
        return this.compression;
    }

    public Arguments getEntryPoint() {
        return this.entryPoint;
    }

    public List<String> getRunCmds() {
        return this.runCmds;
    }

    public String validate(Logger log) throws IllegalArgumentException {
        if (this.entryPoint != null) {
            this.entryPoint.validate();
        }
        if (this.cmd != null) {
            this.cmd.validate();
        }
        if (this.command != null) {
            log.warn("<command> in the <build> configuration is deprecated and will be be removed soon");
            log.warn("Please use <cmd> with nested <shell> or <exec> sections instead.");
            log.warn("");
            log.warn("More on this is explained in the user manual: ");
            log.warn("https://github.com/fabric8io/docker-maven-plugin/blob/master/doc/manual.md#start-up-arguments");
            log.warn("");
            log.warn("Migration is trivial, see changelog to version 0.12.0 -->");
            log.warn("https://github.com/fabric8io/docker-maven-plugin/blob/master/doc/changelog.md");
            log.warn("");
            log.warn("For now, the command is automatically translated for you to the shell form:");
            log.warn("   <cmd>" + this.command + "</cmd>");
        }
        return null;
    }

    public static class Builder {
        private final BuildImageConfiguration config = new BuildImageConfiguration();

        public Builder from(String from) {
            this.config.from = from;
            return this;
        }

        public Builder registry(String registry) {
            this.config.registry = registry;
            return this;
        }

        public Builder maintainer(String maintainer) {
            this.config.maintainer = maintainer;
            return this;
        }

        public Builder workdir(String workdir) {
            this.config.workdir = workdir;
            return this;
        }

        public Builder assembly(AssemblyConfiguration assembly) {
            this.config.assembly = assembly;
            return this;
        }

        public Builder ports(List<String> ports) {
            this.config.ports = ports;
            return this;
        }

        public Builder runCmds(List<String> theCmds) {
            if (this.config.runCmds == null) {
                this.config.runCmds = new ArrayList();
            } else {
                this.config.runCmds = theCmds;
            }
            return this;
        }

        public Builder volumes(List<String> volumes) {
            this.config.volumes = volumes;
            return this;
        }

        public Builder tags(List<String> tags) {
            this.config.tags = tags;
            return this;
        }

        public Builder env(Map<String, String> env) {
            this.config.env = env;
            return this;
        }

        public Builder labels(Map<String, String> labels) {
            this.config.labels = labels;
            return this;
        }

        public Builder cmd(String cmd) {
            if (this.config.cmd == null) {
                this.config.cmd = new Arguments();
            }
            this.config.cmd.setShell(cmd);
            return this;
        }

        public Builder cleanup(String cleanup) {
            if (cleanup != null) {
                this.config.cleanup = Boolean.valueOf(cleanup);
            }
            return this;
        }

        public Builder nocache(String nocache) {
            if (nocache != null) {
                this.config.nocache = Boolean.valueOf(nocache);
            }
            return this;
        }

        public Builder optimise(String optimise) {
            if (optimise != null) {
                this.config.optimise = Boolean.valueOf(optimise);
            }
            return this;
        }

        public Builder entryPoint(String entryPoint) {
            if (this.config.entryPoint == null) {
                this.config.entryPoint = new Arguments();
            }
            this.config.entryPoint.setShell(entryPoint);
            return this;
        }

        public Builder skip(String skip) {
            if (skip != null) {
                this.config.skip = Boolean.valueOf(skip);
            }
            return this;
        }

        public BuildImageConfiguration build() {
            return this.config;
        }
    }
}

