/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import com.google.common.collect.ImmutableMap;
import io.fabric8.maven.docker.AbstractDockerMojo;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.config.AssemblyConfiguration;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.DockerFileUtil;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.maven.docker.util.MojoParameters;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenReaderFilter;

public abstract class AbstractBuildSupportMojo
extends AbstractDockerMojo {
    @Parameter
    private MavenArchiveConfiguration archive;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Component
    private MavenFileFilter mavenFileFilter;
    @Component
    private MavenReaderFilter mavenFilterReader;
    @Parameter(property="docker.pull.registry")
    private String pullRegistry;
    @Parameter(property="docker.source.dir", defaultValue="src/main/docker")
    private String sourceDirectory;
    @Parameter(property="docker.target.dir", defaultValue="target/docker")
    private String outputDirectory;
    @Parameter(property="docker.build.args", defaultValue="")
    private String buildArgs;

    protected MojoParameters createMojoParameters() {
        return new MojoParameters(this.session, this.project, this.archive, this.mavenFileFilter, this.mavenFilterReader, this.sourceDirectory, this.outputDirectory);
    }

    protected void buildImage(ServiceHub hub, ImageConfiguration imageConfig) throws DockerAccessException, MojoExecutionException {
        this.autoPullBaseImage(hub, imageConfig);
        MojoParameters params = this.createMojoParameters();
        hub.getBuildService().buildImage(imageConfig, params, this.checkForNocache(imageConfig), this.addBuildArgs());
    }

    private Map<String, String> addBuildArgs() {
        Map<String, String> buildArgsFromProject = this.addBuildArgsFromProperties(this.project.getProperties());
        Map<String, String> buildArgsFromSystem = this.addBuildArgsFromProperties(System.getProperties());
        return ImmutableMap.builder().putAll(buildArgsFromProject).putAll(buildArgsFromSystem).build();
    }

    private Map<String, String> addBuildArgsFromProperties(Properties properties) {
        String argPrefix = "docker.buildArg.";
        HashMap<String, String> buildArgs = new HashMap<String, String>();
        for (Object keyObj : properties.keySet()) {
            String key = (String)keyObj;
            if (!key.startsWith(argPrefix)) continue;
            String argKey = key.replaceFirst(argPrefix, "");
            buildArgs.put(argKey, properties.getProperty(key));
        }
        this.log.debug("Build args set %s", buildArgs);
        return buildArgs;
    }

    private void autoPullBaseImage(ServiceHub hub, ImageConfiguration imageConfig) throws DockerAccessException, MojoExecutionException {
        BuildImageConfiguration buildConfig = imageConfig.getBuildConfiguration();
        String fromImage = buildConfig.isDockerFileMode() ? this.extractBaseFromDockerfile(buildConfig) : this.extractBaseFromConfiguration(buildConfig);
        if (fromImage != null) {
            String pullRegistry = EnvUtil.findRegistry(new ImageName(fromImage).getRegistry(), this.pullRegistry, this.registry);
            this.checkImageWithAutoPull(hub, fromImage, pullRegistry, true);
        }
    }

    private String extractBaseFromConfiguration(BuildImageConfiguration buildConfig) {
        AssemblyConfiguration assemblyConfig;
        String fromImage = buildConfig.getFrom();
        if (fromImage == null && (assemblyConfig = buildConfig.getAssemblyConfiguration()) == null) {
            fromImage = "busybox:latest";
        }
        return fromImage;
    }

    private String extractBaseFromDockerfile(BuildImageConfiguration buildConfig) {
        String fromImage;
        try {
            File fullDockerFilePath = buildConfig.getAbsoluteDockerFilePath(this.createMojoParameters());
            fromImage = DockerFileUtil.extractBaseImage(fullDockerFilePath);
        }
        catch (IOException e) {
            fromImage = null;
        }
        return fromImage;
    }

    private boolean checkForNocache(ImageConfiguration imageConfig) {
        String nocache = System.getProperty("docker.nocache");
        if (nocache != null) {
            return nocache.length() == 0 || Boolean.valueOf(nocache) != false;
        }
        BuildImageConfiguration buildConfig = imageConfig.getBuildConfiguration();
        return buildConfig.nocache();
    }
}

