/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import io.fabric8.maven.docker.AbstractBuildSupportMojo;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.SourceMode;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.MojoParameters;
import java.io.File;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="source", defaultPhase=LifecyclePhase.PACKAGE)
@Execute(phase=LifecyclePhase.PACKAGE)
public class SourceMojo
extends AbstractBuildSupportMojo {
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter
    private SourceMode sourceMode = SourceMode.first;

    @Override
    protected void executeInternal(ServiceHub hub) throws DockerAccessException, MojoExecutionException {
        MojoParameters params = this.createMojoParameters();
        ArrayList<ImageConfiguration> imageConfigs = new ArrayList<ImageConfiguration>();
        for (ImageConfiguration imageConfig : this.getResolvedImages()) {
            BuildImageConfiguration buildConfig = imageConfig.getBuildConfiguration();
            if (buildConfig == null) continue;
            if (buildConfig.skip()) {
                this.log.info("%s: Skipped creating source", imageConfig.getDescription());
                continue;
            }
            imageConfigs.add(imageConfig);
        }
        if (this.sourceMode == SourceMode.first && imageConfigs.size() > 0) {
            ImageConfiguration imageConfig = (ImageConfiguration)imageConfigs.get(0);
            File dockerTar = hub.getArchiveService().createDockerBuildArchive(imageConfig, params);
            this.projectHelper.attachArtifact(this.project, this.getArchiveType(imageConfig), this.getClassifier(null), dockerTar);
        } else {
            for (ImageConfiguration imageConfig : imageConfigs) {
                File dockerTar = hub.getArchiveService().createDockerBuildArchive(imageConfig, params);
                String alias = imageConfig.getAlias();
                if (alias == null) {
                    throw new IllegalArgumentException("Image " + imageConfig.getDescription() + " must have an 'alias' configured to be " + "used as a classifier for attaching a docker build tar as source to the maven build");
                }
                this.projectHelper.attachArtifact(this.project, this.getArchiveType(imageConfig), this.getClassifier(alias), dockerTar);
            }
        }
    }

    private String getClassifier(String alias) {
        String packaging = this.project.getPackaging();
        if ("docker-tar".equalsIgnoreCase(packaging)) {
            return alias;
        }
        return "docker" + (alias != null ? "-" + alias : "");
    }

    private String getArchiveType(ImageConfiguration imageConfig) {
        return imageConfig.getBuildConfiguration().getCompression().getFileSuffix();
    }

    @Override
    protected boolean isDockerAccessRequired() {
        return false;
    }
}

