/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.wait;

import io.fabric8.maven.docker.wait.WaitChecker;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TcpPortChecker
implements WaitChecker {
    private static final int TCP_PING_TIMEOUT = 500;
    private final List<Integer> ports;
    private final List<InetSocketAddress> pending;

    public TcpPortChecker(String host, List<Integer> ports) {
        this.ports = ports;
        this.pending = new ArrayList<InetSocketAddress>();
        for (int port : ports) {
            this.pending.add(new InetSocketAddress(host, port));
        }
    }

    public List<Integer> getPorts() {
        return this.ports;
    }

    public List<InetSocketAddress> getPending() {
        return this.pending;
    }

    @Override
    public boolean check() {
        Iterator<InetSocketAddress> iter = this.pending.iterator();
        while (iter.hasNext()) {
            InetSocketAddress address = iter.next();
            try {
                Socket s = new Socket();
                s.connect(address, 500);
                s.close();
                iter.remove();
            }
            catch (IOException iOException) {}
        }
        return this.pending.isEmpty();
    }

    @Override
    public void cleanUp() {
    }
}

