/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.assembly;

import io.fabric8.maven.docker.assembly.AllFilesExecCustomizer;
import io.fabric8.maven.docker.assembly.ArchiverCustomizer;
import io.fabric8.maven.docker.assembly.AssemblyFiles;
import io.fabric8.maven.docker.assembly.BuildDirs;
import io.fabric8.maven.docker.assembly.DockerAssemblyConfigurationSource;
import io.fabric8.maven.docker.assembly.DockerFileBuilder;
import io.fabric8.maven.docker.assembly.MappingTrackArchiver;
import io.fabric8.maven.docker.config.ArchiveCompression;
import io.fabric8.maven.docker.config.Arguments;
import io.fabric8.maven.docker.config.AssemblyConfiguration;
import io.fabric8.maven.docker.config.AssemblyMode;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.util.DockerFileUtil;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.util.MojoParameters;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.AssemblyArchiver;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.io.AssemblyReadException;
import org.apache.maven.plugin.assembly.io.AssemblyReader;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.PathTool;
import org.apache.maven.shared.utils.io.FileUtils;
import org.codehaus.plexus.archiver.ArchivedFileSet;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.tar.TarArchiver;
import org.codehaus.plexus.archiver.tar.TarLongFileMode;
import org.codehaus.plexus.archiver.util.DefaultArchivedFileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=DockerAssemblyManager.class, instantiationStrategy="per-lookup")
public class DockerAssemblyManager {
    public static final String DEFAULT_DATA_BASE_IMAGE = "busybox:latest";
    public static final String SCRATCH_IMAGE = "scratch";
    public static final String DOCKER_IGNORE = ".maven-dockerignore";
    public static final String DOCKER_EXCLUDE = ".maven-dockerexclude";
    public static final String DOCKER_INCLUDE = ".maven-dockerinclude";
    public static final String DOCKERFILE_NAME = "Dockerfile";
    @Requirement
    private AssemblyArchiver assemblyArchiver;
    @Requirement
    private AssemblyReader assemblyReader;
    @Requirement
    private ArchiverManager archiverManager;
    @Requirement(hint="track")
    private Archiver trackArchiver;

    public File createDockerTarArchive(String imageName, MojoParameters params, BuildImageConfiguration buildConfig, Logger log) throws MojoExecutionException {
        return this.createDockerTarArchive(imageName, params, buildConfig, log, null);
    }

    public File createDockerTarArchive(String imageName, MojoParameters params, BuildImageConfiguration buildConfig, Logger log, ArchiverCustomizer finalCustomizer) throws MojoExecutionException {
        BuildDirs buildDirs = this.createBuildDirs(imageName, params);
        AssemblyConfiguration assemblyConfig = buildConfig.getAssemblyConfiguration();
        if (this.hasAssemblyConfiguration(assemblyConfig)) {
            this.createAssemblyArchive(assemblyConfig, params, buildDirs);
        }
        try {
            AssemblyConfiguration.PermissionMode mode;
            ArchiverCustomizer customizer;
            if (buildConfig.isDockerFileMode()) {
                final File dockerFile = buildConfig.getAbsoluteDockerFilePath(params);
                if (!dockerFile.exists()) {
                    throw new MojoExecutionException("Configured Dockerfile \"" + buildConfig.getDockerFile() + "\" (resolved to \"" + dockerFile + "\") doesn't exist");
                }
                this.verifyGivenDockerfile(dockerFile, buildConfig, params.getProject(), log);
                Properties interpolationProperties = new Properties();
                interpolationProperties.putAll((Map<?, ?>)params.getProject().getProperties());
                interpolationProperties.putAll((Map<?, ?>)params.getSession().getSystemProperties());
                this.interpolateDockerfile(dockerFile, buildDirs, interpolationProperties, buildConfig.getFilter());
                customizer = new ArchiverCustomizer(){

                    @Override
                    public TarArchiver customize(TarArchiver archiver) throws IOException {
                        DefaultFileSet fileSet = DefaultFileSet.fileSet((File)dockerFile.getParentFile());
                        DockerAssemblyManager.this.addDockerIgnoreIfPresent(fileSet);
                        DockerAssemblyManager.this.excludeDockerfile(fileSet, dockerFile);
                        archiver.addFileSet((FileSet)fileSet);
                        return archiver;
                    }
                };
            } else {
                DockerFileBuilder builder = this.createDockerFileBuilder(buildConfig, assemblyConfig);
                builder.write(buildDirs.getOutputDirectory());
                final File dockerFile = new File(buildDirs.getOutputDirectory(), DOCKERFILE_NAME);
                customizer = new ArchiverCustomizer(){

                    @Override
                    public TarArchiver customize(TarArchiver archiver) throws IOException {
                        archiver.addFile(dockerFile, DockerAssemblyManager.DOCKERFILE_NAME);
                        return archiver;
                    }
                };
            }
            if (assemblyConfig != null && ((mode = assemblyConfig.getPermissions()) == AssemblyConfiguration.PermissionMode.exec || mode == AssemblyConfiguration.PermissionMode.auto && EnvUtil.isWindows())) {
                customizer = new AllFilesExecCustomizer(customizer, log);
            }
            return this.createBuildTarBall(buildDirs, Arrays.asList(customizer, finalCustomizer), assemblyConfig, buildConfig.getCompression());
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Cannot create %s in %s", DOCKERFILE_NAME, buildDirs.getOutputDirectory()), (Exception)e);
        }
    }

    private void excludeDockerfile(DefaultFileSet fileSet, File dockerFile) {
        ArrayList<String> excludes = fileSet.getExcludes() != null ? new ArrayList<String>(Arrays.asList(fileSet.getExcludes())) : new ArrayList();
        excludes.add(dockerFile.getName());
        fileSet.setExcludes(excludes.toArray(new String[0]));
    }

    private void interpolateDockerfile(File dockerFile, BuildDirs params, Properties properties, String filter) throws IOException {
        File targetDockerfile = new File(params.getOutputDirectory(), dockerFile.getName());
        String dockerFileInterpolated = DockerFileUtil.interpolate(dockerFile, properties, filter);
        try (FileWriter writer = new FileWriter(targetDockerfile);){
            IOUtils.write((String)dockerFileInterpolated, (Writer)writer);
        }
    }

    private void verifyGivenDockerfile(File dockerFile, BuildImageConfiguration buildConfig, MavenProject project, Logger log) throws IOException {
        AssemblyConfiguration assemblyConfig = buildConfig.getAssemblyConfiguration();
        if (assemblyConfig != null) {
            String name = assemblyConfig.getName();
            for (String keyword : new String[]{"ADD", "COPY"}) {
                List<String[]> lines = DockerFileUtil.extractLines(dockerFile, keyword, project.getProperties(), buildConfig.getFilter());
                for (String[] line : lines) {
                    if (line[0].startsWith("#") || line.length <= 1 || !line[1].contains(name)) continue;
                    return;
                }
            }
            log.warn("Dockerfile %s does not contain an ADD or COPY directive to include assembly created at %s. Ignoring assembly.", dockerFile.getPath(), name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssemblyFiles getAssemblyFiles(String name, BuildImageConfiguration buildConfig, MojoParameters mojoParams, Logger log) throws InvalidAssemblerConfigurationException, ArchiveCreationException, AssemblyFormattingException, MojoExecutionException {
        BuildDirs buildDirs = this.createBuildDirs(name, mojoParams);
        AssemblyConfiguration assemblyConfig = buildConfig.getAssemblyConfiguration();
        String assemblyName = assemblyConfig.getName();
        DockerAssemblyConfigurationSource source = new DockerAssemblyConfigurationSource(mojoParams, buildDirs, assemblyConfig);
        Assembly assembly = this.getAssemblyConfig(assemblyConfig, source);
        Archiver archiver = this.trackArchiver;
        synchronized (archiver) {
            MappingTrackArchiver ta = (MappingTrackArchiver)this.trackArchiver;
            ta.init(log, assemblyName);
            assembly.setId("tracker");
            this.assemblyArchiver.createArchive(assembly, assemblyName, "track", (AssemblerConfigurationSource)source, false);
            return ta.getAssemblyFiles(mojoParams.getSession());
        }
    }

    private BuildDirs createBuildDirs(String imageName, MojoParameters params) {
        BuildDirs buildDirs = new BuildDirs(imageName, params);
        buildDirs.createDirs();
        return buildDirs;
    }

    private boolean hasAssemblyConfiguration(AssemblyConfiguration assemblyConfig) {
        return assemblyConfig != null && (assemblyConfig.getInline() != null || assemblyConfig.getDescriptor() != null || assemblyConfig.getDescriptorRef() != null);
    }

    public File createChangedFilesArchive(List<AssemblyFiles.Entry> entries, File assemblyDirectory, String imageName, MojoParameters mojoParameters) throws MojoExecutionException {
        BuildDirs dirs = this.createBuildDirs(imageName, mojoParameters);
        try {
            File archive = new File(dirs.getTemporaryRootDirectory(), "changed-files.tar");
            File archiveDir = this.createArchiveDir(dirs);
            for (AssemblyFiles.Entry entry : entries) {
                File dest = this.prepareChangedFilesArchivePath(archiveDir, entry.getDestFile(), assemblyDirectory);
                FileUtils.copyFile((File)entry.getSrcFile(), (File)dest);
            }
            return this.createChangedFilesTarBall(archive, archiveDir);
        }
        catch (IOException exp) {
            throw new MojoExecutionException("Error while creating " + dirs.getTemporaryRootDirectory() + "/changed-files.tar: " + exp);
        }
    }

    private File prepareChangedFilesArchivePath(File archiveDir, File destFile, File assemblyDir) throws IOException {
        String relativePath = PathTool.getRelativeFilePath((String)assemblyDir.getCanonicalPath(), (String)destFile.getCanonicalPath());
        return new File(archiveDir, relativePath);
    }

    private File createBuildTarBall(BuildDirs buildDirs, List<ArchiverCustomizer> archiverCustomizers, AssemblyConfiguration assemblyConfig, ArchiveCompression compression) throws MojoExecutionException {
        File archive = new File(buildDirs.getTemporaryRootDirectory(), "docker-build." + compression.getFileSuffix());
        try {
            TarArchiver archiver = this.createBuildArchiver(buildDirs.getOutputDirectory(), archive, assemblyConfig);
            for (ArchiverCustomizer customizer : archiverCustomizers) {
                if (customizer == null) continue;
                archiver = customizer.customize(archiver);
            }
            archiver.setCompression(compression.getTarCompressionMethod());
            archiver.createArchive();
            return archive;
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("No archiver for type 'tar' found", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot create archive " + archive, (Exception)e);
        }
    }

    private void addDockerIgnoreIfPresent(DefaultFileSet fileSet) throws IOException {
        File directory = fileSet.getDirectory();
        this.addDockerExcludes(fileSet, directory);
        this.addDockerIncludes(fileSet, directory);
    }

    private void addDockerExcludes(DefaultFileSet fileSet, File directory) throws IOException {
        for (String file : new String[]{DOCKER_EXCLUDE, DOCKER_IGNORE}) {
            File dockerIgnore = new File(directory, file);
            if (!dockerIgnore.exists()) continue;
            ArrayList<String> excludes = new ArrayList<String>(Arrays.asList(FileUtils.fileReadArray((File)dockerIgnore)));
            excludes.add(DOCKER_IGNORE);
            fileSet.setExcludes(excludes.toArray(new String[excludes.size()]));
        }
    }

    private void addDockerIncludes(DefaultFileSet fileSet, File directory) throws IOException {
        File dockerInclude = new File(directory, DOCKER_INCLUDE);
        if (dockerInclude.exists()) {
            ArrayList<String> includes = new ArrayList<String>(Arrays.asList(FileUtils.fileReadArray((File)dockerInclude)));
            fileSet.setIncludes(includes.toArray(new String[includes.size()]));
        }
    }

    private File createChangedFilesTarBall(File archive, File archiveDir) throws MojoExecutionException {
        try {
            TarArchiver archiver = (TarArchiver)this.archiverManager.getArchiver("tar");
            archiver.setLongfile(TarLongFileMode.posix);
            archiver.addFileSet((FileSet)DefaultFileSet.fileSet((File)archiveDir));
            archiver.setDestFile(archive);
            archiver.createArchive();
            return archive;
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("No archiver for type 'tar' found", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot create archive " + archive, (Exception)e);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private File createArchiveDir(BuildDirs dirs) throws IOException, MojoExecutionException {
        File archiveDir = new File(dirs.getTemporaryRootDirectory(), "changed-files");
        if (archiveDir.exists()) {
            FileUtils.cleanDirectory((File)archiveDir);
        } else if (!archiveDir.mkdir()) {
            throw new MojoExecutionException("Cannot create " + archiveDir);
        }
        return archiveDir;
    }

    private TarArchiver createBuildArchiver(File outputDir, File archive, AssemblyConfiguration assemblyConfig) throws NoSuchArchiverException {
        AssemblyMode mode;
        TarArchiver archiver = (TarArchiver)this.archiverManager.getArchiver("tar");
        archiver.setLongfile(TarLongFileMode.posix);
        AssemblyMode assemblyMode = mode = assemblyConfig != null ? assemblyConfig.getMode() : null;
        if (mode != null && mode.isArchive()) {
            DefaultArchivedFileSet archiveSet = DefaultArchivedFileSet.archivedFileSet((File)new File(outputDir, assemblyConfig.getName() + "." + mode.getExtension()));
            archiveSet.setPrefix((Object)((Object)mode) + "/");
            archiveSet.setIncludingEmptyDirectories(true);
            archiveSet.setUsingDefaultExcludes(false);
            archiver.addArchivedFileSet((ArchivedFileSet)archiveSet);
        } else {
            DefaultFileSet fileSet = DefaultFileSet.fileSet((File)outputDir);
            fileSet.setUsingDefaultExcludes(false);
            archiver.addFileSet((FileSet)fileSet);
        }
        archiver.setDestFile(archive);
        return archiver;
    }

    DockerFileBuilder createDockerFileBuilder(BuildImageConfiguration buildConfig, AssemblyConfiguration assemblyConfig) {
        DockerFileBuilder builder = new DockerFileBuilder().env(buildConfig.getEnv()).labels(buildConfig.getLabels()).expose(buildConfig.getPorts()).run(buildConfig.getRunCmds()).volumes(buildConfig.getVolumes()).user(buildConfig.getUser());
        if (buildConfig.getMaintainer() != null) {
            builder.maintainer(buildConfig.getMaintainer());
        }
        if (buildConfig.getWorkdir() != null) {
            builder.workdir(buildConfig.getWorkdir());
        }
        if (assemblyConfig != null) {
            builder.add(assemblyConfig.getName(), "").basedir(assemblyConfig.getTargetDir()).assemblyUser(assemblyConfig.getUser()).exportTargetDir(assemblyConfig.exportTargetDir());
        } else {
            builder.exportTargetDir(false);
        }
        builder.baseImage(buildConfig.getFrom());
        if (buildConfig.getHealthCheck() != null) {
            builder.healthCheck(buildConfig.getHealthCheck());
        }
        if (buildConfig.getCmd() != null) {
            builder.cmd(buildConfig.getCmd());
        } else if (buildConfig.getCommand() != null) {
            Arguments args = Arguments.Builder.get().withShell(buildConfig.getCommand()).build();
            builder.cmd(args);
        }
        if (buildConfig.getEntryPoint() != null) {
            builder.entryPoint(buildConfig.getEntryPoint());
        }
        if (buildConfig.optimise()) {
            builder.optimise();
        }
        return builder;
    }

    private void createAssemblyArchive(AssemblyConfiguration assemblyConfig, MojoParameters params, BuildDirs buildDirs) throws MojoExecutionException {
        DockerAssemblyConfigurationSource source = new DockerAssemblyConfigurationSource(params, buildDirs, assemblyConfig);
        Assembly assembly = this.getAssemblyConfig(assemblyConfig, source);
        AssemblyMode buildMode = assemblyConfig.getMode();
        File originalArtifactFile = null;
        try {
            originalArtifactFile = this.ensureThatArtifactFileIsSet(params.getProject());
            assembly.setId("docker");
            this.assemblyArchiver.createArchive(assembly, assemblyConfig.getName(), buildMode.getExtension(), (AssemblerConfigurationSource)source, false);
        }
        catch (ArchiveCreationException | AssemblyFormattingException e) {
            String error = "Failed to create assembly for docker image  (with mode '" + (Object)((Object)buildMode) + "'): " + e.getMessage() + ".";
            if (params.getProject().getArtifact().getFile() == null) {
                error = error + " If you include the build artifact please ensure that you have built the artifact before with 'mvn package' (should be available in the target/ dir). Please see the documentation (section \"Assembly\") for more information.";
            }
            throw new MojoExecutionException(error, (Exception)e);
        }
        catch (InvalidAssemblerConfigurationException e) {
            throw new MojoExecutionException((Object)assembly, "Assembly is incorrectly configured: " + assembly.getId(), "Assembly: " + assembly.getId() + " is not configured correctly: " + e.getMessage());
        }
        finally {
            this.setArtifactFile(params.getProject(), originalArtifactFile);
        }
    }

    private File ensureThatArtifactFileIsSet(MavenProject project) {
        Artifact artifact = project.getArtifact();
        if (artifact == null) {
            return null;
        }
        File oldFile = artifact.getFile();
        if (oldFile != null) {
            return oldFile;
        }
        Build build = project.getBuild();
        if (build == null) {
            return null;
        }
        String finalName = build.getFinalName();
        String target = build.getDirectory();
        if (finalName == null || target == null) {
            return null;
        }
        File artifactFile = new File(target, finalName + "." + project.getPackaging());
        if (artifactFile.exists() && artifactFile.isFile()) {
            this.setArtifactFile(project, artifactFile);
        }
        return null;
    }

    private void setArtifactFile(MavenProject project, File artifactFile) {
        Artifact artifact = project.getArtifact();
        if (artifact != null) {
            artifact.setFile(artifactFile);
        }
    }

    private Assembly getAssemblyConfig(AssemblyConfiguration assemblyConfig, DockerAssemblyConfigurationSource source) throws MojoExecutionException {
        Assembly assembly = assemblyConfig.getInline();
        if (assembly == null) {
            assembly = this.extractAssembly(source);
        }
        return assembly;
    }

    private Assembly extractAssembly(AssemblerConfigurationSource config) throws MojoExecutionException {
        try {
            List assemblies = this.assemblyReader.readAssemblies(config);
            if (assemblies.size() != 1) {
                throw new MojoExecutionException("Only one assembly can be used for creating a Docker base image (and not " + assemblies.size() + ")");
            }
            return (Assembly)assemblies.get(0);
        }
        catch (AssemblyReadException e) {
            throw new MojoExecutionException("Error reading assembly: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (InvalidAssemblerConfigurationException e) {
            throw new MojoExecutionException((Object)this.assemblyReader, e.getMessage(), "Docker assembly configuration is invalid: " + e.getMessage());
        }
    }
}

