/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DockerFileUtil {
    private DockerFileUtil() {
    }

    public static String extractBaseImage(File dockerFile, Properties properties, String filter) throws IOException {
        String[] parts;
        List<String[]> fromLines = DockerFileUtil.extractLines(dockerFile, "FROM", properties, filter);
        if (!fromLines.isEmpty() && (parts = fromLines.get(0)).length > 1) {
            return parts[1];
        }
        return null;
    }

    public static List<String[]> extractLines(File dockerFile, String keyword, Properties props, String filter) throws IOException {
        ArrayList<String[]> ret = new ArrayList<String[]>();
        String[] delimiters = DockerFileUtil.extractDelimiters(filter);
        try (BufferedReader reader = new BufferedReader(new FileReader(dockerFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                String lineInterpolated = DockerFileUtil.interpolateLine(line, props, delimiters);
                String[] lineParts = lineInterpolated.split("\\s+");
                if (lineParts.length <= 0 || !lineParts[0].equalsIgnoreCase(keyword)) continue;
                ret.add(lineParts);
            }
        }
        return ret;
    }

    public static String interpolate(File dockerFile, Properties properties, String filter) throws IOException {
        StringBuilder ret = new StringBuilder();
        String[] delimiters = DockerFileUtil.extractDelimiters(filter);
        try (BufferedReader reader = new BufferedReader(new FileReader(dockerFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                ret.append(DockerFileUtil.interpolateLine(line, properties, delimiters)).append(System.lineSeparator());
            }
        }
        return ret.toString();
    }

    private static String interpolateLine(String line, Properties properties, String[] delimiters) {
        if (delimiters == null || delimiters.length == 0) {
            return line;
        }
        Pattern propertyPattern = Pattern.compile("(?<variable>" + Pattern.quote(delimiters[0]) + "(?<prop>.*?)" + Pattern.quote(delimiters[1]) + ")");
        Matcher matcher = propertyPattern.matcher(line);
        StringBuffer ret = new StringBuffer();
        while (matcher.find()) {
            String prop = matcher.group("prop");
            String value = properties.containsKey(prop) ? properties.getProperty(prop) : matcher.group("variable");
            matcher.appendReplacement(ret, value.replace("$", "\\$"));
        }
        matcher.appendTail(ret);
        return ret.toString();
    }

    private static String[] extractDelimiters(String filter) {
        Matcher matcher;
        if (filter == null || filter.equalsIgnoreCase("false") || filter.equalsIgnoreCase("none")) {
            return null;
        }
        if (filter.contains("*") && (matcher = Pattern.compile("^(?<start>[^*]+)\\*(?<end>.*)$").matcher(filter)).matches()) {
            return new String[]{matcher.group("start"), matcher.group("end")};
        }
        return new String[]{filter, filter};
    }
}

