/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import io.fabric8.maven.docker.AbstractBuildSupportMojo;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.BuildService;
import io.fabric8.maven.docker.service.ImagePullManager;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.EnvUtil;
import java.util.Date;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="build", defaultPhase=LifecyclePhase.INSTALL)
public class BuildMojo
extends AbstractBuildSupportMojo {
    @Parameter(property="docker.skip.tag", defaultValue="false")
    private boolean skipTag;
    @Parameter(property="docker.skip.build", defaultValue="false")
    protected boolean skipBuild;

    @Override
    protected void executeInternal(ServiceHub hub) throws DockerAccessException, MojoExecutionException {
        if (this.skipBuild) {
            return;
        }
        for (ImageConfiguration imageConfig : this.getResolvedImages()) {
            BuildImageConfiguration buildConfig = imageConfig.getBuildConfiguration();
            if (buildConfig == null) continue;
            if (buildConfig.skip()) {
                this.log.info("%s : Skipped building", imageConfig.getDescription());
                continue;
            }
            this.buildAndTag(hub, imageConfig);
        }
    }

    protected void buildAndTag(ServiceHub hub, ImageConfiguration imageConfig) throws MojoExecutionException, DockerAccessException {
        EnvUtil.storeTimestamp(this.getBuildTimestampFile(), this.getBuildTimestamp());
        BuildService.BuildContext buildContext = this.getBuildContext();
        ImagePullManager pullManager = this.getImagePullManager(this.determinePullPolicy(imageConfig.getBuildConfiguration()), this.autoPull);
        BuildService buildService = hub.getBuildService();
        buildService.buildImage(imageConfig, pullManager, buildContext);
        if (!this.skipTag) {
            buildService.tagImage(imageConfig.getName(), imageConfig);
        }
    }

    @Override
    protected Date getReferenceDate() throws MojoExecutionException {
        return new Date();
    }

    private String determinePullPolicy(BuildImageConfiguration buildConfig) {
        return buildConfig != null && buildConfig.getImagePullPolicy() != null ? buildConfig.getImagePullPolicy() : this.imagePullPolicy;
    }
}

