/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import io.fabric8.maven.docker.AbstractDockerMojo;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.QueryService;
import io.fabric8.maven.docker.service.ServiceHub;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="remove", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST)
public class RemoveMojo
extends AbstractDockerMojo {
    @Deprecated
    @Parameter(property="docker.removeAll")
    private Boolean removeAll;
    @Parameter(property="docker.removeMode")
    private String removeMode;

    @Override
    protected void executeInternal(ServiceHub hub) throws DockerAccessException {
        for (ImageConfiguration image : this.getResolvedImages()) {
            String name = image.getName();
            if (!this.imageShouldBeRemoved(image)) continue;
            this.removeImage(hub, name);
            for (String tag : this.getImageBuildTags(image)) {
                this.removeImage(hub, name + ":" + tag);
            }
        }
    }

    private boolean imageShouldBeRemoved(ImageConfiguration image) {
        if ("all".equalsIgnoreCase(this.removeMode)) {
            return true;
        }
        if ("build".equalsIgnoreCase(this.removeMode)) {
            return image.getBuildConfiguration() != null;
        }
        if ("run".equalsIgnoreCase(this.removeMode)) {
            return image.getRegistry() != null;
        }
        if ("data".equalsIgnoreCase(this.removeMode)) {
            return image.isDataImage();
        }
        if (this.removeAll != null) {
            return this.removeAll != false || image.isDataImage();
        }
        return image.getBuildConfiguration() != null;
    }

    private void removeImage(ServiceHub hub, String name) throws DockerAccessException {
        QueryService queryService = hub.getQueryService();
        if (queryService.hasImage(name) && hub.getDockerAccess().removeImage(name, true)) {
            this.log.info("%s: Remove", name);
        }
    }

    private List<String> getImageBuildTags(ImageConfiguration image) {
        return image.getBuildConfiguration() != null ? image.getBuildConfiguration().getTags() : Collections.emptyList();
    }
}

