/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util;

import io.fabric8.maven.docker.access.AuthConfig;
import io.fabric8.maven.docker.access.util.ExternalCommand;
import io.fabric8.maven.docker.util.Logger;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class CredentialHelperClient {
    static final String SECRET_KEY = "Secret";
    static final String USERNAME_KEY = "Username";
    private final String credentialHelperName;
    private final Logger log;

    public CredentialHelperClient(Logger log, String credentialsStore) {
        this.log = log;
        this.credentialHelperName = "docker-credential-" + credentialsStore;
    }

    public String getName() {
        return this.credentialHelperName;
    }

    public String getVersion() throws MojoExecutionException {
        try {
            return new VersionCommand().getVersion();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error getting the version of the configured credential helper", (Exception)e);
        }
    }

    public AuthConfig getAuthConfig(String registryToLookup) throws MojoExecutionException {
        try {
            GetCommand getCommand = new GetCommand();
            return this.toAuthConfig(getCommand.getCredentialNode("https://" + registryToLookup));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error getting the credentials for " + registryToLookup + " from the configured credential helper", (Exception)e);
        }
    }

    private AuthConfig toAuthConfig(JSONObject credential) {
        if (credential == null) {
            return null;
        }
        String password = credential.getString(SECRET_KEY);
        String userKey = credential.getString(USERNAME_KEY);
        return new AuthConfig(userKey, password, null, null);
    }

    private class GetCommand
    extends ExternalCommand {
        private String reply;

        GetCommand() {
            super(CredentialHelperClient.this.log);
        }

        @Override
        protected String[] getArgs() {
            return new String[]{CredentialHelperClient.this.credentialHelperName, "get"};
        }

        @Override
        protected void processLine(String line) {
            this.reply = line;
        }

        public JSONObject getCredentialNode(String registryToLookup) throws IOException {
            try {
                this.execute(registryToLookup);
            }
            catch (IOException ex) {
                if (this.getStatusCode() == 1) {
                    return null;
                }
                throw ex;
            }
            JSONObject credentials = new JSONObject(new JSONTokener(this.reply));
            if (!credentials.has(CredentialHelperClient.SECRET_KEY) || !credentials.has(CredentialHelperClient.USERNAME_KEY)) {
                return null;
            }
            return credentials;
        }
    }

    private class VersionCommand
    extends ExternalCommand {
        private String version;

        VersionCommand() {
            super(CredentialHelperClient.this.log);
        }

        @Override
        protected String[] getArgs() {
            return new String[]{CredentialHelperClient.this.credentialHelperName, "version"};
        }

        @Override
        protected void processLine(String line) {
            this.log.info("Credentials helper reply for \"%s\" is %s", CredentialHelperClient.this.credentialHelperName, line);
            this.version = line;
        }

        public String getVersion() throws IOException {
            this.execute();
            if (this.version == null) {
                this.log.verbose("The credentials helper \"%s\" didn't return a version string", CredentialHelperClient.this.credentialHelperName);
            }
            return this.version;
        }
    }
}

