/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config.handler.property;

import io.fabric8.maven.docker.config.Arguments;
import io.fabric8.maven.docker.config.AssemblyConfiguration;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.HealthCheckConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.LogConfiguration;
import io.fabric8.maven.docker.config.NetworkConfig;
import io.fabric8.maven.docker.config.RestartPolicy;
import io.fabric8.maven.docker.config.RunImageConfiguration;
import io.fabric8.maven.docker.config.RunVolumeConfiguration;
import io.fabric8.maven.docker.config.UlimitConfig;
import io.fabric8.maven.docker.config.WaitConfiguration;
import io.fabric8.maven.docker.config.WatchImageConfiguration;
import io.fabric8.maven.docker.config.handler.ExternalConfigHandler;
import io.fabric8.maven.docker.config.handler.property.ConfigKey;
import io.fabric8.maven.docker.config.handler.property.PropertyMode;
import io.fabric8.maven.docker.config.handler.property.ValueProvider;
import io.fabric8.maven.docker.util.EnvUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.CollectionUtils;

public class PropertyConfigHandler
implements ExternalConfigHandler {
    public static final String TYPE_NAME = "properties";
    public static final String DEFAULT_PREFIX = "docker";

    @Override
    public String getType() {
        return TYPE_NAME;
    }

    @Override
    public List<ImageConfiguration> resolve(ImageConfiguration fromConfig, MavenProject project, MavenSession session) throws IllegalArgumentException {
        Map<String, String> externalConfig = fromConfig.getExternalConfig();
        String prefix = PropertyConfigHandler.getPrefix(externalConfig);
        Properties properties = EnvUtil.getPropertiesWithSystemOverrides(project);
        PropertyMode propertyMode = PropertyConfigHandler.getMode(externalConfig);
        ValueProvider valueProvider = new ValueProvider(prefix, properties, propertyMode);
        RunImageConfiguration run = this.extractRunConfiguration(fromConfig, valueProvider);
        BuildImageConfiguration build = this.extractBuildConfiguration(fromConfig, valueProvider, project);
        WatchImageConfiguration watch = this.extractWatchConfig(fromConfig, valueProvider);
        String name = valueProvider.getString(ConfigKey.NAME, fromConfig.getName());
        String alias = valueProvider.getString(ConfigKey.ALIAS, fromConfig.getAlias());
        if (name == null) {
            throw new IllegalArgumentException(String.format("Mandatory property [%s] is not defined", new Object[]{ConfigKey.NAME}));
        }
        return Collections.singletonList(new ImageConfiguration.Builder().name(name).alias(alias).runConfig(run).buildConfig(build).watchConfig(watch).build());
    }

    private boolean isStringValueNull(ValueProvider valueProvider, BuildImageConfiguration config, ConfigKey key, Supplier<String> supplier) {
        return valueProvider.getString(key, config == null ? null : supplier.get()) != null;
    }

    private boolean buildConfigured(BuildImageConfiguration config, ValueProvider valueProvider, MavenProject project) {
        if (this.isStringValueNull(valueProvider, config, ConfigKey.FROM, () -> config.getFrom())) {
            return true;
        }
        if (valueProvider.getMap(ConfigKey.FROM_EXT, config == null ? null : config.getFromExt()) != null) {
            return true;
        }
        if (this.isStringValueNull(valueProvider, config, ConfigKey.DOCKER_FILE, () -> config.getDockerFileRaw())) {
            return true;
        }
        if (this.isStringValueNull(valueProvider, config, ConfigKey.DOCKER_ARCHIVE, () -> config.getDockerArchiveRaw())) {
            return true;
        }
        if (this.isStringValueNull(valueProvider, config, ConfigKey.CONTEXT_DIR, () -> config.getContextDirRaw())) {
            return true;
        }
        if (this.isStringValueNull(valueProvider, config, ConfigKey.DOCKER_FILE_DIR, () -> config.getDockerFileDirRaw())) {
            return true;
        }
        return new File(project.getBasedir(), "Dockerfile").exists();
    }

    private BuildImageConfiguration extractBuildConfiguration(ImageConfiguration fromConfig, ValueProvider valueProvider, MavenProject project) {
        BuildImageConfiguration config = fromConfig.getBuildConfiguration();
        if (!this.buildConfigured(config, valueProvider, project)) {
            return null;
        }
        return new BuildImageConfiguration.Builder().cmd(this.extractArguments(valueProvider, ConfigKey.CMD, config == null ? null : config.getCmd())).cleanup(valueProvider.getString(ConfigKey.CLEANUP, config == null ? null : config.getCleanup())).noCache(valueProvider.getBoolean(ConfigKey.NO_CACHE, config == null ? null : config.getNoCache())).cacheFrom(valueProvider.getString(ConfigKey.CACHE_FROM, config == null ? null : config.getCacheFrom().toString()), new String[0]).optimise(valueProvider.getBoolean(ConfigKey.OPTIMISE, config == null ? null : config.getOptimise())).entryPoint(this.extractArguments(valueProvider, ConfigKey.ENTRYPOINT, config == null ? null : config.getEntryPoint())).assembly(this.extractAssembly(config == null ? null : config.getAssemblyConfiguration(), valueProvider)).env(CollectionUtils.mergeMaps(valueProvider.getMap(ConfigKey.ENV_BUILD, config == null ? null : config.getEnv()), valueProvider.getMap(ConfigKey.ENV, Collections.emptyMap()))).args(valueProvider.getMap(ConfigKey.ARGS, config == null ? null : config.getArgs())).labels(valueProvider.getMap(ConfigKey.LABELS, config == null ? null : config.getLabels())).ports(this.extractPortValues(config == null ? null : config.getPorts(), valueProvider)).shell(this.extractArguments(valueProvider, ConfigKey.SHELL, config == null ? null : config.getShell())).runCmds(valueProvider.getList(ConfigKey.RUN, config == null ? null : config.getRunCmds())).from(valueProvider.getString(ConfigKey.FROM, config == null ? null : config.getFrom())).fromExt(valueProvider.getMap(ConfigKey.FROM_EXT, config == null ? null : config.getFromExt())).registry(valueProvider.getString(ConfigKey.REGISTRY, config == null ? null : config.getRegistry())).volumes(valueProvider.getList(ConfigKey.VOLUMES, config == null ? null : config.getVolumes())).tags(valueProvider.getList(ConfigKey.TAGS, config == null ? null : config.getTags())).maintainer(valueProvider.getString(ConfigKey.MAINTAINER, config == null ? null : config.getMaintainer())).workdir(valueProvider.getString(ConfigKey.WORKDIR, config == null ? null : config.getWorkdir())).skip(valueProvider.getBoolean(ConfigKey.SKIP_BUILD, config == null ? null : config.getSkip())).imagePullPolicy(valueProvider.getString(ConfigKey.IMAGE_PULL_POLICY_BUILD, config == null ? null : config.getImagePullPolicy())).contextDir(valueProvider.getString(ConfigKey.CONTEXT_DIR, config == null ? null : config.getContextDirRaw())).dockerArchive(valueProvider.getString(ConfigKey.DOCKER_ARCHIVE, config == null ? null : config.getDockerArchiveRaw())).loadNamePattern(valueProvider.getString(ConfigKey.LOAD_NAME_PATTERN, config == null ? null : config.getLoadNamePattern())).dockerFile(valueProvider.getString(ConfigKey.DOCKER_FILE, config == null ? null : config.getDockerFileRaw())).dockerFileDir(valueProvider.getString(ConfigKey.DOCKER_FILE_DIR, config == null ? null : config.getDockerFileDirRaw())).buildOptions(valueProvider.getMap(ConfigKey.BUILD_OPTIONS, config == null ? null : config.getBuildOptions())).filter(valueProvider.getString(ConfigKey.FILTER, config == null ? null : config.getFilterRaw())).user(valueProvider.getString(ConfigKey.USER, config == null ? null : config.getUser())).healthCheck(this.extractHealthCheck(config == null ? null : config.getHealthCheck(), valueProvider)).build();
    }

    private RunImageConfiguration extractRunConfiguration(ImageConfiguration fromConfig, ValueProvider valueProvider) {
        RunImageConfiguration config = fromConfig.getRunConfiguration();
        if (config.isDefault()) {
            config = null;
        }
        return new RunImageConfiguration.Builder().capAdd(valueProvider.getList(ConfigKey.CAP_ADD, config == null ? null : config.getCapAdd())).capDrop(valueProvider.getList(ConfigKey.CAP_DROP, config == null ? null : config.getCapDrop())).securityOpts(valueProvider.getList(ConfigKey.SECURITY_OPTS, config == null ? null : config.getSecurityOpts())).cmd(this.extractArguments(valueProvider, ConfigKey.CMD, config == null ? null : config.getCmd())).dns(valueProvider.getList(ConfigKey.DNS, config == null ? null : config.getDns())).dependsOn(valueProvider.getList(ConfigKey.DEPENDS_ON, config == null ? null : config.getDependsOn())).net(valueProvider.getString(ConfigKey.NET, config == null ? null : config.getNetRaw())).network(this.extractNetworkConfig(config == null ? null : config.getNetworkingConfig(), valueProvider)).dnsSearch(valueProvider.getList(ConfigKey.DNS_SEARCH, config == null ? null : config.getDnsSearch())).domainname(valueProvider.getString(ConfigKey.DOMAINNAME, config == null ? null : config.getDomainname())).entrypoint(this.extractArguments(valueProvider, ConfigKey.ENTRYPOINT, config == null ? null : config.getEntrypoint())).env(CollectionUtils.mergeMaps(valueProvider.getMap(ConfigKey.ENV_RUN, config == null ? null : config.getEnv()), valueProvider.getMap(ConfigKey.ENV, Collections.emptyMap()))).labels(valueProvider.getMap(ConfigKey.LABELS, config == null ? null : config.getLabels())).envPropertyFile(valueProvider.getString(ConfigKey.ENV_PROPERTY_FILE, config == null ? null : config.getEnvPropertyFile())).extraHosts(valueProvider.getList(ConfigKey.EXTRA_HOSTS, config == null ? null : config.getExtraHosts())).hostname(valueProvider.getString(ConfigKey.HOSTNAME, config == null ? null : config.getHostname())).links(valueProvider.getList(ConfigKey.LINKS, config == null ? null : config.getLinks())).memory(valueProvider.getLong(ConfigKey.MEMORY, config == null ? null : config.getMemory())).memorySwap(valueProvider.getLong(ConfigKey.MEMORY_SWAP, config == null ? null : config.getMemorySwap())).namingStrategy(valueProvider.getString(ConfigKey.NAMING_STRATEGY, config == null || config.getNamingStrategy() == null ? null : config.getNamingStrategy().name())).exposedPropertyKey(valueProvider.getString(ConfigKey.EXPOSED_PROPERTY_KEY, config == null ? null : config.getExposedPropertyKey())).portPropertyFile(valueProvider.getString(ConfigKey.PORT_PROPERTY_FILE, config == null ? null : config.getPortPropertyFile())).ports(valueProvider.getList(ConfigKey.PORTS, config == null ? null : config.getPorts())).shmSize(valueProvider.getLong(ConfigKey.SHMSIZE, config == null ? null : config.getShmSize())).privileged(valueProvider.getBoolean(ConfigKey.PRIVILEGED, config == null ? null : config.getPrivileged())).restartPolicy(this.extractRestartPolicy(config == null ? null : config.getRestartPolicy(), valueProvider)).user(valueProvider.getString(ConfigKey.USER, config == null ? null : config.getUser())).workingDir(valueProvider.getString(ConfigKey.WORKING_DIR, config == null ? null : config.getWorkingDir())).log(this.extractLogConfig(config == null ? null : config.getLogConfiguration(), valueProvider)).wait(this.extractWaitConfig(config == null ? null : config.getWaitConfiguration(), valueProvider)).volumes(this.extractVolumeConfig(config == null ? null : config.getVolumeConfiguration(), valueProvider)).skip(valueProvider.getBoolean(ConfigKey.SKIP_RUN, config == null ? null : config.getSkip())).imagePullPolicy(valueProvider.getString(ConfigKey.IMAGE_PULL_POLICY_RUN, config == null ? null : config.getImagePullPolicy())).ulimits(this.extractUlimits(config == null ? null : config.getUlimits(), valueProvider)).tmpfs(valueProvider.getList(ConfigKey.TMPFS, config == null ? null : config.getTmpfs())).cpuShares(valueProvider.getLong(ConfigKey.CPUSHARES, config == null ? null : config.getCpuShares())).cpus(valueProvider.getLong(ConfigKey.CPUS, config == null ? null : config.getCpus())).cpuSet(valueProvider.getString(ConfigKey.CPUSET, config == null ? null : config.getCpuSet())).readOnly(valueProvider.getBoolean(ConfigKey.READ_ONLY, config == null ? null : config.getReadOnly())).autoRemove(valueProvider.getBoolean(ConfigKey.AUTO_REMOVE, config == null ? null : config.getAutoRemove())).build();
    }

    private NetworkConfig extractNetworkConfig(NetworkConfig config, ValueProvider valueProvider) {
        return new NetworkConfig.Builder().mode(valueProvider.getString(ConfigKey.NETWORK_MODE, config == null || config.getMode() == null ? null : config.getMode().name())).name(valueProvider.getString(ConfigKey.NETWORK_NAME, config == null ? null : config.getName())).aliases(valueProvider.getList(ConfigKey.NETWORK_ALIAS, config == null ? null : config.getAliases())).build();
    }

    private AssemblyConfiguration extractAssembly(AssemblyConfiguration config, ValueProvider valueProvider) {
        return new AssemblyConfiguration.Builder().targetDir(valueProvider.getString(ConfigKey.ASSEMBLY_BASEDIR, config == null ? null : config.getTargetDir())).descriptor(valueProvider.getString(ConfigKey.ASSEMBLY_DESCRIPTOR, config == null ? null : config.getDescriptor())).descriptorRef(valueProvider.getString(ConfigKey.ASSEMBLY_DESCRIPTOR_REF, config == null ? null : config.getDescriptorRef())).dockerFileDir(valueProvider.getString(ConfigKey.ASSEMBLY_DOCKER_FILE_DIR, config == null ? null : config.getDockerFileDir())).exportBasedir(valueProvider.getBoolean(ConfigKey.ASSEMBLY_EXPORT_BASEDIR, config == null ? null : config.getExportTargetDir())).ignorePermissions(valueProvider.getBoolean(ConfigKey.ASSEMBLY_IGNORE_PERMISSIONS, config == null ? null : config.getIgnorePermissions())).permissions(valueProvider.getString(ConfigKey.ASSEMBLY_PERMISSIONS, config == null ? null : config.getPermissionsRaw())).user(valueProvider.getString(ConfigKey.ASSEMBLY_USER, config == null ? null : config.getUser())).mode(valueProvider.getString(ConfigKey.ASSEMBLY_MODE, config == null ? null : config.getModeRaw())).tarLongFileMode(valueProvider.getString(ConfigKey.ASSEMBLY_TARLONGFILEMODE, config == null ? null : config.getTarLongFileMode())).build();
    }

    private HealthCheckConfiguration extractHealthCheck(HealthCheckConfiguration config, ValueProvider valueProvider) {
        Map<String, String> healthCheckProperties = valueProvider.getMap(ConfigKey.HEALTHCHECK, Collections.emptyMap());
        if (healthCheckProperties != null && healthCheckProperties.size() > 0) {
            return new HealthCheckConfiguration.Builder().interval(valueProvider.getString(ConfigKey.HEALTHCHECK_INTERVAL, config == null ? null : config.getInterval())).timeout(valueProvider.getString(ConfigKey.HEALTHCHECK_TIMEOUT, config == null ? null : config.getTimeout())).startPeriod(valueProvider.getString(ConfigKey.HEALTHCHECK_START_PERIOD, config == null ? null : config.getStartPeriod())).retries(valueProvider.getInteger(ConfigKey.HEALTHCHECK_RETRIES, config == null ? null : config.getRetries())).mode(valueProvider.getString(ConfigKey.HEALTHCHECK_MODE, config == null || config.getMode() == null ? null : config.getMode().name())).cmd(this.extractArguments(valueProvider, ConfigKey.HEALTHCHECK_CMD, config == null ? null : config.getCmd())).build();
        }
        return config;
    }

    private List<String> extractPortValues(List<String> config, ValueProvider valueProvider) {
        ArrayList<String> ret = new ArrayList<String>();
        List<String> ports = valueProvider.getList(ConfigKey.PORTS, config);
        if (ports == null) {
            return null;
        }
        List<String[]> parsedPorts = EnvUtil.splitOnLastColon(ports);
        for (String[] port : parsedPorts) {
            ret.add(port[1]);
        }
        return ret;
    }

    private Arguments extractArguments(ValueProvider valueProvider, ConfigKey configKey, Arguments alternative) {
        return valueProvider.getObject(configKey, alternative, raw -> raw != null ? new Arguments((String)raw) : null);
    }

    private RestartPolicy extractRestartPolicy(RestartPolicy config, ValueProvider valueProvider) {
        return new RestartPolicy.Builder().name(valueProvider.getString(ConfigKey.RESTART_POLICY_NAME, config == null ? null : config.getName())).retry(valueProvider.getInt(ConfigKey.RESTART_POLICY_RETRY, config == null || config.getRetry() == 0 ? null : Integer.valueOf(config.getRetry()))).build();
    }

    private LogConfiguration extractLogConfig(LogConfiguration config, ValueProvider valueProvider) {
        LogConfiguration.Builder builder = new LogConfiguration.Builder().color(valueProvider.getString(ConfigKey.LOG_COLOR, config == null ? null : config.getColor())).date(valueProvider.getString(ConfigKey.LOG_DATE, config == null ? null : config.getDate())).file(valueProvider.getString(ConfigKey.LOG_FILE, config == null ? null : config.getFileLocation())).prefix(valueProvider.getString(ConfigKey.LOG_PREFIX, config == null ? null : config.getPrefix())).logDriverName(valueProvider.getString(ConfigKey.LOG_DRIVER_NAME, config == null || config.getDriver() == null ? null : config.getDriver().getName())).logDriverOpts(valueProvider.getMap(ConfigKey.LOG_DRIVER_OPTS, config == null || config.getDriver() == null ? null : config.getDriver().getOpts()));
        Boolean configEnabled = config != null ? config.isEnabled() : null;
        Boolean enabled = valueProvider.getBoolean(ConfigKey.LOG_ENABLED, configEnabled);
        builder.enabled(enabled);
        return builder.build();
    }

    private WaitConfiguration extractWaitConfig(WaitConfiguration config, ValueProvider valueProvider) {
        String url = valueProvider.getString(ConfigKey.WAIT_HTTP_URL, config == null ? null : config.getUrl());
        if (url == null) {
            url = valueProvider.getString(ConfigKey.WAIT_URL, config == null ? null : config.getUrl());
        }
        WaitConfiguration.ExecConfiguration exec = config == null ? null : config.getExec();
        WaitConfiguration.TcpConfiguration tcp = config == null ? null : config.getTcp();
        WaitConfiguration.HttpConfiguration http = config == null ? null : config.getHttp();
        return new WaitConfiguration.Builder().time(valueProvider.getInt(ConfigKey.WAIT_TIME, config == null ? null : config.getTime())).healthy(valueProvider.getBoolean(ConfigKey.WAIT_HEALTHY, config == null ? null : config.getHealthy())).url(url).preStop(valueProvider.getString(ConfigKey.WAIT_EXEC_PRE_STOP, exec == null ? null : exec.getPreStop())).postStart(valueProvider.getString(ConfigKey.WAIT_EXEC_POST_START, exec == null ? null : exec.getPostStart())).breakOnError(valueProvider.getBoolean(ConfigKey.WAIT_EXEC_BREAK_ON_ERROR, exec == null ? null : Boolean.valueOf(exec.isBreakOnError()))).method(valueProvider.getString(ConfigKey.WAIT_HTTP_METHOD, http == null ? null : http.getMethod())).status(valueProvider.getString(ConfigKey.WAIT_HTTP_STATUS, http == null ? null : http.getStatus())).log(valueProvider.getString(ConfigKey.WAIT_LOG, config == null ? null : config.getLog())).kill(valueProvider.getInteger(ConfigKey.WAIT_KILL, config == null ? null : config.getKill())).exit(valueProvider.getInteger(ConfigKey.WAIT_EXIT, config == null ? null : config.getExit())).shutdown(valueProvider.getInteger(ConfigKey.WAIT_SHUTDOWN, config == null ? null : config.getShutdown())).tcpHost(valueProvider.getString(ConfigKey.WAIT_TCP_HOST, tcp == null ? null : tcp.getHost())).tcpPorts(valueProvider.getIntList(ConfigKey.WAIT_TCP_PORT, tcp == null ? null : tcp.getPorts())).tcpMode(valueProvider.getString(ConfigKey.WAIT_TCP_MODE, tcp == null || tcp.getMode() == null ? null : tcp.getMode().name())).build();
    }

    private WatchImageConfiguration extractWatchConfig(ImageConfiguration fromConfig, ValueProvider valueProvider) {
        WatchImageConfiguration config = fromConfig.getWatchConfiguration();
        return new WatchImageConfiguration.Builder().interval(valueProvider.getInteger(ConfigKey.WATCH_INTERVAL, config == null ? null : config.getIntervalRaw())).postGoal(valueProvider.getString(ConfigKey.WATCH_POSTGOAL, config == null ? null : config.getPostGoal())).postExec(valueProvider.getString(ConfigKey.WATCH_POSTEXEC, config == null ? null : config.getPostExec())).mode(valueProvider.getString(ConfigKey.WATCH_POSTGOAL, config == null || config.getMode() == null ? null : config.getMode().name())).build();
    }

    private List<UlimitConfig> extractUlimits(List<UlimitConfig> config, ValueProvider valueProvider) {
        List<String> ulimits;
        ArrayList<String> other = null;
        if (config != null) {
            other = new ArrayList<String>();
            for (UlimitConfig ulimitConfig : config) {
                other.add(ulimitConfig.serialize());
            }
        }
        if ((ulimits = valueProvider.getList(ConfigKey.ULIMITS, other)) == null) {
            return null;
        }
        ArrayList<UlimitConfig> ret = new ArrayList<UlimitConfig>();
        for (String ulimit : ulimits) {
            ret.add(new UlimitConfig(ulimit));
        }
        return ret;
    }

    private RunVolumeConfiguration extractVolumeConfig(RunVolumeConfiguration config, ValueProvider valueProvider) {
        return new RunVolumeConfiguration.Builder().bind(valueProvider.getList(ConfigKey.BIND, config == null ? null : config.getBind())).from(valueProvider.getList(ConfigKey.VOLUMES_FROM, config == null ? null : config.getFrom())).build();
    }

    private static String getPrefix(Map<String, String> externalConfig) {
        String prefix = externalConfig.get("prefix");
        if (prefix == null) {
            prefix = DEFAULT_PREFIX;
        }
        return prefix;
    }

    private static PropertyMode getMode(Map<String, String> externalConfig) {
        return PropertyMode.parse(externalConfig.get("mode"));
    }

    public static boolean canCoexistWithOtherPropertyConfiguredImages(Map<String, String> externalConfig) {
        if (externalConfig == null || externalConfig.isEmpty()) {
            return false;
        }
        if (!TYPE_NAME.equals(externalConfig.get("type"))) {
            return true;
        }
        return externalConfig.get("prefix") != null;
    }
}

