/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util;

import io.fabric8.maven.docker.util.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;

public class AnsiLogger
implements Logger {
    public static final String DEFAULT_LOG_PREFIX = "DOCKER> ";
    private static final int NON_ANSI_UPDATE_PERIOD = 80;
    private final Log log;
    private final String prefix;
    private final boolean batchMode;
    private boolean isVerbose = false;
    private List<Logger.LogVerboseCategory> verboseModes = null;
    static Ansi.Color COLOR_ERROR = Ansi.Color.RED;
    static Ansi.Color COLOR_INFO = Ansi.Color.GREEN;
    static Ansi.Color COLOR_WARNING = Ansi.Color.YELLOW;
    static Ansi.Color COLOR_PROGRESS_ID = Ansi.Color.YELLOW;
    static Ansi.Color COLOR_PROGRESS_STATUS = Ansi.Color.GREEN;
    static Ansi.Color COLOR_PROGRESS_BAR = Ansi.Color.CYAN;
    static Ansi.Color COLOR_EMPHASIS = Ansi.Color.BLUE;
    private ThreadLocal<Map<String, Integer>> imageLines = new ThreadLocal();
    private ThreadLocal<AtomicInteger> updateCount = new ThreadLocal();
    private boolean useAnsi;
    private static final Map<String, Ansi.Color> COLOR_MAP = new HashMap<String, Ansi.Color>();

    public AnsiLogger(Log log, boolean useColor, String verbose) {
        this(log, useColor, verbose, false);
    }

    public AnsiLogger(Log log, boolean useColor, String verbose, boolean batchMode) {
        this(log, useColor, verbose, batchMode, DEFAULT_LOG_PREFIX);
    }

    public AnsiLogger(Log log, boolean useColor, String verbose, boolean batchMode, String prefix) {
        this.log = log;
        this.prefix = prefix;
        this.batchMode = batchMode;
        this.checkVerboseLoggingEnabled(verbose);
        this.initializeColor(useColor);
    }

    @Override
    public void debug(String message, Object ... params) {
        if (this.isDebugEnabled()) {
            this.log.debug((CharSequence)(this.prefix + this.format(message, params)));
        }
    }

    @Override
    public void info(String message, Object ... params) {
        this.log.info((CharSequence)this.colored(message, COLOR_INFO, true, params));
    }

    @Override
    public void verbose(Logger.LogVerboseCategory logVerboseCategory, String message, Object ... params) {
        if (this.isVerbose && this.verboseModes != null && this.verboseModes.contains((Object)logVerboseCategory)) {
            this.log.info((CharSequence)Ansi.ansi().fgBright(Ansi.Color.BLACK).a(this.prefix).a(this.format(message, params)).reset().toString());
        }
    }

    @Override
    public void warn(String format, Object ... params) {
        this.log.warn((CharSequence)this.colored(format, COLOR_WARNING, true, params));
    }

    @Override
    public void error(String message, Object ... params) {
        this.log.error((CharSequence)this.colored(message, COLOR_ERROR, true, params));
    }

    @Override
    public String errorMessage(String message) {
        return this.colored(message, COLOR_ERROR, false, new Object[0]);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public boolean isVerboseEnabled() {
        return this.isVerbose;
    }

    @Override
    public void progressStart() {
        if (!this.batchMode && this.log.isInfoEnabled()) {
            this.imageLines.remove();
            this.updateCount.remove();
            this.imageLines.set(new HashMap());
            this.updateCount.set(new AtomicInteger());
        }
    }

    @Override
    public void progressUpdate(String layerId, String status, String progressMessage) {
        if (!this.batchMode && this.log.isInfoEnabled() && StringUtils.isNotEmpty((String)layerId)) {
            if (this.useAnsi) {
                this.updateAnsiProgress(layerId, status, progressMessage);
            } else {
                this.updateNonAnsiProgress(layerId);
            }
            this.flush();
        }
    }

    private void updateAnsiProgress(String imageId, String status, String progressMessage) {
        Map<String, Integer> imgLineMap = this.imageLines.get();
        Integer line = imgLineMap.get(imageId);
        int diff = 0;
        if (line == null) {
            line = imgLineMap.size();
            imgLineMap.put(imageId, line);
        } else {
            diff = imgLineMap.size() - line;
        }
        if (diff > 0) {
            this.print(Ansi.ansi().cursorUp(diff).eraseLine(Ansi.Erase.ALL).toString());
        }
        String progress = progressMessage != null ? progressMessage : "";
        String msg = Ansi.ansi().fg(COLOR_PROGRESS_ID).a(imageId).reset().a(": ").fg(COLOR_PROGRESS_STATUS).a(StringUtils.rightPad((String)status, (int)11) + " ").fg(COLOR_PROGRESS_BAR).a(progress).toString();
        this.println(msg);
        if (diff > 0) {
            this.print(Ansi.ansi().cursorDown(diff - 1).toString());
        }
    }

    private void updateNonAnsiProgress(String imageId) {
        AtomicInteger count = this.updateCount.get();
        int nr = count.getAndIncrement();
        if (nr % 80 == 0) {
            this.print("#");
        }
        if (nr > 0 && nr % 6400 == 0) {
            this.print("\n");
        }
    }

    @Override
    public void progressFinished() {
        if (!this.batchMode && this.log.isInfoEnabled()) {
            this.imageLines.remove();
            this.print(Ansi.ansi().reset().toString());
            if (!this.useAnsi) {
                this.println("");
            }
        }
    }

    private void flush() {
        System.out.flush();
    }

    private void initializeColor(boolean useColor) {
        boolean bl = this.useAnsi = useColor && !this.log.isDebugEnabled();
        if (this.useAnsi) {
            AnsiConsole.systemInstall();
            Ansi.setEnabled((boolean)true);
        } else {
            Ansi.setEnabled((boolean)false);
        }
    }

    private void println(String txt) {
        System.out.println(txt);
    }

    private void print(String txt) {
        System.out.print(txt);
    }

    private String colored(String message, Ansi.Color color, boolean addPrefix, Object ... params) {
        Ansi ansi = Ansi.ansi().fg(color);
        String msgToPrint = addPrefix ? this.prefix + message : message;
        return ansi.a(this.format(this.evaluateEmphasis(msgToPrint, color), params)).reset().toString();
    }

    private String format(String message, Object[] params) {
        if (params.length == 0) {
            return message;
        }
        if (params.length == 1 && params[0] instanceof Throwable) {
            return message + ": " + params[0].toString();
        }
        return String.format(message, params);
    }

    private String evaluateEmphasis(String message, Ansi.Color msgColor) {
        String[] parts = message.split("(\\[\\[(?=.]])|(?<=\\[\\[.)]])");
        if (parts.length == 1) {
            return message;
        }
        String msgColorS = Ansi.ansi().fg(msgColor).toString();
        StringBuilder ret = new StringBuilder(parts[0]);
        for (int i = 1; i < parts.length; i += 4) {
            boolean plainPart;
            boolean colorPart = i + 1 < parts.length && parts[i + 1].length() > 0;
            boolean bl = plainPart = i + 3 < parts.length && parts[i + 3].length() > 0;
            if (colorPart) {
                ret.append(this.getEmphasisColor(parts[i]));
                ret.append(parts[i + 1]);
                if (plainPart) {
                    ret.append(msgColorS);
                }
            }
            if (!plainPart) continue;
            ret.append(parts[i + 3]);
        }
        return ret.toString();
    }

    private String getEmphasisColor(String id) {
        Ansi.Color color = COLOR_MAP.get(id.toUpperCase());
        if (color != null) {
            return id.toLowerCase().equals(id) ? Ansi.ansi().fgBright(color).toString() : Ansi.ansi().fg(color).toString();
        }
        return "";
    }

    private void checkVerboseLoggingEnabled(String verbose) {
        if (verbose == null || verbose.equalsIgnoreCase("false")) {
            this.isVerbose = false;
            return;
        }
        if (verbose.equalsIgnoreCase("all")) {
            this.isVerbose = true;
            this.verboseModes = Arrays.asList(Logger.LogVerboseCategory.values());
            return;
        }
        if (verbose.equals("") || verbose.equalsIgnoreCase("true")) {
            this.isVerbose = true;
            this.verboseModes = Collections.singletonList(Logger.LogVerboseCategory.BUILD);
            return;
        }
        this.verboseModes = this.getVerboseModesFromString(verbose);
        this.isVerbose = true;
    }

    private Boolean checkBackwardVersionValues(String verbose) {
        if (verbose.isEmpty()) {
            return Boolean.TRUE;
        }
        if (verbose.equalsIgnoreCase("true") || verbose.equalsIgnoreCase("false")) {
            return Boolean.parseBoolean(verbose.toLowerCase());
        }
        return null;
    }

    private List<Logger.LogVerboseCategory> getVerboseModesFromString(String groups) {
        ArrayList<Logger.LogVerboseCategory> ret = new ArrayList<Logger.LogVerboseCategory>();
        for (String group : groups.split(",")) {
            try {
                ret.add(Logger.LogVerboseCategory.valueOf(group.toUpperCase()));
            }
            catch (Exception exp) {
                this.log.info((CharSequence)("log: Unknown verbosity group " + groups + ". Ignoring..."));
            }
        }
        return ret;
    }

    static {
        COLOR_MAP.put("*", COLOR_EMPHASIS);
        COLOR_MAP.put("B", Ansi.Color.BLUE);
        COLOR_MAP.put("C", Ansi.Color.CYAN);
        COLOR_MAP.put("Y", Ansi.Color.YELLOW);
        COLOR_MAP.put("G", Ansi.Color.GREEN);
        COLOR_MAP.put("M", Ansi.Color.MAGENTA);
        COLOR_MAP.put("R", Ansi.Color.RED);
        COLOR_MAP.put("W", Ansi.Color.WHITE);
        COLOR_MAP.put("S", Ansi.Color.BLACK);
        COLOR_MAP.put("D", Ansi.Color.DEFAULT);
    }
}

