/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config.handler.compose;

import io.fabric8.maven.docker.util.DockerPathUtil;
import java.io.File;
import java.io.IOException;
import org.apache.maven.project.MavenProject;

class ComposeUtils {
    ComposeUtils() {
    }

    static File resolveComposeFileAbsolutely(String baseDir, String composeFile, MavenProject project) {
        File yamlFile = new File(composeFile);
        if (yamlFile.isAbsolute()) {
            return yamlFile;
        }
        File toCanonicalize = new File(ComposeUtils.resolveAbsolutely(baseDir, project), composeFile);
        try {
            return toCanonicalize.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to canonicalize the resolved docker-compose file path '" + toCanonicalize + "'");
        }
    }

    static File resolveAbsolutely(String pathToResolve, MavenProject project) {
        return DockerPathUtil.resolveAbsolutely(pathToResolve, project == null ? null : project.getBasedir().getAbsolutePath());
    }
}

