/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.wait;

import io.fabric8.maven.docker.access.DockerAccess;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.model.ContainerDetails;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.wait.WaitChecker;

public class HealthCheckChecker
implements WaitChecker {
    private boolean first = true;
    private DockerAccess docker;
    private String containerId;
    private Logger log;
    private final String imageConfigDesc;

    public HealthCheckChecker(DockerAccess docker, String containerId, String imageConfigDesc, Logger log) {
        this.docker = docker;
        this.containerId = containerId;
        this.imageConfigDesc = imageConfigDesc;
        this.log = log;
    }

    @Override
    public boolean check() {
        try {
            ContainerDetails container = this.docker.getContainer(this.containerId);
            if (container == null) {
                this.log.debug("HealthWaitChecker: Container %s not found", new Object[0]);
                return false;
            }
            if (container.getHealthcheck() == null) {
                throw new IllegalArgumentException("Can not wait for healthstate of " + this.imageConfigDesc + ". No HEALTHCHECK configured.");
            }
            if (this.first) {
                this.log.info("%s: Waiting to become healthy", this.imageConfigDesc);
                this.log.debug("HealthWaitChecker: Waiting for healthcheck: '%s'", container.getHealthcheck());
                this.first = false;
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("HealthWaitChecker: Waiting on healthcheck '%s'", container.getHealthcheck());
            }
            return container.isHealthy();
        }
        catch (DockerAccessException e) {
            this.log.warn("Error while checking health: %s", e.getMessage());
            return false;
        }
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public String getLogLabel() {
        try {
            ContainerDetails container = this.docker.getContainer(this.containerId);
            return String.format("on healthcheck '%s'", container != null ? container.getHealthcheck() : "[container not found]");
        }
        catch (DockerAccessException e) {
            return String.format("on healthcheck [error fetching container: %s]", e.getMessage());
        }
    }
}

