/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.service;

import io.fabric8.maven.docker.access.DockerAccess;
import io.fabric8.maven.docker.assembly.DockerAssemblyManager;
import io.fabric8.maven.docker.log.LogOutputSpecFactory;
import io.fabric8.maven.docker.service.ArchiveService;
import io.fabric8.maven.docker.service.BuildService;
import io.fabric8.maven.docker.service.ContainerTracker;
import io.fabric8.maven.docker.service.MojoExecutionService;
import io.fabric8.maven.docker.service.QueryService;
import io.fabric8.maven.docker.service.RegistryService;
import io.fabric8.maven.docker.service.RunService;
import io.fabric8.maven.docker.service.VolumeService;
import io.fabric8.maven.docker.service.WaitService;
import io.fabric8.maven.docker.service.WatchService;
import io.fabric8.maven.docker.util.Logger;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.project.MavenProject;

public class ServiceHub {
    private final DockerAccess dockerAccess;
    private final QueryService queryService;
    private final RunService runService;
    private final RegistryService registryService;
    private final BuildService buildService;
    private final MojoExecutionService mojoExecutionService;
    private final ArchiveService archiveService;
    private final VolumeService volumeService;
    private final WatchService watchService;
    private final WaitService waitService;
    private final DockerAssemblyManager dockerAssemblyManager;

    ServiceHub(DockerAccess dockerAccess, ContainerTracker containerTracker, BuildPluginManager pluginManager, DockerAssemblyManager dockerAssemblyManager, MavenProject project, MavenSession session, Logger logger, LogOutputSpecFactory logSpecFactory) {
        this.dockerAccess = dockerAccess;
        this.dockerAssemblyManager = dockerAssemblyManager;
        this.mojoExecutionService = new MojoExecutionService(project, session, pluginManager);
        this.archiveService = new ArchiveService(dockerAssemblyManager, logger);
        if (dockerAccess != null) {
            this.queryService = new QueryService(dockerAccess);
            this.registryService = new RegistryService(dockerAccess, this.queryService, logger);
            this.runService = new RunService(dockerAccess, this.queryService, containerTracker, logSpecFactory, logger);
            this.buildService = new BuildService(dockerAccess, this.queryService, this.registryService, this.archiveService, logger);
            this.volumeService = new VolumeService(dockerAccess);
            this.watchService = new WatchService(this.archiveService, this.buildService, dockerAccess, this.mojoExecutionService, this.queryService, this.runService, logger);
            this.waitService = new WaitService(dockerAccess, this.queryService, logger);
        } else {
            this.queryService = null;
            this.registryService = null;
            this.runService = null;
            this.buildService = null;
            this.volumeService = null;
            this.watchService = null;
            this.waitService = null;
        }
    }

    public DockerAccess getDockerAccess() {
        this.checkDockerAccessInitialization();
        return this.dockerAccess;
    }

    public BuildService getBuildService() {
        this.checkDockerAccessInitialization();
        return this.buildService;
    }

    public QueryService getQueryService() {
        this.checkDockerAccessInitialization();
        return this.queryService;
    }

    public RegistryService getRegistryService() {
        this.checkDockerAccessInitialization();
        return this.registryService;
    }

    public RunService getRunService() {
        this.checkDockerAccessInitialization();
        return this.runService;
    }

    public VolumeService getVolumeService() {
        this.checkDockerAccessInitialization();
        return this.volumeService;
    }

    public WatchService getWatchService() {
        this.checkDockerAccessInitialization();
        return this.watchService;
    }

    public WaitService getWaitService() {
        this.checkDockerAccessInitialization();
        return this.waitService;
    }

    public ArchiveService getArchiveService() {
        return this.archiveService;
    }

    public MojoExecutionService getMojoExecutionService() {
        return this.mojoExecutionService;
    }

    public DockerAssemblyManager getDockerAssemblyManager() {
        return this.dockerAssemblyManager;
    }

    private synchronized void checkDockerAccessInitialization() {
        if (this.dockerAccess == null) {
            throw new IllegalStateException("Service hub created without a docker access to a docker daemon");
        }
    }
}

