/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class AuthConfig {
    public static final AuthConfig EMPTY_AUTH_CONFIG = new AuthConfig("", "", "", "");
    public static final String AUTH_USERNAME = "username";
    public static final String AUTH_PASSWORD = "password";
    public static final String AUTH_EMAIL = "email";
    public static final String AUTH_AUTH = "auth";
    public static final String AUTH_IDENTITY_TOKEN = "identityToken";
    private final String username;
    private final String password;
    private final String email;
    private final String auth;
    private final String identityToken;
    private String registry;
    private final String authEncoded;

    public AuthConfig(Map<String, String> params) {
        this(params.get(AUTH_USERNAME), params.get(AUTH_PASSWORD), params.get(AUTH_EMAIL), params.get(AUTH_AUTH), params.get(AUTH_IDENTITY_TOKEN));
    }

    public AuthConfig(String username, String password, String email, String auth) {
        this(username, password, email, auth, null);
    }

    public AuthConfig(String username, String password, String email, String auth, String identityToken) {
        this.username = username;
        this.password = password;
        this.email = email;
        this.auth = auth;
        this.identityToken = identityToken;
        this.authEncoded = this.createAuthEncoded();
    }

    public AuthConfig(String credentialsEncoded, String email) {
        this(credentialsEncoded, email, null);
    }

    public AuthConfig(String credentialsEncoded, String email, String identityToken) {
        String credentials = new String(Base64.decodeBase64((String)credentialsEncoded));
        String[] parsedCreds = credentials.split(":", 2);
        this.username = parsedCreds[0];
        this.password = parsedCreds[1];
        this.email = email;
        this.identityToken = identityToken;
        this.auth = null;
        this.authEncoded = this.createAuthEncoded();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getAuth() {
        return this.auth;
    }

    public String getIdentityToken() {
        return this.identityToken;
    }

    public String toHeaderValue() {
        return this.authEncoded;
    }

    public void setRegistry(String registry) {
        this.registry = registry;
    }

    public String toJson() {
        JsonObject creds = new JsonObject();
        creds.addProperty(AUTH_AUTH, AuthConfig.encodeBase64(this.username + ":" + this.password));
        JsonObject auths = new JsonObject();
        auths.add(this.registry != null ? this.registry : "docker.io", (JsonElement)creds);
        JsonObject root = new JsonObject();
        root.add("auths", (JsonElement)auths);
        return root.toString();
    }

    private String createAuthEncoded() {
        JsonObject ret = new JsonObject();
        if (this.identityToken != null) {
            AuthConfig.putNonNull(ret, AUTH_IDENTITY_TOKEN, this.identityToken);
        } else {
            AuthConfig.putNonNull(ret, AUTH_USERNAME, this.username);
            AuthConfig.putNonNull(ret, AUTH_PASSWORD, this.password);
            AuthConfig.putNonNull(ret, AUTH_EMAIL, this.email);
            AuthConfig.putNonNull(ret, AUTH_AUTH, this.auth);
        }
        return AuthConfig.encodeBase64(ret.toString());
    }

    private static String encodeBase64(String value) {
        return AuthConfig.encodeBase64ChunkedURLSafeString(value.getBytes(StandardCharsets.UTF_8));
    }

    private static String encodeBase64ChunkedURLSafeString(byte[] binaryData) {
        return Base64.encodeBase64String((byte[])binaryData).replace('+', '-').replace('/', '_');
    }

    private static void putNonNull(JsonObject ret, String key, String value) {
        if (value != null) {
            ret.addProperty(key, value);
        }
    }
}

