/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.assembly;

import io.fabric8.maven.docker.assembly.AllFilesExecCustomizer;
import io.fabric8.maven.docker.assembly.ArchiverCustomizer;
import io.fabric8.maven.docker.assembly.AssemblyFiles;
import io.fabric8.maven.docker.assembly.BuildDirs;
import io.fabric8.maven.docker.assembly.DockerAssemblyConfigurationSource;
import io.fabric8.maven.docker.assembly.DockerFileBuilder;
import io.fabric8.maven.docker.assembly.TrackArchiverCollection;
import io.fabric8.maven.docker.config.ArchiveCompression;
import io.fabric8.maven.docker.config.Arguments;
import io.fabric8.maven.docker.config.AssemblyConfiguration;
import io.fabric8.maven.docker.config.AssemblyMode;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.util.DockerFileUtil;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.util.MojoParameters;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugins.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugins.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugins.assembly.archive.AssemblyArchiver;
import org.apache.maven.plugins.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugins.assembly.io.AssemblyReadException;
import org.apache.maven.plugins.assembly.io.AssemblyReader;
import org.apache.maven.plugins.assembly.model.Assembly;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.PathTool;
import org.apache.maven.shared.utils.io.FileUtils;
import org.codehaus.plexus.archiver.ArchivedFileSet;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.tar.TarArchiver;
import org.codehaus.plexus.archiver.tar.TarLongFileMode;
import org.codehaus.plexus.archiver.tar.TarUnArchiver;
import org.codehaus.plexus.archiver.util.DefaultArchivedFileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.interpolation.fixed.FixedStringSearchInterpolator;

@Component(role=DockerAssemblyManager.class, instantiationStrategy="per-lookup")
public class DockerAssemblyManager {
    public static final String DEFAULT_DATA_BASE_IMAGE = "busybox:latest";
    public static final String SCRATCH_IMAGE = "scratch";
    public static final String DOCKER_IGNORE = ".maven-dockerignore";
    public static final String DOCKER_EXCLUDE = ".maven-dockerexclude";
    public static final String DOCKER_INCLUDE = ".maven-dockerinclude";
    public static final String DOCKERFILE_NAME = "Dockerfile";
    private static final String TAR_ARCHIVER_TYPE = "tar";
    @Requirement
    private AssemblyArchiver assemblyArchiver;
    @Requirement
    private AssemblyReader assemblyReader;
    @Requirement
    private ArchiverManager archiverManager;
    @Requirement
    private TrackArchiverCollection trackArchivers;

    public void extractDockerTarArchive(File archiveFile, File destinationDirectory) throws MojoExecutionException {
        TarUnArchiver.UntarCompressionMethod untarMethod = ArchiveCompression.fromFileName(archiveFile.getName()).getUnTarCompressionMethod();
        this.extractDockerTarArchive(archiveFile, destinationDirectory, untarMethod);
    }

    public void extractDockerTarArchive(File archiveFile, File destinationDirectory, TarUnArchiver.UntarCompressionMethod method) throws MojoExecutionException {
        try {
            TarUnArchiver unArchiver = (TarUnArchiver)this.archiverManager.getUnArchiver(TAR_ARCHIVER_TYPE);
            unArchiver.setCompression(method);
            unArchiver.setSourceFile(archiveFile);
            unArchiver.setDestDirectory(destinationDirectory);
            unArchiver.extract();
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("No archiver found for file " + archiveFile, (Exception)((Object)e));
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Cannot extract archive " + archiveFile, (Exception)((Object)e));
        }
    }

    public File createDockerTarArchive(String imageName, MojoParameters params, BuildImageConfiguration buildConfig, Logger log) throws MojoExecutionException {
        return this.createDockerTarArchive(imageName, params, buildConfig, log, null);
    }

    public File createDockerTarArchive(String imageName, final MojoParameters params, final BuildImageConfiguration buildConfig, Logger log, ArchiverCustomizer finalCustomizer) throws MojoExecutionException {
        final BuildDirs buildDirs = this.createBuildDirs(imageName, params);
        final List<AssemblyConfiguration> assemblyConfigurations = buildConfig.getAllAssemblyConfigurations();
        ArrayList<ArchiverCustomizer> archiveCustomizers = new ArrayList<ArchiverCustomizer>();
        if (this.hasAssemblyConfiguration(assemblyConfigurations)) {
            this.createAssemblyArchives(assemblyConfigurations, params, buildDirs);
        }
        try {
            if (buildConfig.isDockerFileMode()) {
                final File dockerFile = buildConfig.getAbsoluteDockerFilePath(params);
                if (!dockerFile.exists()) {
                    throw new MojoExecutionException("Configured Dockerfile \"" + buildConfig.getDockerFile() + "\" (resolved to \"" + dockerFile + "\") doesn't exist");
                }
                FixedStringSearchInterpolator interpolator = DockerFileUtil.createInterpolator(params, buildConfig.getFilter());
                this.verifyGivenDockerfile(dockerFile, buildConfig, interpolator, log);
                this.interpolateDockerfile(dockerFile, buildDirs, interpolator);
                archiveCustomizers.add(new ArchiverCustomizer(){

                    @Override
                    public TarArchiver customize(TarArchiver archiver) throws IOException {
                        DefaultFileSet fileSet = DefaultFileSet.fileSet((File)buildConfig.getAbsoluteContextDirPath(params));
                        DockerAssemblyManager.this.addDockerIncludesExcludesIfPresent(fileSet, params);
                        DockerAssemblyManager.this.excludeDockerfile(fileSet, dockerFile);
                        if (DockerAssemblyManager.this.isArchive(assemblyConfigurations)) {
                            String name = dockerFile.getName();
                            archiver.addFile(new File(buildDirs.getOutputDirectory(), name).getAbsoluteFile(), name);
                        }
                        archiver.addFileSet((FileSet)fileSet);
                        return archiver;
                    }
                });
            } else {
                DockerFileBuilder builder = this.createDockerFileBuilder(buildConfig, assemblyConfigurations);
                builder.write(buildDirs.getOutputDirectory());
                final File dockerFile = new File(buildDirs.getOutputDirectory(), DOCKERFILE_NAME);
                archiveCustomizers.add(new ArchiverCustomizer(){

                    @Override
                    public TarArchiver customize(TarArchiver archiver) throws IOException {
                        archiver.addFile(dockerFile, DockerAssemblyManager.DOCKERFILE_NAME);
                        return archiver;
                    }
                });
            }
            if (assemblyConfigurations.stream().anyMatch(assemblyConfig -> assemblyConfig.getPermissions() == AssemblyConfiguration.PermissionMode.exec || assemblyConfig.getPermissions() == AssemblyConfiguration.PermissionMode.auto && EnvUtil.isWindows())) {
                archiveCustomizers.add(new AllFilesExecCustomizer(log));
            }
            if (finalCustomizer != null) {
                archiveCustomizers.add(finalCustomizer);
            }
            return this.createBuildTarBall(buildDirs, archiveCustomizers, assemblyConfigurations, buildConfig.getCompression());
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Cannot create %s in %s", DOCKERFILE_NAME, buildDirs.getOutputDirectory()), (Exception)e);
        }
    }

    private void excludeDockerfile(DefaultFileSet fileSet, File dockerFile) {
        ArrayList<String> excludes = fileSet.getExcludes() != null ? new ArrayList<String>(Arrays.asList(fileSet.getExcludes())) : new ArrayList();
        excludes.add(dockerFile.getName());
        fileSet.setExcludes(excludes.toArray(new String[0]));
    }

    private void interpolateDockerfile(File dockerFile, BuildDirs params, FixedStringSearchInterpolator interpolator) throws IOException {
        File targetDockerfile = new File(params.getOutputDirectory(), dockerFile.getName());
        String dockerFileInterpolated = DockerFileUtil.interpolate(dockerFile, interpolator);
        try (FileWriter writer = new FileWriter(targetDockerfile);){
            IOUtils.write((String)dockerFileInterpolated, (Writer)writer);
        }
    }

    void verifyGivenDockerfile(File dockerFile, BuildImageConfiguration buildConfig, FixedStringSearchInterpolator interpolator, Logger log) throws IOException {
        List<AssemblyConfiguration> assemblyConfigs = buildConfig.getAllAssemblyConfigurations();
        if (assemblyConfigs.isEmpty()) {
            return;
        }
        for (AssemblyConfiguration assemblyConfig : assemblyConfigs) {
            this.verifyAssemblyReferenced(dockerFile, interpolator, log, assemblyConfig);
        }
    }

    private String firstNonOptionArgument(String[] line) {
        return Arrays.stream(line).skip(1L).filter(component -> !component.startsWith("--")).findFirst().orElse(null);
    }

    private void verifyAssemblyReferenced(File dockerFile, FixedStringSearchInterpolator interpolator, Logger log, AssemblyConfiguration assemblyConfig) throws IOException {
        String name = assemblyConfig.getName();
        for (String keyword : new String[]{"ADD", "COPY"}) {
            List<String[]> lines = DockerFileUtil.extractLines(dockerFile, keyword, interpolator);
            for (String[] line : lines) {
                String firstArg;
                if (line[0].startsWith("#") || (firstArg = this.firstNonOptionArgument(line)) == null || !firstArg.contains(name)) continue;
                return;
            }
        }
        log.warn("Dockerfile %s does not contain an ADD or COPY directive to include assembly created at %s. Ignoring assembly.", dockerFile.getPath(), name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssemblyFiles getAssemblyFiles(@Nonnull String name, AssemblyConfiguration assemblyConfig, MojoParameters mojoParams, Logger log) throws InvalidAssemblerConfigurationException, ArchiveCreationException, AssemblyFormattingException, MojoExecutionException {
        BuildDirs buildDirs = this.createBuildDirs(name, mojoParams);
        String assemblyName = assemblyConfig.getName();
        DockerAssemblyConfigurationSource source = new DockerAssemblyConfigurationSource(mojoParams, buildDirs, assemblyConfig);
        Assembly assembly = this.getAssemblyConfig(assemblyConfig, source);
        TrackArchiverCollection trackArchiverCollection = this.trackArchivers;
        synchronized (trackArchiverCollection) {
            this.trackArchivers.init(log, assemblyName);
            assembly.setId("tracker");
            File trackArchiverDestFile = this.assemblyArchiver.createArchive(assembly, assemblyName, "track", (AssemblerConfigurationSource)source, false, null);
            this.trackArchivers.get(assemblyName).setDestFile(trackArchiverDestFile);
            return this.trackArchivers.getAssemblyFiles(mojoParams.getSession(), assemblyName);
        }
    }

    private BuildDirs createBuildDirs(@Nonnull String imageName, MojoParameters params) {
        BuildDirs buildDirs = new BuildDirs(imageName, params);
        buildDirs.createDirs();
        return buildDirs;
    }

    private boolean hasAssemblyConfiguration(AssemblyConfiguration assemblyConfig) {
        return assemblyConfig != null && (assemblyConfig.getInline() != null || assemblyConfig.getDescriptor() != null || assemblyConfig.getDescriptorRef() != null);
    }

    private boolean hasAssemblyConfiguration(List<AssemblyConfiguration> assemblyConfig) {
        return assemblyConfig != null && !assemblyConfig.isEmpty() && assemblyConfig.stream().anyMatch(this::hasAssemblyConfiguration);
    }

    private boolean isArchive(AssemblyConfiguration assemblyConfig) {
        return this.hasAssemblyConfiguration(assemblyConfig) && assemblyConfig.getMode() != null && assemblyConfig.getMode().isArchive();
    }

    private boolean isArchive(List<AssemblyConfiguration> assemblyConfig) {
        return assemblyConfig != null && assemblyConfig.stream().anyMatch(this::isArchive);
    }

    public File createChangedFilesArchive(List<AssemblyFiles.Entry> entries, File assemblyDirectory, String imageName, MojoParameters mojoParameters) throws MojoExecutionException {
        BuildDirs dirs = this.createBuildDirs(imageName, mojoParameters);
        try {
            File archive = new File(dirs.getTemporaryRootDirectory(), "changed-files.tar");
            File archiveDir = this.createArchiveDir(dirs);
            for (AssemblyFiles.Entry entry : entries) {
                File dest = this.prepareChangedFilesArchivePath(archiveDir, entry.getDestFile(), assemblyDirectory);
                FileUtils.copyFile((File)entry.getSrcFile(), (File)dest);
            }
            return this.createChangedFilesTarBall(archive, archiveDir);
        }
        catch (IOException exp) {
            throw new MojoExecutionException("Error while creating " + dirs.getTemporaryRootDirectory() + "/changed-files.tar: " + exp);
        }
    }

    private File prepareChangedFilesArchivePath(File archiveDir, File destFile, File assemblyDir) throws IOException {
        String relativePath = PathTool.getRelativeFilePath((String)assemblyDir.getCanonicalPath(), (String)destFile.getCanonicalPath());
        return new File(archiveDir, relativePath);
    }

    private File createBuildTarBall(BuildDirs buildDirs, List<ArchiverCustomizer> archiverCustomizers, List<AssemblyConfiguration> assemblyConfig, ArchiveCompression compression) throws MojoExecutionException {
        File archive = new File(buildDirs.getTemporaryRootDirectory(), "docker-build." + compression.getFileSuffix());
        try {
            TarArchiver archiver = this.createBuildArchiver(buildDirs.getOutputDirectory(), archive, assemblyConfig);
            for (ArchiverCustomizer customizer : archiverCustomizers) {
                if (customizer == null) continue;
                archiver = customizer.customize(archiver);
            }
            archiver.setCompression(compression.getTarCompressionMethod());
            archiver.createArchive();
            return archive;
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("No archiver for type 'tar' found", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot create archive " + archive, (Exception)e);
        }
    }

    private void addDockerIncludesExcludesIfPresent(DefaultFileSet fileSet, MojoParameters params) throws IOException {
        this.addDockerExcludes(fileSet, params);
        this.addDockerIncludes(fileSet);
    }

    private void addDockerExcludes(DefaultFileSet fileSet, MojoParameters params) throws IOException {
        File directory = fileSet.getDirectory();
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.add(params.getOutputDirectory() + "/**");
        for (String file : new String[]{DOCKER_EXCLUDE, DOCKER_IGNORE}) {
            File dockerIgnore = new File(directory, file);
            if (!dockerIgnore.exists()) continue;
            excludes.addAll(Arrays.asList(FileUtils.fileReadArray((File)dockerIgnore)));
            excludes.add(DOCKER_IGNORE);
        }
        fileSet.setExcludes(excludes.toArray(new String[0]));
    }

    private void addDockerIncludes(DefaultFileSet fileSet) throws IOException {
        File directory = fileSet.getDirectory();
        File dockerInclude = new File(directory, DOCKER_INCLUDE);
        if (dockerInclude.exists()) {
            ArrayList<String> includes = new ArrayList<String>(Arrays.asList(FileUtils.fileReadArray((File)dockerInclude)));
            fileSet.setIncludes(includes.toArray(new String[0]));
        }
    }

    private File createChangedFilesTarBall(File archive, File archiveDir) throws MojoExecutionException {
        try {
            TarArchiver archiver = (TarArchiver)this.archiverManager.getArchiver(TAR_ARCHIVER_TYPE);
            archiver.setLongfile(TarLongFileMode.posix);
            archiver.addFileSet((FileSet)DefaultFileSet.fileSet((File)archiveDir));
            archiver.setDestFile(archive);
            archiver.createArchive();
            return archive;
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("No archiver for type 'tar' found", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot create archive " + archive, (Exception)e);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private File createArchiveDir(BuildDirs dirs) throws IOException, MojoExecutionException {
        File archiveDir = new File(dirs.getTemporaryRootDirectory(), "changed-files");
        if (archiveDir.exists()) {
            FileUtils.cleanDirectory((File)archiveDir);
        } else if (!archiveDir.mkdir()) {
            throw new MojoExecutionException("Cannot create " + archiveDir);
        }
        return archiveDir;
    }

    private TarArchiver createBuildArchiver(File outputDir, File archive, List<AssemblyConfiguration> assemblyConfigs) throws NoSuchArchiverException {
        TarArchiver archiver = (TarArchiver)this.archiverManager.getArchiver(TAR_ARCHIVER_TYPE);
        archiver.setLongfile(TarLongFileMode.posix);
        boolean needsDefaultFileSet = assemblyConfigs.isEmpty();
        for (AssemblyConfiguration assemblyConfig : assemblyConfigs) {
            AssemblyMode mode;
            AssemblyMode assemblyMode = mode = assemblyConfig != null ? assemblyConfig.getMode() : null;
            if (mode != null && mode.isArchive()) {
                DefaultArchivedFileSet archiveSet = DefaultArchivedFileSet.archivedFileSet((File)new File(outputDir, assemblyConfig.getName() + "." + mode.getExtension()));
                archiveSet.setPrefix(assemblyConfig.getName() + "/");
                archiveSet.setIncludingEmptyDirectories(true);
                archiveSet.setUsingDefaultExcludes(false);
                archiver.addArchivedFileSet((ArchivedFileSet)archiveSet);
                continue;
            }
            needsDefaultFileSet = true;
        }
        if (needsDefaultFileSet) {
            DefaultFileSet fileSet = DefaultFileSet.fileSet((File)outputDir);
            fileSet.setUsingDefaultExcludes(false);
            archiver.addFileSet((FileSet)fileSet);
        }
        archiver.setDestFile(archive);
        return archiver;
    }

    DockerFileBuilder createDockerFileBuilder(BuildImageConfiguration buildConfig, List<AssemblyConfiguration> assemblyConfigs) {
        DockerFileBuilder builder = new DockerFileBuilder().env(buildConfig.getEnv()).labels(buildConfig.getLabels()).expose(buildConfig.getPorts()).shell(buildConfig.getShell()).run(buildConfig.getRunCmds()).volumes(buildConfig.getVolumes()).user(buildConfig.getUser());
        if (buildConfig.getMaintainer() != null) {
            builder.maintainer(buildConfig.getMaintainer());
        }
        if (buildConfig.getWorkdir() != null) {
            builder.workdir(buildConfig.getWorkdir());
        }
        if (assemblyConfigs != null && !assemblyConfigs.isEmpty() && assemblyConfigs.stream().anyMatch(Objects::nonNull)) {
            for (AssemblyConfiguration assemblyConfig : assemblyConfigs) {
                if (assemblyConfig == null) continue;
                builder.add(assemblyConfig.getName(), "", assemblyConfig.getTargetDir(), assemblyConfig.getUser(), assemblyConfig.exportTargetDir()).basedir(assemblyConfig.getTargetDir()).assemblyUser(assemblyConfig.getUser()).exportTargetDir(assemblyConfig.exportTargetDir());
            }
        } else {
            builder.exportTargetDir(false);
        }
        builder.baseImage(buildConfig.getFrom());
        if (buildConfig.getHealthCheck() != null) {
            builder.healthCheck(buildConfig.getHealthCheck());
        }
        if (buildConfig.getCmd() != null) {
            builder.cmd(buildConfig.getCmd());
        } else if (buildConfig.getCommand() != null) {
            Arguments args = Arguments.Builder.get().withShell(buildConfig.getCommand()).build();
            builder.cmd(args);
        }
        if (buildConfig.getEntryPoint() != null) {
            builder.entryPoint(buildConfig.getEntryPoint());
        }
        if (buildConfig.optimise()) {
            builder.optimise();
        }
        return builder;
    }

    private void createAssemblyArchives(List<AssemblyConfiguration> assemblyConfigurations, MojoParameters params, BuildDirs buildDirs) throws MojoExecutionException {
        for (AssemblyConfiguration assemblyConfig : assemblyConfigurations) {
            this.createAssemblyArchive(assemblyConfig, params, buildDirs);
        }
    }

    private void createAssemblyArchive(AssemblyConfiguration assemblyConfig, MojoParameters params, BuildDirs buildDirs) throws MojoExecutionException {
        DockerAssemblyConfigurationSource source = new DockerAssemblyConfigurationSource(params, buildDirs, assemblyConfig);
        Assembly assembly = this.getAssemblyConfig(assemblyConfig, source);
        AssemblyMode buildMode = assemblyConfig.getMode();
        File originalArtifactFile = null;
        try {
            originalArtifactFile = this.ensureThatArtifactFileIsSet(params.getProject());
            assembly.setId("docker");
            this.assemblyArchiver.createArchive(assembly, assemblyConfig.getName(), buildMode.getExtension(), (AssemblerConfigurationSource)source, false, null);
        }
        catch (ArchiveCreationException | AssemblyFormattingException e) {
            String error = "Failed to create assembly for docker image  (with mode '" + (Object)((Object)buildMode) + "'): " + e.getMessage() + ".";
            if (params.getProject().getArtifact().getFile() == null) {
                error = error + " If you include the build artifact please ensure that you have built the artifact before with 'mvn package' (should be available in the target/ dir). Please see the documentation (section \"Assembly\") for more information.";
            }
            throw new MojoExecutionException(error, (Exception)e);
        }
        catch (InvalidAssemblerConfigurationException e) {
            throw new MojoExecutionException((Object)assembly, "Assembly is incorrectly configured: " + assembly.getId(), "Assembly: " + assembly.getId() + " is not configured correctly: " + e.getMessage());
        }
        finally {
            this.setArtifactFile(params.getProject(), originalArtifactFile);
        }
    }

    private File ensureThatArtifactFileIsSet(MavenProject project) {
        Artifact artifact = project.getArtifact();
        if (artifact == null) {
            return null;
        }
        File oldFile = artifact.getFile();
        if (oldFile != null) {
            return oldFile;
        }
        Build build = project.getBuild();
        if (build == null) {
            return null;
        }
        String finalName = build.getFinalName();
        String target = build.getDirectory();
        if (finalName == null || target == null) {
            return null;
        }
        File artifactFile = new File(target, finalName + "." + project.getPackaging());
        if (artifactFile.exists() && artifactFile.isFile()) {
            this.setArtifactFile(project, artifactFile);
        }
        return null;
    }

    private void setArtifactFile(MavenProject project, File artifactFile) {
        Artifact artifact = project.getArtifact();
        if (artifact != null) {
            artifact.setFile(artifactFile);
        }
    }

    private Assembly getAssemblyConfig(AssemblyConfiguration assemblyConfig, DockerAssemblyConfigurationSource source) throws MojoExecutionException {
        Assembly assembly = assemblyConfig.getInline();
        if (assembly == null) {
            assembly = this.extractAssembly(source);
        }
        return assembly;
    }

    private Assembly extractAssembly(AssemblerConfigurationSource config) throws MojoExecutionException {
        try {
            List assemblies = this.assemblyReader.readAssemblies(config);
            if (assemblies.size() != 1) {
                throw new MojoExecutionException("Only one assembly can be used for creating a Docker base image (and not " + assemblies.size() + ")");
            }
            return (Assembly)assemblies.get(0);
        }
        catch (AssemblyReadException e) {
            throw new MojoExecutionException("Error reading assembly: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (InvalidAssemblerConfigurationException e) {
            throw new MojoExecutionException((Object)this.assemblyReader, e.getMessage(), "Docker assembly configuration is invalid: " + e.getMessage());
        }
    }
}

