/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImageName {
    private String repository;
    private String registry;
    private String tag;
    private String digest;
    private String user;
    private final String nameComponentRegexp = "[a-z0-9]+(?:(?:(?:[._]|__|[-]*)[a-z0-9]+)+)?";
    private final String domainComponentRegexp = "(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9])";
    private final Pattern NAME_COMP_REGEXP = Pattern.compile("[a-z0-9]+(?:(?:(?:[._]|__|[-]*)[a-z0-9]+)+)?");
    private final Pattern IMAGE_NAME_REGEXP = Pattern.compile("[a-z0-9]+(?:(?:(?:[._]|__|[-]*)[a-z0-9]+)+)?(?:(?:/[a-z0-9]+(?:(?:(?:[._]|__|[-]*)[a-z0-9]+)+)?)+)?");
    private final Pattern DOMAIN_REGEXP = Pattern.compile("^(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9])(?:\\.(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]))*(?::[0-9]+)?$");
    private final Pattern TAG_REGEXP = Pattern.compile("^[\\w][\\w.-]{0,127}$");
    private final Pattern DIGEST_REGEXP = Pattern.compile("^sha256:[a-z0-9]{32,}$");

    public ImageName(String fullName) {
        this(fullName, null);
    }

    public ImageName(String fullName, String givenTag) {
        Pattern tagPattern;
        Matcher matcher;
        if (fullName == null) {
            throw new NullPointerException("Image name must not be null");
        }
        this.digest = null;
        if (fullName.contains("@sha256")) {
            String[] digestParts = fullName.split("@");
            this.digest = digestParts[1];
            fullName = digestParts[0];
        }
        if (!(matcher = (tagPattern = Pattern.compile("^(.+?)(?::([^:/]+))?$")).matcher(fullName)).matches()) {
            throw new IllegalArgumentException(fullName + " is not a proper image name ([registry/][repo][:port]");
        }
        this.tag = givenTag != null ? givenTag : matcher.group(2);
        String rest = matcher.group(1);
        this.parseComponentsBeforeTag(rest);
        if (this.tag == null && this.digest == null) {
            this.tag = "latest";
        }
        this.doValidate();
    }

    public String getRepository() {
        return this.repository;
    }

    public String getRegistry() {
        return this.registry;
    }

    public String getTag() {
        return this.tag;
    }

    public String getDigest() {
        return this.digest;
    }

    public boolean hasRegistry() {
        return this.registry != null && this.registry.length() > 0;
    }

    private String joinTail(String[] parts) {
        StringBuilder builder = new StringBuilder();
        for (int i = 1; i < parts.length; ++i) {
            builder.append(parts[i]);
            if (i >= parts.length - 1) continue;
            builder.append("/");
        }
        return builder.toString();
    }

    private boolean isRegistry(String part) {
        return part.contains(".") || part.contains(":");
    }

    public String getNameWithoutTag() {
        return this.getNameWithoutTag(null);
    }

    public String getNameWithoutTag(String optionalRegistry) {
        StringBuilder ret = new StringBuilder();
        if (this.registry != null || optionalRegistry != null) {
            ret.append(this.registry != null ? this.registry : optionalRegistry).append("/");
        }
        ret.append(this.repository);
        return ret.toString();
    }

    public String getFullName() {
        return this.getFullName(null);
    }

    public String getFullName(String optionalRegistry) {
        String fullName = this.getNameWithoutTag(optionalRegistry);
        if (this.tag != null) {
            fullName = fullName + ":" + this.tag;
        }
        if (this.digest != null) {
            fullName = fullName + "@" + this.digest;
        }
        return fullName;
    }

    public String getUser() {
        return this.user;
    }

    public String getSimpleName() {
        String prefix = this.user + "/";
        return this.repository.startsWith(prefix) ? this.repository.substring(prefix.length()) : this.repository;
    }

    public String getNameWithOptionalRepository(String optionalRepository) {
        String simpleName;
        String[] simpleNameParts;
        if (optionalRepository != null && (simpleNameParts = (simpleName = this.getFullName()).split("/")).length > 0) {
            return optionalRepository + "/" + simpleNameParts[simpleNameParts.length - 1];
        }
        return this.getFullName();
    }

    public static void validate(String image) {
        new ImageName(image);
    }

    private void doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        String image = this.user != null ? this.repository.substring(this.user.length() + 1) : this.repository;
        Object[] checks = new Object[]{"registry", this.DOMAIN_REGEXP, this.registry, "image", this.IMAGE_NAME_REGEXP, image, "user", this.NAME_COMP_REGEXP, this.user, "tag", this.TAG_REGEXP, this.tag, "digest", this.DIGEST_REGEXP, this.digest};
        for (int i = 0; i < checks.length; i += 3) {
            String value = (String)checks[i + 2];
            Pattern checkPattern = (Pattern)checks[i + 1];
            if (value == null || checkPattern.matcher(value).matches()) continue;
            errors.add(String.format("%s part '%s' doesn't match allowed pattern '%s'", checks[i], value, checkPattern.pattern()));
        }
        if (errors.size() > 0) {
            StringBuilder buf = new StringBuilder();
            buf.append(String.format("Given Docker name '%s' is invalid:\n", this.getFullName()));
            for (String error : errors) {
                buf.append(String.format("   * %s\n", error));
            }
            buf.append("See http://bit.ly/docker_image_fmt for more details");
            throw new IllegalArgumentException(buf.toString());
        }
    }

    private void parseComponentsBeforeTag(String rest) {
        String[] parts = rest.split("\\s*/\\s*");
        if (parts.length == 1) {
            this.registry = null;
            this.user = null;
            this.repository = parts[0];
        } else if (parts.length >= 2) {
            if (this.isRegistry(parts[0])) {
                this.registry = parts[0];
                if (parts.length > 2) {
                    this.user = parts[1];
                    this.repository = this.joinTail(parts);
                } else {
                    this.user = null;
                    this.repository = parts[1];
                }
            } else {
                this.registry = null;
                this.user = parts[0];
                this.repository = rest;
            }
        }
    }
}

