/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config;

import io.fabric8.maven.docker.config.WatchMode;
import io.fabric8.maven.docker.util.DeepCopy;
import java.io.Serializable;
import org.apache.maven.plugins.annotations.Parameter;

public class WatchImageConfiguration
implements Serializable {
    @Parameter
    private Integer interval;
    @Parameter
    private WatchMode mode;
    @Parameter
    private String postGoal;
    @Parameter
    private String postExec;

    public int getInterval() {
        return this.interval != null ? this.interval : 5000;
    }

    public Integer getIntervalRaw() {
        return this.interval;
    }

    public WatchMode getMode() {
        return this.mode;
    }

    public String getPostGoal() {
        return this.postGoal;
    }

    public String getPostExec() {
        return this.postExec;
    }

    public static class Builder {
        private final WatchImageConfiguration c;

        public Builder() {
            this(null);
        }

        public Builder(WatchImageConfiguration that) {
            this.c = that == null ? new WatchImageConfiguration() : DeepCopy.copy(that);
        }

        public Builder interval(Integer interval) {
            this.c.interval = interval;
            return this;
        }

        public Builder mode(String mode) {
            if (mode != null) {
                this.c.mode = WatchMode.valueOf(mode.toLowerCase());
            }
            return this;
        }

        public Builder postGoal(String goal) {
            this.c.postGoal = goal;
            return this;
        }

        public Builder postExec(String exec) {
            this.c.postExec = exec;
            return this;
        }

        public WatchImageConfiguration build() {
            return this.c;
        }
    }
}

