/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.service;

import io.fabric8.maven.docker.access.AuthConfigList;
import io.fabric8.maven.docker.access.DockerAccess;
import io.fabric8.maven.docker.assembly.BuildDirs;
import io.fabric8.maven.docker.assembly.DockerAssemblyManager;
import io.fabric8.maven.docker.config.AttestationConfiguration;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.BuildXConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.util.ProjectPaths;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.maven.plugin.MojoExecutionException;

public class BuildXService {
    private final DockerAccess dockerAccess;
    private final DockerAssemblyManager dockerAssemblyManager;
    private final Logger logger;
    private final Exec exec;

    public BuildXService(DockerAccess dockerAccess, DockerAssemblyManager dockerAssemblyManager, Logger logger) {
        this(dockerAccess, dockerAssemblyManager, logger, new DefaultExec(logger));
    }

    public BuildXService(DockerAccess dockerAccess, DockerAssemblyManager dockerAssemblyManager, Logger logger, Exec exec) {
        this.dockerAccess = dockerAccess;
        this.dockerAssemblyManager = dockerAssemblyManager;
        this.logger = logger;
        this.exec = exec;
    }

    public void build(ProjectPaths projectPaths, ImageConfiguration imageConfig, String configuredRegistry, AuthConfigList authConfig, File buildArchive) throws MojoExecutionException {
        this.useBuilder(projectPaths, imageConfig, configuredRegistry, authConfig, buildArchive, this::buildAndLoadSinglePlatform);
    }

    public void push(ProjectPaths projectPaths, ImageConfiguration imageConfig, String configuredRegistry, AuthConfigList authConfig) throws MojoExecutionException {
        BuildDirs buildDirs = new BuildDirs(projectPaths, imageConfig.getName());
        File archive = new File(buildDirs.getTemporaryRootDirectory(), "docker-build.tar");
        this.useBuilder(projectPaths, imageConfig, configuredRegistry, authConfig, archive, this::pushMultiPlatform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <C> void useBuilder(ProjectPaths projectPaths, ImageConfiguration imageConfig, String configuredRegistry, AuthConfigList authConfig, C context, Builder<C> builder) throws MojoExecutionException {
        BuildDirs buildDirs = new BuildDirs(projectPaths, imageConfig.getName());
        Path configPath = this.getDockerStateDir(imageConfig.getBuildConfiguration(), buildDirs);
        File[] configDirFiles = configPath.toFile().listFiles();
        ArrayList<String> buildX = new ArrayList<String>();
        buildX.add("docker");
        if (configDirFiles != null && configDirFiles.length > 0) {
            buildX.add("--config");
            buildX.add(configPath.toString());
        }
        buildX.add("buildx");
        String builderName = this.createBuilder(configPath, buildX, imageConfig, buildDirs);
        Path configJson = configPath.resolve("config.json");
        try {
            this.createConfigJson(configJson, authConfig);
            builder.useBuilder(buildX, builderName, buildDirs, imageConfig, configuredRegistry, context);
        }
        finally {
            this.removeConfigJson(configJson);
        }
    }

    protected void createConfigJson(Path configJson, AuthConfigList authConfig) throws MojoExecutionException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(configJson, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            bufferedWriter.write(authConfig != null ? authConfig.toJson() : "{}");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create config.json", (Exception)e);
        }
    }

    protected void removeConfigJson(Path configJson) {
        try {
            Files.deleteIfExists(configJson);
        }
        catch (IOException e) {
            this.logger.warn("Unable to delete %s", configJson);
        }
    }

    protected void buildAndLoadSinglePlatform(List<String> buildX, String builderName, BuildDirs buildDirs, ImageConfiguration imageConfig, String configuredRegistry, File buildArchive) throws MojoExecutionException {
        List<String> platforms = imageConfig.getBuildConfiguration().getBuildX().getPlatforms();
        String nativePlatform = this.dockerAccess.getNativePlatform();
        if (platforms.size() == 1) {
            this.buildX(buildX, builderName, buildDirs, imageConfig, configuredRegistry, platforms, buildArchive, "--load");
        } else if (platforms.contains(nativePlatform)) {
            this.buildX(buildX, builderName, buildDirs, imageConfig, configuredRegistry, Collections.singletonList(nativePlatform), buildArchive, "--load");
        } else {
            this.logger.info("More than one platform specified not including native %s, no image built", nativePlatform);
        }
    }

    protected void pushMultiPlatform(List<String> buildX, String builderName, BuildDirs buildDirs, ImageConfiguration imageConfig, String configuredRegistry, File buildArchive) throws MojoExecutionException {
        this.buildX(buildX, builderName, buildDirs, imageConfig, configuredRegistry, imageConfig.getBuildConfiguration().getBuildX().getPlatforms(), buildArchive, "--push");
    }

    protected void buildX(List<String> buildX, String builderName, BuildDirs buildDirs, ImageConfiguration imageConfig, String configuredRegistry, List<String> platforms, File buildArchive, String extraParam) throws MojoExecutionException {
        int rc;
        File contextDir;
        AttestationConfiguration attestations;
        BuildImageConfiguration buildConfiguration = imageConfig.getBuildConfiguration();
        ArrayList<String> cmdLine = new ArrayList<String>(buildX);
        BuildXService.append(cmdLine, "build", "--progress=plain", "--builder", builderName, "--platform", String.join((CharSequence)",", platforms), "--tag", new ImageName(imageConfig.getName()).getFullName(configuredRegistry));
        buildConfiguration.getTags().forEach(t -> {
            cmdLine.add("--tag");
            cmdLine.add(new ImageName(imageConfig.getName(), (String)t).getFullName(configuredRegistry));
        });
        Map<String, String> args = buildConfiguration.getArgs();
        if (args != null) {
            args.forEach((key, value) -> {
                cmdLine.add("--build-arg");
                cmdLine.add(key + '=' + value);
            });
        }
        if ((attestations = buildConfiguration.getBuildX().getAttestations()) != null) {
            String provenance;
            if (Boolean.TRUE.equals(attestations.getSbom())) {
                cmdLine.add("--sbom=true");
            }
            if ((provenance = attestations.getProvenance()) != null) {
                switch (provenance) {
                    case "min": 
                    case "max": {
                        cmdLine.add("--provenance=mode=" + provenance);
                        break;
                    }
                    case "false": 
                    case "true": {
                        cmdLine.add("--provenance=" + provenance);
                        break;
                    }
                    default: {
                        this.logger.error("Unsupported provenance mode %s", provenance);
                    }
                }
            }
        }
        if (buildConfiguration.squash()) {
            cmdLine.add("--squash");
        }
        if ((contextDir = buildConfiguration.getContextDir()) != null) {
            Path destinationPath = this.getContextPath(buildArchive);
            Path dockerFileRelativePath = contextDir.toPath().relativize(buildConfiguration.getDockerFile().toPath());
            BuildXService.append(cmdLine, "--file=" + destinationPath.resolve(dockerFileRelativePath), destinationPath.toString());
        } else {
            cmdLine.add(buildDirs.getOutputDirectory().getAbsolutePath());
        }
        if (extraParam != null) {
            cmdLine.add(extraParam);
        }
        if ((rc = this.exec.process(cmdLine)) != 0) {
            throw new MojoExecutionException("Error status (" + rc + ") when building");
        }
    }

    protected Path getContextPath(File buildArchive) throws MojoExecutionException {
        String archiveName = buildArchive.getName();
        String fileName = archiveName.substring(0, archiveName.indexOf(46));
        File destinationDirectory = new File(buildArchive.getParentFile(), fileName);
        Path destinationPath = destinationDirectory.toPath();
        try {
            Files.createDirectories(destinationPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        this.dockerAssemblyManager.extractDockerTarArchive(buildArchive, destinationDirectory);
        return destinationPath;
    }

    protected Path getDockerStateDir(BuildImageConfiguration buildConfiguration, BuildDirs buildDirs) {
        String stateDir = buildConfiguration.getBuildX().getDockerStateDir();
        Path dockerStatePath = buildDirs.getBuildPath(stateDir != null ? EnvUtil.resolveHomeReference(stateDir) : "docker");
        this.createDirectory(dockerStatePath);
        return dockerStatePath;
    }

    protected void createDirectory(Path cachePath) {
        try {
            Files.createDirectories(cachePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot create " + cachePath);
        }
    }

    protected String createBuilder(Path configPath, List<String> buildX, ImageConfiguration imageConfig, BuildDirs buildDirs) throws MojoExecutionException {
        Path builderPath;
        BuildXConfiguration buildXConfiguration = imageConfig.getBuildConfiguration().getBuildX();
        String builderName = buildXConfiguration.getBuilderName();
        if (builderName == null) {
            builderName = "maven";
        }
        if (Files.notExists(builderPath = configPath.resolve(Paths.get("buildx", "instances", builderName)), new LinkOption[0])) {
            int rc;
            ArrayList<String> cmds = new ArrayList<String>(buildX);
            BuildXService.append(cmds, "create", "--driver", "docker-container", "--name", builderName, "--node", builderName + "0");
            String buildConfig = buildXConfiguration.getConfigFile();
            if (buildConfig != null) {
                BuildXService.append(cmds, "--config", buildDirs.getProjectPath(EnvUtil.resolveHomeReference(buildConfig)).toString());
            }
            if ((rc = this.exec.process(cmds)) != 0) {
                throw new MojoExecutionException("Error status (" + rc + ") while creating builder " + builderName);
            }
        }
        return builderName;
    }

    public static <T> List<T> append(List<T> collection, T ... members) {
        collection.addAll(Arrays.asList(members));
        return collection;
    }

    public static class DefaultExec
    implements Exec {
        private final Logger logger;

        public DefaultExec(Logger logger) {
            this.logger = logger;
        }

        @Override
        public int process(List<String> cmdArgs) throws MojoExecutionException {
            try {
                this.logger.info(String.join((CharSequence)" ", cmdArgs), new Object[0]);
                ProcessBuilder builder = new ProcessBuilder(cmdArgs);
                Process process = builder.start();
                this.pumpStream(process.getInputStream());
                this.pumpStream(process.getErrorStream());
                return process.waitFor();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new MojoExecutionException("Interrupted while executing " + cmdArgs, (Exception)ex);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("unable to execute " + cmdArgs, (Exception)ex);
            }
        }

        private void pumpStream(InputStream is) {
            CompletableFuture.runAsync(() -> {
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));){
                    bufferedReader.lines().forEach(x$0 -> this.logger.info((String)x$0, new Object[0]));
                }
                catch (IOException e) {
                    this.logger.error("failed redirecting stream %s", e.getMessage());
                }
            });
        }
    }

    public static interface Exec {
        public int process(List<String> var1) throws MojoExecutionException;
    }

    static interface Builder<C> {
        public void useBuilder(List<String> var1, String var2, BuildDirs var3, ImageConfiguration var4, String var5, C var6) throws MojoExecutionException;
    }
}

