/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util.aws;

import io.fabric8.maven.docker.access.AuthConfig;
import io.fabric8.maven.docker.util.Logger;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class AwsSdkAuthConfigFactory {
    private final Logger log;

    public AwsSdkAuthConfigFactory(Logger log) {
        this.log = log;
    }

    public AuthConfig createAuthConfig() {
        try {
            Class<?> credentialsProviderChainClass = Class.forName("com.amazonaws.auth.DefaultAWSCredentialsProviderChain");
            Object credentialsProviderChain = credentialsProviderChainClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Object credentials = credentialsProviderChainClass.getMethod("getCredentials", new Class[0]).invoke(credentialsProviderChain, new Object[0]);
            if (credentials == null) {
                return null;
            }
            Class<?> sessionCredentialsClass = Class.forName("com.amazonaws.auth.AWSSessionCredentials");
            String sessionToken = sessionCredentialsClass.isInstance(credentials) ? (String)sessionCredentialsClass.getMethod("getSessionToken", new Class[0]).invoke(credentials, new Object[0]) : null;
            Class<?> credentialsClass = Class.forName("com.amazonaws.auth.AWSCredentials");
            return new AuthConfig((String)credentialsClass.getMethod("getAWSAccessKeyId", new Class[0]).invoke(credentials, new Object[0]), (String)credentialsClass.getMethod("getAWSSecretKey", new Class[0]).invoke(credentials, new Object[0]), "none", sessionToken);
        }
        catch (Throwable t) {
            String issueTitle = null;
            try {
                issueTitle = URLEncoder.encode("Failed calling AWS SDK: " + t.getMessage(), StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.log.warn("Failed to fetch AWS credentials: %s", t.getMessage());
            if (t.getCause() != null) {
                this.log.warn("Caused by: %s", t.getCause().getMessage());
            }
            this.log.warn("Please report a bug at https://github.com/fabric8io/docker-maven-plugin/issues/new?%s", issueTitle == null ? "" : "title=?" + issueTitle);
            this.log.warn("%s", t);
            return null;
        }
    }
}

