/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.assembly;

import io.fabric8.maven.docker.assembly.AssemblyFiles;
import io.fabric8.maven.docker.assembly.MappingTrackArchiver;
import io.fabric8.maven.docker.util.Logger;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;

@Singleton
@Named
public class TrackArchiverCollection {
    private final Map<String, MappingTrackArchiver> archivers = new HashMap<String, MappingTrackArchiver>();

    public AssemblyFiles getAssemblyFiles(MavenSession session, String assemblyName) {
        if (this.archivers.containsKey(assemblyName)) {
            return this.archivers.get(assemblyName).getAssemblyFiles(session);
        }
        return null;
    }

    public MappingTrackArchiver get(String assemblyName) {
        return this.archivers.get(assemblyName);
    }

    public void init(Logger log, String assemblyName) {
        MappingTrackArchiver archiver = this.archivers.computeIfAbsent(assemblyName, k -> new MappingTrackArchiver());
        archiver.init(log, assemblyName);
    }
}

