/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util;

import io.fabric8.maven.docker.config.ConfigHelper;
import io.fabric8.maven.docker.util.FormatParameterReplacer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.project.MavenProject;

public class ImageNameFormatter
implements ConfigHelper.NameFormatter {
    public static final String TIMESTAMP_FORMAT = "yyMMdd-HHmmss-SSSS";
    private final FormatParameterReplacer formatParamReplacer;
    private final Date now;

    public ImageNameFormatter(MavenProject project, Date now) {
        this.now = now;
        this.formatParamReplacer = new FormatParameterReplacer(this.initLookups(project));
    }

    @Override
    public String format(String name) {
        if (name == null) {
            return null;
        }
        return this.formatParamReplacer.replace(name);
    }

    private Map<String, FormatParameterReplacer.Lookup> initLookups(MavenProject project) {
        HashMap<String, FormatParameterReplacer.Lookup> lookups = new HashMap<String, FormatParameterReplacer.Lookup>();
        lookups.put("g", new DefaultUserLookup(project));
        lookups.put("a", new DefaultNameLookup(project));
        lookups.put("v", new DefaultTagLookup(project, DefaultTagLookup.Mode.PLAIN, this.now));
        lookups.put("t", new DefaultTagLookup(project, DefaultTagLookup.Mode.SNAPSHOT_WITH_TIMESTAMP, this.now));
        lookups.put("l", new DefaultTagLookup(project, DefaultTagLookup.Mode.SNAPSHOT_LATEST, this.now));
        lookups.put("T", new DefaultTimestampLookup(project, this.now));
        return lookups;
    }

    private static String sanitizeName(String name) {
        StringBuilder ret = new StringBuilder();
        int underscores = 0;
        boolean lastWasADot = false;
        for (char c : name.toCharArray()) {
            if (c == '_') {
                if (++underscores > 2) continue;
                ret.append(c);
                continue;
            }
            if (c == '.') {
                if (!lastWasADot) {
                    ret.append(c);
                }
                lastWasADot = true;
                continue;
            }
            underscores = 0;
            lastWasADot = false;
            if (!Character.isLetter(c) && !Character.isDigit(c) && c != '-') continue;
            ret.append(c);
        }
        return ret.toString().toLowerCase();
    }

    private static class DefaultTimestampLookup
    extends AbstractLookup {
        private final Date now;

        private DefaultTimestampLookup(MavenProject project, Date now) {
            super(project);
            this.now = now;
        }

        @Override
        public String lookup() {
            return new SimpleDateFormat(ImageNameFormatter.TIMESTAMP_FORMAT).format(this.now);
        }
    }

    private static class DefaultTagLookup
    extends AbstractLookup {
        private static final String DOCKER_IMAGE_TAG = "docker.image.tag";
        private final Mode mode;
        private final Date now;

        private DefaultTagLookup(MavenProject project, Mode mode, Date now) {
            super(project);
            this.mode = mode;
            this.now = now;
        }

        @Override
        public String lookup() {
            String tag = this.getProperty(DOCKER_IMAGE_TAG);
            return this.mode.transform(this.project, tag, this.now);
        }

        private static enum Mode {
            PLAIN('v'){

                @Override
                public String doTransform(String tag, Date now) {
                    return tag;
                }
            }
            ,
            SNAPSHOT_WITH_TIMESTAMP('t'){

                @Override
                public String doTransform(String tag, Date now) {
                    if (tag.endsWith("-SNAPSHOT")) {
                        return "snapshot-" + new SimpleDateFormat(ImageNameFormatter.TIMESTAMP_FORMAT).format(now);
                    }
                    return tag;
                }
            }
            ,
            SNAPSHOT_LATEST('l'){

                @Override
                public String doTransform(String tag, Date now) {
                    if (tag.endsWith("-SNAPSHOT")) {
                        return "latest";
                    }
                    return tag;
                }
            };

            private final char letter;

            private Mode(char letter) {
                this.letter = letter;
            }

            protected abstract String doTransform(String var1, Date var2);

            public String transform(MavenProject project, String tag, Date now) {
                if (tag == null || tag.trim().isEmpty() || tag.equals("%" + this.letter)) {
                    tag = project.getVersion();
                }
                return this.doTransform(tag, now);
            }
        }
    }

    private static class DefaultNameLookup
    extends AbstractLookup {
        private DefaultNameLookup(MavenProject project) {
            super(project);
        }

        @Override
        public String lookup() {
            return ImageNameFormatter.sanitizeName(this.project.getArtifactId());
        }
    }

    private static class DefaultUserLookup
    extends AbstractLookup {
        private static final String DOCKER_IMAGE_USER = "docker.image.user";

        private DefaultUserLookup(MavenProject project) {
            super(project);
        }

        @Override
        public String lookup() {
            String user = this.getProperty(DOCKER_IMAGE_USER);
            if (user != null) {
                return user;
            }
            String groupId = this.project.getGroupId();
            while (groupId.endsWith(".")) {
                groupId = groupId.substring(0, groupId.length() - 1);
            }
            int idx = groupId.lastIndexOf(".");
            return ImageNameFormatter.sanitizeName(groupId.substring(idx != -1 ? idx + 1 : 0));
        }
    }

    public static abstract class AbstractLookup
    implements FormatParameterReplacer.Lookup {
        protected final MavenProject project;

        private AbstractLookup(MavenProject project) {
            this.project = project;
        }

        protected String getProperty(String key) {
            return this.project.getProperties().getProperty(key);
        }
    }
}

