/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.model;

import com.google.common.base.Joiner;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.fabric8.maven.docker.model.Container;
import io.fabric8.maven.docker.model.PortBindingException;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ContainerDetails
implements Container {
    static final String CONFIG = "Config";
    static final String CREATED = "Created";
    static final String HOST_IP = "HostIp";
    static final String HOST_PORT = "HostPort";
    static final String ID = "Id";
    static final String IMAGE = "Image";
    static final String LABELS = "Labels";
    static final String NAME = "Name";
    static final String IP = "IPAddress";
    static final String HOST_CONFIG = "HostConfig";
    static final String NETWORK_MODE = "NetworkMode";
    static final String NETWORK_SETTINGS = "NetworkSettings";
    static final String NETWORKS = "Networks";
    static final String PORTS = "Ports";
    static final String SLASH = "/";
    static final String STATE = "State";
    static final String HEALTH = "Health";
    static final String STATUS = "Status";
    static final String HEALTH_STATUS_HEALTHY = "healthy";
    static final String HEALTHCHECK = "Healthcheck";
    static final String TEST = "Test";
    private static final String EXIT_CODE = "ExitCode";
    private static final String RUNNING = "Running";
    private final JsonObject json;

    public ContainerDetails(JsonObject json) {
        this.json = json;
    }

    @Override
    public long getCreated() {
        String date = this.json.get(CREATED).getAsString();
        Instant instant = Instant.parse(date);
        return instant.toEpochMilli();
    }

    @Override
    public String getId() {
        return this.json.get(ID).getAsString().substring(0, 12);
    }

    @Override
    public String getImage() {
        return this.json.getAsJsonObject(CONFIG).get(IMAGE).getAsString();
    }

    @Override
    public Map<String, String> getLabels() {
        JsonObject config = this.json.getAsJsonObject(CONFIG);
        return config.has(LABELS) ? this.mapLabels(config.getAsJsonObject(LABELS)) : Collections.emptyMap();
    }

    @Override
    public String getName() {
        String name = this.json.get(NAME).getAsString();
        return name.startsWith(SLASH) ? name.substring(1) : name;
    }

    @Override
    public String getIPAddress() {
        if (this.json.has(NETWORK_SETTINGS) && !this.json.get(NETWORK_SETTINGS).isJsonNull()) {
            JsonObject networkSettings = this.json.getAsJsonObject(NETWORK_SETTINGS);
            if (networkSettings.has(IP) && !networkSettings.get(IP).isJsonNull()) {
                return networkSettings.get(IP).getAsString();
            }
            if (networkSettings.has(NETWORKS) && !networkSettings.get(NETWORKS).isJsonNull()) {
                JsonObject networks = networkSettings.getAsJsonObject(NETWORKS);
                for (String networkName : networks.keySet()) {
                    JsonObject network = networks.getAsJsonObject(networkName);
                    if (!network.has(IP) || network.get(IP).isJsonNull()) continue;
                    return network.get(IP).getAsString();
                }
            }
        }
        return null;
    }

    @Override
    public String getNetworkMode() {
        JsonObject hostConfig;
        if (this.json.has(HOST_CONFIG) && !this.json.get(HOST_CONFIG).isJsonNull() && !(hostConfig = this.json.getAsJsonObject(HOST_CONFIG)).get(NETWORK_MODE).isJsonNull()) {
            return hostConfig.get(NETWORK_MODE).getAsString();
        }
        return null;
    }

    @Override
    public Map<String, String> getCustomNetworkIpAddresses() {
        JsonObject networkSettings;
        if (this.json.has(NETWORK_SETTINGS) && !this.json.get(NETWORK_SETTINGS).isJsonNull() && (networkSettings = this.json.getAsJsonObject(NETWORK_SETTINGS)).has(NETWORKS) && !networkSettings.get(NETWORKS).isJsonNull()) {
            return this.extractNetworks(networkSettings);
        }
        return null;
    }

    private Map<String, String> extractNetworks(JsonObject networkSettings) {
        JsonObject networks = networkSettings.getAsJsonObject(NETWORKS);
        Set keys = networks.keySet();
        if (keys == null || keys.isEmpty()) {
            return null;
        }
        HashMap<String, String> results = new HashMap<String, String>();
        for (String key : keys) {
            JsonObject net = networks.getAsJsonObject(key);
            if (!net.has(IP) || net.get(IP).isJsonNull()) continue;
            results.put(key, net.get(IP).getAsString());
        }
        return results;
    }

    @Override
    public Map<String, Container.PortBinding> getPortBindings() {
        JsonObject networkSettings;
        if (this.json.has(NETWORK_SETTINGS) && !this.json.get(NETWORK_SETTINGS).isJsonNull() && (networkSettings = this.json.getAsJsonObject(NETWORK_SETTINGS)).has(PORTS) && !networkSettings.get(PORTS).isJsonNull()) {
            return this.createPortBindings(networkSettings.getAsJsonObject(PORTS));
        }
        return new HashMap<String, Container.PortBinding>();
    }

    @Override
    public boolean isRunning() {
        JsonObject state = this.json.getAsJsonObject(STATE);
        return state.get(RUNNING).getAsBoolean();
    }

    @Override
    public Integer getExitCode() {
        if (this.isRunning()) {
            return null;
        }
        JsonObject state = this.json.getAsJsonObject(STATE);
        return state.get(EXIT_CODE).getAsInt();
    }

    public boolean isHealthy() {
        JsonObject state = this.json.getAsJsonObject(STATE);
        return !state.has(HEALTH) || HEALTH_STATUS_HEALTHY.equals(state.getAsJsonObject(HEALTH).get(STATUS).getAsString());
    }

    public String getHealthcheck() {
        if (!this.json.getAsJsonObject(CONFIG).has(HEALTHCHECK) || !this.json.getAsJsonObject(CONFIG).getAsJsonObject(HEALTHCHECK).has(TEST)) {
            return null;
        }
        return Joiner.on((String)", ").join((Iterable)this.json.getAsJsonObject(CONFIG).getAsJsonObject(HEALTHCHECK).getAsJsonArray(TEST));
    }

    private void addPortMapping(String port, JsonObject hostConfig, Map<String, Container.PortBinding> portBindings) {
        String hostIp = hostConfig.get(HOST_IP).getAsString();
        Integer hostPort = hostConfig.get(HOST_PORT).getAsInt();
        this.addPortMapping(port, new Container.PortBinding(hostPort, hostIp), portBindings);
    }

    private void addPortMapping(String port, Container.PortBinding binding, Map<String, Container.PortBinding> portBindings) {
        if (port.indexOf(47) == -1) {
            port = port + "/tcp";
        }
        portBindings.put(port, binding);
    }

    private Map<String, Container.PortBinding> createPortBindings(JsonObject ports) {
        HashMap<String, Container.PortBinding> portBindings = new HashMap<String, Container.PortBinding>();
        for (Object obj : ports.keySet()) {
            String port = obj.toString();
            if (ports.get(port).isJsonNull()) {
                this.addPortMapping(port, (Container.PortBinding)null, portBindings);
                continue;
            }
            JsonArray hostMappings = ports.getAsJsonArray(port);
            if (hostMappings.isJsonNull() || hostMappings.size() == 0) {
                throw new PortBindingException(port, ports);
            }
            JsonObject hostConfig = hostMappings.get(0).getAsJsonObject();
            this.addPortMapping(port, hostConfig, portBindings);
        }
        return portBindings;
    }

    private Map<String, String> mapLabels(JsonObject labels) {
        int length = labels.size();
        HashMap<String, String> mapped = new HashMap<String, String>(length);
        for (String key : labels.keySet()) {
            mapped.put(key, labels.get(key).getAsString());
        }
        return mapped;
    }
}

